/*
 * Copyright 2016-2023 47 Degrees Open Source <https://www.47deg.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package github4s.domain

final case class SearchResultTextMatch(
    object_url: String,
    object_type: Option[String],
    property: String,
    fragment: String,
    matches: List[SearchResultTextMatchLocation]
)

final case class SearchResultTextMatchLocation(
    text: String,
    indices: List[Int]
)

sealed abstract class ComparisonOperator(val value: String)
case object LesserThan          extends ComparisonOperator("<=")
case object StrictlyLesserThan  extends ComparisonOperator("<")
case object GreaterThan         extends ComparisonOperator(">=")
case object StrictlyGreaterThan extends ComparisonOperator(">")
