/*
 * Decompiled with CFR 0.152.
 */
package github4s.http;

import cats.Functor;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.effect.kernel.GenConcurrent;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import github4s.GHError;
import github4s.GHError$BadRequestError$;
import github4s.GHError$BasicError$;
import github4s.GHError$ForbiddenError$;
import github4s.GHError$JsonParsingError$;
import github4s.GHError$NotFoundError$;
import github4s.GHError$RateLimitExceededError$;
import github4s.GHError$UnauthorizedError$;
import github4s.GHError$UnhandledResponseError$;
import github4s.GHError$UnprocessableEntityError$;
import io.circe.Decoder;
import io.circe.Decoder$;
import java.io.Serializable;
import org.http4s.DecodeFailure;
import org.http4s.EntityDecoder;
import org.http4s.Response;
import org.http4s.Status$;
import org.http4s.circe.CirceEntityDecoder$;
import scala.Function1;
import scala.Predef$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class HttpClient$
implements Serializable {
    private static final Decoder notFoundDecoder;
    public static final HttpClient$ MODULE$;

    private HttpClient$() {
    }

    static {
        MODULE$ = new HttpClient$();
        notFoundDecoder = ((Decoder)package.all$.MODULE$.toFunctorOps(Predef$.MODULE$.implicitly(GHError$NotFoundError$.MODULE$.notFoundErrorDecoder()), (Functor)Decoder$.MODULE$.decoderInstances()).widen()).or(MODULE$::$init$$$anonfun$1);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClient$.class);
    }

    public Decoder<GHError> notFoundDecoder() {
        return notFoundDecoder;
    }

    private <F> EntityDecoder<F, GHError> notFoundEntityDecoder(GenConcurrent<F, Throwable> evidence$19) {
        return org.http4s.circe.package$.MODULE$.jsonOf((GenConcurrent)Predef$.MODULE$.implicitly(evidence$19), this.notFoundDecoder());
    }

    public <F, A> Object buildResponse(Response<F> response, GenConcurrent<F, Throwable> evidence$20, Decoder<A> evidence$21) {
        EitherT eitherT;
        int n = response.status().code();
        int i = n;
        if (Status$.MODULE$.fromInt(i).exists((Function1 & Serializable)_$6 -> _$6.isSuccess())) {
            eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, evidence$21)).map((Function1 & Serializable)_$7 -> {
                Object object = package.all$.MODULE$.catsSyntaxEitherId(_$7);
                return EitherIdOps$.MODULE$.asRight$extension(object);
            }, evidence$20);
        } else {
            switch (n) {
                case 400: {
                    eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, GHError$BadRequestError$.MODULE$.badRequestErrorDecoder())).map((Function1 & Serializable)_$8 -> {
                        GHError.BadRequestError badRequestError = (GHError.BadRequestError)package.all$.MODULE$.catsSyntaxEitherId(_$8);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)badRequestError);
                    }, evidence$20);
                    break;
                }
                case 401: {
                    eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, GHError$UnauthorizedError$.MODULE$.unauthorizedErrorDecoder())).map((Function1 & Serializable)_$9 -> {
                        GHError.UnauthorizedError unauthorizedError = (GHError.UnauthorizedError)package.all$.MODULE$.catsSyntaxEitherId(_$9);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)unauthorizedError);
                    }, evidence$20);
                    break;
                }
                case 403: {
                    eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, GHError$ForbiddenError$.MODULE$.forbiddenErrorDecoder())).map((Function1 & Serializable)_$10 -> {
                        GHError.ForbiddenError forbiddenError = (GHError.ForbiddenError)package.all$.MODULE$.catsSyntaxEitherId(_$10);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)forbiddenError);
                    }, evidence$20);
                    break;
                }
                case 404: {
                    eitherT = response.attemptAs(this.notFoundEntityDecoder(evidence$20)).map((Function1 & Serializable)_$11 -> {
                        GHError gHError = (GHError)package.all$.MODULE$.catsSyntaxEitherId(_$11);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)gHError);
                    }, evidence$20);
                    break;
                }
                case 422: {
                    eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, GHError$UnprocessableEntityError$.MODULE$.uEntityErrorDecoder())).map((Function1 & Serializable)_$12 -> {
                        GHError.UnprocessableEntityError unprocessableEntityError = (GHError.UnprocessableEntityError)package.all$.MODULE$.catsSyntaxEitherId(_$12);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)unprocessableEntityError);
                    }, evidence$20);
                    break;
                }
                case 423: {
                    eitherT = response.attemptAs(CirceEntityDecoder$.MODULE$.circeEntityDecoder(evidence$20, GHError$RateLimitExceededError$.MODULE$.rleErrorDecoder())).map((Function1 & Serializable)_$13 -> {
                        GHError.RateLimitExceededError rateLimitExceededError = (GHError.RateLimitExceededError)package.all$.MODULE$.catsSyntaxEitherId(_$13);
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)rateLimitExceededError);
                    }, evidence$20);
                    break;
                }
                default: {
                    boolean bl = EitherT$.MODULE$.right();
                    eitherT = EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, this.responseBody(response, evidence$20), evidence$20).map((Function1 & Serializable)s -> {
                        GHError.UnhandledResponseError unhandledResponseError = (GHError.UnhandledResponseError)package.all$.MODULE$.catsSyntaxEitherId((Object)GHError$UnhandledResponseError$.MODULE$.apply(new StringBuilder(22).append("Unhandled status code ").append(response.status().code()).toString(), (String)s));
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)unhandledResponseError);
                    }, evidence$20);
                    break;
                }
            }
        }
        return eitherT.fold((Function1 & Serializable)e -> {
            GHError gHError = (GHError)package.all$.MODULE$.catsSyntaxEitherId((Object)GHError$JsonParsingError$.MODULE$.apply((DecodeFailure)e));
            return EitherIdOps$.MODULE$.asLeft$extension((Object)gHError);
        }, (Function1 & Serializable)_$14 -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(_$14);
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)x -> (GHError)Predef$.MODULE$.identity(x));
        }, evidence$20);
    }

    public <F> Object buildResponseFromEmpty(Response<F> response, GenConcurrent<F, Throwable> evidence$22) {
        if (response.status().isSuccess()) {
            Either either = (Either)package.all$.MODULE$.catsSyntaxApplicativeId((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)either, evidence$22);
        }
        return this.buildResponse(response, evidence$22, Decoder$.MODULE$.decodeUnit());
    }

    private <F> Object responseBody(Response<F> response, GenConcurrent<F, Throwable> evidence$23) {
        return response.bodyText(RaiseThrowable$.MODULE$.fromApplicativeError(evidence$23), response.bodyText$default$2()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$23))).foldMonoid(Semigroup$.MODULE$.catsKernelMonoidForString());
    }

    private final Decoder $init$$$anonfun$1() {
        return (Decoder)package.all$.MODULE$.toFunctorOps(GHError$BasicError$.MODULE$.basicErrorDecoder(), (Functor)Decoder$.MODULE$.decoderInstances()).widen();
    }
}

