/*
 * Decompiled with CFR 0.152.
 */
package github4s.http;

import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import github4s.GHError;
import github4s.GHResponse$;
import github4s.GithubConfig;
import github4s.algebras.AccessToken;
import github4s.domain.Pagination;
import github4s.http.Http4sSyntax$;
import github4s.http.Http4sSyntax$RequestBuilderOps$;
import github4s.http.HttpClient$;
import github4s.http.RequestBuilder;
import github4s.http.RequestBuilder$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.client.Client;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class HttpClient<F> {
    private final Client<F> client;
    private final GithubConfig config;
    private final AccessToken<F> accessTokens;
    private final GenConcurrent<F, Throwable> evidence$1;

    public static <F, A> Object buildResponse(Response<F> response, GenConcurrent<F, Throwable> genConcurrent, Decoder<A> decoder) {
        return HttpClient$.MODULE$.buildResponse(response, genConcurrent, decoder);
    }

    public static <F> Object buildResponseFromEmpty(Response<F> response, GenConcurrent<F, Throwable> genConcurrent) {
        return HttpClient$.MODULE$.buildResponseFromEmpty(response, genConcurrent);
    }

    public static Decoder<GHError> notFoundDecoder() {
        return HttpClient$.MODULE$.notFoundDecoder();
    }

    public HttpClient(Client<F> client, GithubConfig config, AccessToken<F> accessTokens, GenConcurrent<F, Throwable> evidence$1) {
        this.client = client;
        this.config = config;
        this.accessTokens = accessTokens;
        this.evidence$1 = evidence$1;
    }

    public GithubConfig config() {
        return this.config;
    }

    public <Res> F get(String method, Map<String, String> headers, Map<String, String> params, Option<Pagination> pagination, Decoder<Res> evidence$2) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(method), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).withAuth((Option<String>)accessToken).withHeaders(headers).withParams((Map<String, String>)((Map)params.$plus$plus((IterableOnce)pagination.fold(HttpClient::get$$anonfun$1$$anonfun$1, (Function1 & Serializable)p -> {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"page");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)p.page()).toString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"per_page");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)p.per_page()).toString());
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })))), (Encoder)Encoder$.MODULE$.encodeUnit(), evidence$2));
    }

    public <Res> Map<String, String> get$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Res> Map<String, String> get$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Res> Option<Pagination> get$default$4() {
        return None$.MODULE$;
    }

    public F getWithoutResponse(String url, Map<String, String> headers) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.runWithoutResponse(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).withHeaders(headers).withAuth((Option<String>)accessToken), (Encoder)Encoder$.MODULE$.encodeUnit()));
    }

    public Map<String, String> getWithoutResponse$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Req, Res> F patch(String method, Map<String, String> headers, Req data, Encoder<Req> evidence$3, Decoder<Res> evidence$4) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(method), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).patchMethod().withAuth((Option<String>)accessToken).withHeaders(headers).withData(data), evidence$3, evidence$4));
    }

    public <Req, Res> Map<String, String> patch$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Req, Res> F put(String url, Map<String, String> headers, Req data, Encoder<Req> evidence$5, Decoder<Res> evidence$6) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).putMethod().withAuth((Option<String>)accessToken).withHeaders(headers).withData(data), evidence$5, evidence$6));
    }

    public <Req, Res> Map<String, String> put$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public <Req, Res> F post(String url, Map<String, String> headers, Req data, Encoder<Req> evidence$7, Decoder<Res> evidence$8) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).postMethod().withAuth((Option<String>)accessToken).withHeaders(headers).withData(data), evidence$7, evidence$8));
    }

    public <Req, Res> Map<String, String> post$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Req, Res> F postAuth(String method, Map<String, String> headers, Req data, Encoder<Req> evidence$9, Decoder<Res> evidence$10) {
        return this.run(RequestBuilder$.MODULE$.apply(this.buildURL(method), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).postMethod().withHeaders(headers).withData(data), evidence$9, evidence$10);
    }

    public <Req, Res> Map<String, String> postAuth$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Res> F postOAuth(String url, Map<String, String> headers, Map<String, String> params, Decoder<Res> evidence$11) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/json");
        return this.run(RequestBuilder$.MODULE$.apply(url, RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).postMethod().withHeaders((Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus(headers))).withParams(params), (Encoder)Encoder$.MODULE$.encodeUnit(), evidence$11);
    }

    public <Res> Map<String, String> postOAuth$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Res> Map<String, String> postOAuth$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public F delete(String url, Map<String, String> headers) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).deleteMethod().withHeaders(headers).withAuth((Option<String>)accessToken), (Encoder)Encoder$.MODULE$.encodeUnit(), (Decoder)Decoder$.MODULE$.decodeUnit()));
    }

    public Map<String, String> delete$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Res> F deleteWithResponse(String url, Map<String, String> headers, Decoder<Res> evidence$12) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).deleteMethod().withAuth((Option<String>)accessToken).withHeaders(headers), (Encoder)Encoder$.MODULE$.encodeUnit(), evidence$12));
    }

    public <Res> Map<String, String> deleteWithResponse$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <Req, Res> F deleteWithBody(String url, Map<String, String> headers, Req data, Encoder<Req> evidence$13, Decoder<Res> evidence$14) {
        return this.accessTokens.withAccessToken((Function1 & Serializable)accessToken -> this.run(RequestBuilder$.MODULE$.apply(this.buildURL(url), RequestBuilder$.MODULE$.$lessinit$greater$default$2(), RequestBuilder$.MODULE$.$lessinit$greater$default$3(), RequestBuilder$.MODULE$.$lessinit$greater$default$4(), RequestBuilder$.MODULE$.$lessinit$greater$default$5(), RequestBuilder$.MODULE$.$lessinit$greater$default$6()).deleteMethod().withAuth((Option<String>)accessToken).withHeaders(headers).withData(data), evidence$13, evidence$14));
    }

    public <Req, Res> Map<String, String> deleteWithBody$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private String buildURL(String method) {
        return new StringBuilder(0).append(this.config().baseUrl()).append(method).toString();
    }

    private <Req, Res> F run(RequestBuilder<Req> request, Encoder<Req> evidence$15, Decoder<Res> evidence$16) {
        return (F)this.runRequest(request, evidence$15).use((Function1 & Serializable)response -> package.all$.MODULE$.toFunctorOps(HttpClient$.MODULE$.buildResponse(response, this.evidence$1, evidence$16), this.evidence$1).map((Function1 & Serializable)_$2 -> GHResponse$.MODULE$.apply(_$2, response.status().code(), Http4sSyntax$.MODULE$.HeadersOps(response.headers()).toMap())), this.evidence$1);
    }

    private <Req> F runWithoutResponse(RequestBuilder<Req> request, Encoder<Req> evidence$17) {
        return (F)this.runRequest(request, evidence$17).use((Function1 & Serializable)response -> package.all$.MODULE$.toFunctorOps(HttpClient$.MODULE$.buildResponseFromEmpty(response, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$3 -> GHResponse$.MODULE$.apply(_$3, response.status().code(), Http4sSyntax$.MODULE$.HeadersOps(response.headers()).toMap())), this.evidence$1);
    }

    private <Req> Resource<F, Response<F>> runRequest(RequestBuilder<Req> request, Encoder<Req> evidence$18) {
        RequestBuilder requestBuilder = Http4sSyntax$.MODULE$.RequestBuilderOps(request);
        Object[] objectArray = new Header.ToRaw[1];
        RequestBuilder requestBuilder2 = Http4sSyntax$.MODULE$.RequestBuilderOps(request);
        objectArray[0] = Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw(Http4sSyntax$RequestBuilderOps$.MODULE$.toHeaderList$extension(requestBuilder2), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h));
        return this.client.run(Http4sSyntax$.MODULE$.RequestOps((Request)Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), Request$.MODULE$.apply$default$2(), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withMethod(request.httpVerb()).withUri(Http4sSyntax$RequestBuilderOps$.MODULE$.toUri$extension(requestBuilder, this.config())).withHeaders(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw(this.config().toHeaderList(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))})), Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))))).withJsonBody(request.data(), evidence$18));
    }

    private static final Map get$$anonfun$1$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }
}

