/*
 * Decompiled with CFR 0.152.
 */
package github4s.interpreters;

import github4s.Decoders$;
import github4s.Encoders$;
import github4s.algebras.Gists;
import github4s.domain.EditGistFile;
import github4s.domain.EditGistRequest$;
import github4s.domain.GistFile;
import github4s.domain.NewGistRequest$;
import github4s.http.HttpClient;
import scala.Option;
import scala.collection.immutable.Map;

public class GistsInterpreter<F>
implements Gists<F> {
    private final HttpClient<F> client;

    public GistsInterpreter(HttpClient<F> client) {
        this.client = client;
    }

    @Override
    public F newGist(String description, boolean bl, Map<String, GistFile> files, Map<String, String> headers) {
        return this.client.post("gists", headers, NewGistRequest$.MODULE$.apply(description, bl, files), Encoders$.MODULE$.encoderNewGistRequest(), Decoders$.MODULE$.decodeGist());
    }

    @Override
    public F getGist(String gistId, Option<String> sha, Map<String, String> headers) {
        return this.client.get(sha.toList().$colon$colon((Object)gistId).$colon$colon((Object)"gists").mkString("/"), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decodeGist());
    }

    @Override
    public F editGist(String gistId, String description, Map<String, Option<EditGistFile>> files, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(6).append("gists/").append(gistId).toString(), headers, EditGistRequest$.MODULE$.apply(description, files), Encoders$.MODULE$.encoderEditGistRequest(), Decoders$.MODULE$.decodeGist());
    }
}

