/*
 * Decompiled with CFR 0.152.
 */
package github4s.interpreters;

import github4s.Decoders$;
import github4s.Encoders$;
import github4s.algebras.GitData;
import github4s.domain.CreateReferenceRequest$;
import github4s.domain.NewBlobRequest$;
import github4s.domain.NewCommitRequest$;
import github4s.domain.NewTagRequest$;
import github4s.domain.NewTreeRequest$;
import github4s.domain.Pagination;
import github4s.domain.RefAuthor;
import github4s.domain.TreeData;
import github4s.domain.UpdateReferenceRequest$;
import github4s.http.HttpClient;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class GitDataInterpreter<F>
implements GitData<F> {
    private final HttpClient<F> client;

    public GitDataInterpreter(HttpClient<F> client) {
        this.client = client;
    }

    @Override
    public F getReference(String owner, String repo, String ref, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/git/refs/").append(ref).toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoders$.MODULE$.decodeNonEmptyList(Decoders$.MODULE$.decoderRef()));
    }

    @Override
    public F createReference(String owner, String repo, String ref, String sha, Map<String, String> headers) {
        return this.client.post(new StringBuilder(16).append("repos/").append(owner).append("/").append(repo).append("/git/refs").toString(), headers, CreateReferenceRequest$.MODULE$.apply(ref, sha), Encoders$.MODULE$.encoderCreateReferenceRequest(), Decoders$.MODULE$.decoderRef());
    }

    @Override
    public F updateReference(String owner, String repo, String ref, String sha, boolean force, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/git/refs/").append(ref).toString(), headers, UpdateReferenceRequest$.MODULE$.apply(sha, force), Encoders$.MODULE$.encoderUpdateReferenceRequest(), Decoders$.MODULE$.decoderRef());
    }

    @Override
    public F getCommit(String owner, String repo, String sha, Map<String, String> headers) {
        return this.client.get(new StringBuilder(20).append("repos/").append(owner).append("/").append(repo).append("/git/commits/").append(sha).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderRefCommit());
    }

    @Override
    public F createCommit(String owner, String repo, String message, String tree, List<String> parents, Option<RefAuthor> author, Map<String, String> headers) {
        return this.client.post(new StringBuilder(19).append("repos/").append(owner).append("/").append(repo).append("/git/commits").toString(), headers, NewCommitRequest$.MODULE$.apply(message, tree, parents, author), Encoders$.MODULE$.encoderNewCommitRequest(), Decoders$.MODULE$.decoderRefCommit());
    }

    @Override
    public F getBlob(String owner, String repo, String fileSha, Map<String, String> headers) {
        return this.client.get(new StringBuilder(18).append("repos/").append(owner).append("/").append(repo).append("/git/blobs/").append(fileSha).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderBlobContent());
    }

    @Override
    public F createBlob(String owner, String repo, String content, Option<String> encoding, Map<String, String> headers) {
        return this.client.post(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/git/blobs").toString(), headers, NewBlobRequest$.MODULE$.apply(content, encoding), Encoders$.MODULE$.encoderNewBlobRequest(), Decoders$.MODULE$.decoderRefInfo());
    }

    @Override
    public F getTree(String owner, String repo, String sha, boolean recursive, Map<String, String> headers) {
        Map map;
        String string = new StringBuilder(18).append("repos/").append(owner).append("/").append(repo).append("/git/trees/").append(sha).toString();
        if (recursive) {
            Object[] objectArray = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"recursive");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"1");
            map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return this.client.get(string, headers, (Map<String, String>)map, this.client.get$default$4(), Decoders$.MODULE$.decoderTreeResult());
    }

    @Override
    public F createTree(String owner, String repo, Option<String> baseTree, List<TreeData> treeDataList, Map<String, String> headers) {
        return this.client.post(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/git/trees").toString(), headers, NewTreeRequest$.MODULE$.apply(treeDataList, baseTree), Encoders$.MODULE$.encoderNewTreeRequest(), Decoders$.MODULE$.decoderTreeResult());
    }

    @Override
    public F createTag(String owner, String repo, String tag, String message, String objectSha, String objectType, Option<RefAuthor> author, Map<String, String> headers) {
        return this.client.post(new StringBuilder(16).append("repos/").append(owner).append("/").append(repo).append("/git/tags").toString(), headers, NewTagRequest$.MODULE$.apply(tag, message, objectSha, objectType, author), Encoders$.MODULE$.encoderNewTagRequest(), Decoders$.MODULE$.decoderTag());
    }
}

