/*
 * Decompiled with CFR 0.152.
 */
package github4s.interpreters;

import cats.syntax.package;
import github4s.Decoders$;
import github4s.Encoders$;
import github4s.algebras.Issues;
import github4s.domain.CommentData$;
import github4s.domain.EditIssueRequest$;
import github4s.domain.Label;
import github4s.domain.MilestoneData$;
import github4s.domain.NewIssueRequest$;
import github4s.domain.Pagination;
import github4s.domain.SearchParam;
import github4s.http.HttpClient;
import io.circe.Decoder$;
import io.circe.Encoder$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class IssuesInterpreter<F>
implements Issues<F> {
    private final HttpClient<F> client;

    public IssuesInterpreter(HttpClient<F> client) {
        this.client = client;
    }

    @Override
    public F listIssues(String owner, String repo, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(14).append("repos/").append(owner).append("/").append(repo).append("/issues").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderIssue()));
    }

    @Override
    public F getIssue(String owner, String repo, int number, Map<String, String> headers) {
        return this.client.get(new StringBuilder(15).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderIssue());
    }

    @Override
    public F searchIssues(String query, List<SearchParam> searchParams, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"q");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new StringBuilder(1).append(query).append("+").append(searchParams.map((Function1 & Serializable)_$2 -> _$2.value()).mkString("+")).toString());
        return this.client.get("search/issues", headers, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pagination, Decoders$.MODULE$.decoderSearchIssuesResult());
    }

    @Override
    public Option<Pagination> searchIssues$default$3() {
        return package.all$.MODULE$.none();
    }

    @Override
    public F createIssue(String owner, String repo, String title, String body, Option<Object> milestone, List<String> labels, List<String> assignees, Map<String, String> headers) {
        return this.client.post(new StringBuilder(14).append("repos/").append(owner).append("/").append(repo).append("/issues").toString(), headers, NewIssueRequest$.MODULE$.apply(title, body, labels, assignees, milestone), Encoders$.MODULE$.encoderNewIssueRequest(), Decoders$.MODULE$.decoderIssue());
    }

    @Override
    public F editIssue(String owner, String repo, int issue, String state, String title, String body, Option<Object> milestone, List<String> labels, List<String> assignees, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(15).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(issue).toString(), headers, EditIssueRequest$.MODULE$.apply(state, title, body, labels, assignees, milestone), Encoders$.MODULE$.encoderEditIssueRequest(), Decoders$.MODULE$.decoderIssue());
    }

    @Override
    public F listComments(String owner, String repo, int number, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(24).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).append("/comments").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderComment()));
    }

    @Override
    public F createComment(String owner, String repo, int number, String body, Map<String, String> headers) {
        return this.client.post(new StringBuilder(24).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).append("/comments").toString(), headers, CommentData$.MODULE$.apply(body), Encoders$.MODULE$.encoderCommentData(), Decoders$.MODULE$.decoderComment());
    }

    @Override
    public F editComment(String owner, String repo, long id, String body, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(24).append("repos/").append(owner).append("/").append(repo).append("/issues/comments/").append(id).toString(), headers, CommentData$.MODULE$.apply(body), Encoders$.MODULE$.encoderCommentData(), Decoders$.MODULE$.decoderComment());
    }

    @Override
    public F deleteComment(String owner, String repo, long id, Map<String, String> headers) {
        return this.client.delete(new StringBuilder(24).append("repos/").append(owner).append("/").append(repo).append("/issues/comments/").append(id).toString(), headers);
    }

    @Override
    public F listLabelsRepository(String owner, String repo, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(14).append("repos/").append(owner).append("/").append(repo).append("/labels").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderLabel()));
    }

    @Override
    public F listLabels(String owner, String repo, int number, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(22).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).append("/labels").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderLabel()));
    }

    @Override
    public F createLabel(String owner, String repo, Label label, Map<String, String> headers) {
        return this.client.post(new StringBuilder(14).append("repos/").append(owner).append("/").append(repo).append("/labels").toString(), headers, label, Encoders$.MODULE$.encoderLabel(), Decoders$.MODULE$.decoderLabel());
    }

    @Override
    public F updateLabel(String owner, String repo, Label label, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(15).append("repos/").append(owner).append("/").append(repo).append("/labels/").append(label.name()).toString(), headers, label, Encoders$.MODULE$.encoderLabel(), Decoders$.MODULE$.decoderLabel());
    }

    @Override
    public F deleteLabel(String owner, String repo, String label, Map<String, String> headers) {
        return this.client.delete(new StringBuilder(15).append("repos/").append(owner).append("/").append(repo).append("/labels/").append(label).toString(), headers);
    }

    @Override
    public F addLabels(String owner, String repo, int number, List<String> labels, Map<String, String> headers) {
        return this.client.post(new StringBuilder(22).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).append("/labels").toString(), headers, labels, Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString()), Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderLabel()));
    }

    @Override
    public F removeLabel(String owner, String repo, int number, String label, Map<String, String> headers) {
        return this.client.deleteWithResponse(new StringBuilder(23).append("repos/").append(owner).append("/").append(repo).append("/issues/").append(number).append("/labels/").append(label).toString(), headers, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderLabel()));
    }

    @Override
    public F listAvailableAssignees(String owner, String repo, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/assignees").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderUser()));
    }

    @Override
    public F listMilestones(String owner, String repo, Option<String> state, Option<String> sort, Option<String> direction, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(18).append("repos/").append(owner).append("/").append(repo).append("/milestones").toString();
        Map map = ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{state.map((Function1 & Serializable)_$3 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"state");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$3);
        }), sort.map((Function1 & Serializable)_$4 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"sort");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$4);
        }), direction.map((Function1 & Serializable)_$5 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"direction");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$5);
        })}))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.client.get(string, headers, (Map<String, String>)map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decodeMilestone()));
    }

    @Override
    public F createMilestone(String owner, String repo, String title, Option<String> state, Option<String> description, Option<ZonedDateTime> due_on, Map<String, String> headers) {
        return this.client.post(new StringBuilder(18).append("repos/").append(owner).append("/").append(repo).append("/milestones").toString(), headers, MilestoneData$.MODULE$.apply(title, state, description, due_on), Encoders$.MODULE$.encoderMilestoneData(), Decoders$.MODULE$.decodeMilestone());
    }

    @Override
    public F getMilestone(String owner, String repo, int number, Map<String, String> headers) {
        return this.client.get(new StringBuilder(19).append("repos/").append(owner).append("/").append(repo).append("/milestones/").append(number).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decodeMilestone());
    }

    @Override
    public F updateMilestone(String owner, String repo, int milestone_number, String title, Option<String> state, Option<String> description, Option<ZonedDateTime> due_on, Map<String, String> headers) {
        return this.client.patch(new StringBuilder(19).append("repos/").append(owner).append("/").append(repo).append("/milestones/").append(milestone_number).toString(), headers, MilestoneData$.MODULE$.apply(title, state, description, due_on), Encoders$.MODULE$.encoderMilestoneData(), Decoders$.MODULE$.decodeMilestone());
    }

    @Override
    public F deleteMilestone(String owner, String repo, int milestone_number, Map<String, String> headers) {
        return this.client.delete(new StringBuilder(19).append("repos/").append(owner).append("/").append(repo).append("/milestones/").append(milestone_number).toString(), headers);
    }
}

