/*
 * Decompiled with CFR 0.152.
 */
package github4s.interpreters;

import github4s.Decoders$;
import github4s.Encoders$;
import github4s.algebras.PullRequests;
import github4s.domain.BranchUpdateRequest$;
import github4s.domain.CreatePRReviewRequest;
import github4s.domain.CreatePullRequest;
import github4s.domain.CreatePullRequestData$;
import github4s.domain.CreatePullRequestIssue$;
import github4s.domain.NewPullRequest;
import github4s.domain.NewPullRequestData;
import github4s.domain.NewPullRequestData$;
import github4s.domain.NewPullRequestIssue;
import github4s.domain.NewPullRequestIssue$;
import github4s.domain.PRFilter;
import github4s.domain.Pagination;
import github4s.domain.ReviewersRequest;
import github4s.http.HttpClient;
import io.circe.Decoder$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class PullRequestsInterpreter<F>
implements PullRequests<F> {
    private final HttpClient<F> client;

    public PullRequestsInterpreter(HttpClient<F> client) {
        this.client = client;
    }

    @Override
    public F getPullRequest(String owner, String repo, int number, Map<String, String> headers) {
        return this.client.get(new StringBuilder(14).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(number).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderPullRequest());
    }

    @Override
    public F listPullRequests(String owner, String repo, List<PRFilter> filters, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(13).append("repos/").append(owner).append("/").append(repo).append("/pulls").toString(), headers, (Map<String, String>)filters.map((Function1 & Serializable)_$2 -> _$2.tupled()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderPullRequest()));
    }

    @Override
    public F listFiles(String owner, String repo, int number, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(20).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(number).append("/files").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderPullRequestFile()));
    }

    @Override
    public F createPullRequest(String owner, String repo, NewPullRequest newPullRequest, String head, String base, Option<Object> maintainerCanModify, Map<String, String> headers) {
        Product product;
        NewPullRequest newPullRequest2 = newPullRequest;
        if (newPullRequest2 instanceof NewPullRequestData) {
            NewPullRequestData newPullRequestData = NewPullRequestData$.MODULE$.unapply((NewPullRequestData)newPullRequest2);
            String string = newPullRequestData._1();
            String string2 = newPullRequestData._2();
            boolean bl = newPullRequestData._3();
            String title = string;
            String body = string2;
            boolean draft = bl;
            product = CreatePullRequestData$.MODULE$.apply(title, head, base, body, maintainerCanModify, draft);
        } else if (newPullRequest2 instanceof NewPullRequestIssue) {
            int n;
            NewPullRequestIssue newPullRequestIssue = NewPullRequestIssue$.MODULE$.unapply((NewPullRequestIssue)newPullRequest2);
            int issue = n = newPullRequestIssue._1();
            product = CreatePullRequestIssue$.MODULE$.apply(issue, head, base, maintainerCanModify);
        } else {
            throw new MatchError((Object)newPullRequest2);
        }
        CreatePullRequest data = product;
        return this.client.post(new StringBuilder(13).append("repos/").append(owner).append("/").append(repo).append("/pulls").toString(), headers, data, Encoders$.MODULE$.encodeNewPullRequest(), Decoders$.MODULE$.decoderPullRequest());
    }

    @Override
    public F listReviews(String owner, String repo, int pullRequest, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(22).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/reviews").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderPullRequestReview()));
    }

    @Override
    public F getReview(String owner, String repo, int pullRequest, long review, Map<String, String> headers) {
        return this.client.get(new StringBuilder(23).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/reviews/").append(review).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderPullRequestReview());
    }

    @Override
    public F createReview(String owner, String repo, int pullRequest, CreatePRReviewRequest createPRReviewRequest, Map<String, String> headers) {
        return this.client.post(new StringBuilder(22).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/reviews").toString(), headers, createPRReviewRequest, Encoders$.MODULE$.encodeNewPullRequestReview(), Decoders$.MODULE$.decoderPullRequestReview());
    }

    @Override
    public F listReviewers(String owner, String repo, int pullRequest, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(34).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/requested_reviewers").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), pagination, Decoders$.MODULE$.decodeReviewers());
    }

    @Override
    public F addReviewers(String owner, String repo, int pullRequest, ReviewersRequest reviewers, Map<String, String> headers) {
        return this.client.post(new StringBuilder(34).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/requested_reviewers").toString(), headers, reviewers, Encoders$.MODULE$.encodeRequiestedReviewers(), Decoders$.MODULE$.decoderPullRequest());
    }

    @Override
    public F removeReviewers(String owner, String repo, int pullRequest, ReviewersRequest reviewers, Map<String, String> headers) {
        return this.client.deleteWithBody(new StringBuilder(34).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/requested_reviewers").toString(), headers, reviewers, Encoders$.MODULE$.encodeRequiestedReviewers(), Decoders$.MODULE$.decoderPullRequest());
    }

    @Override
    public F updateBranch(String owner, String repo, int pullRequest, Option<String> expectedHeadSha, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/vnd.github.lydian-preview+json");
        return this.client.put(new StringBuilder(28).append("repos/").append(owner).append("/").append(repo).append("/pulls/").append(pullRequest).append("/update-branch").toString(), (Map<String, String>)((Map)headers.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))), BranchUpdateRequest$.MODULE$.apply(expectedHeadSha), Encoders$.MODULE$.encodeBranchUpdateRequest(), Decoders$.MODULE$.decodeBranchUpdateResponse());
    }

    @Override
    public Option<String> updateBranch$default$4() {
        return None$.MODULE$;
    }

    @Override
    public Map<String, String> updateBranch$default$5() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

