/*
 * Decompiled with CFR 0.152.
 */
package github4s.interpreters;

import cats.Functor;
import cats.syntax.package;
import github4s.Decoders$;
import github4s.Encoders$;
import github4s.GHError;
import github4s.GHResponse;
import github4s.GHResponse$;
import github4s.algebras.Repositories;
import github4s.domain.Committer;
import github4s.domain.DeleteFileRequest$;
import github4s.domain.NewReleaseRequest$;
import github4s.domain.NewStatusRequest$;
import github4s.domain.Pagination;
import github4s.domain.SearchParam;
import github4s.domain.WriteFileRequest$;
import github4s.http.HttpClient;
import github4s.internal.Base64;
import github4s.internal.Base64$;
import io.circe.Decoder$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class RepositoriesInterpreter<F>
implements Repositories<F> {
    private final Functor<F> evidence$1;
    private final HttpClient<F> client;

    public RepositoriesInterpreter(Functor<F> evidence$1, HttpClient<F> client) {
        this.evidence$1 = evidence$1;
        this.client = client;
    }

    @Override
    public F get(String owner, String repo, Map<String, String> headers) {
        return this.client.get(new StringBuilder(7).append("repos/").append(owner).append("/").append(repo).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decodeRepository());
    }

    @Override
    public F listOrgRepos(String org, Option<String> type, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(11).append("orgs/").append(org).append("/repos").toString(), headers, (Map<String, String>)((Map)type.fold(RepositoriesInterpreter::listOrgRepos$$anonfun$1, (Function1 & Serializable)t -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, t);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decodeRepository()));
    }

    @Override
    public F listUserRepos(String user, Option<String> type, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(12).append("users/").append(user).append("/repos").toString(), headers, (Map<String, String>)((Map)type.fold(RepositoriesInterpreter::listUserRepos$$anonfun$1, (Function1 & Serializable)t -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, t);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decodeRepository()));
    }

    @Override
    public F searchRepos(String query, List<SearchParam> searchParams, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"q");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new StringBuilder(1).append(query).append("+").append(searchParams.map((Function1 & Serializable)_$2 -> _$2.value()).mkString("+")).toString());
        return this.client.get("search/repositories", headers, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pagination, Decoders$.MODULE$.decoderSearchReposResult());
    }

    @Override
    public Map<String, String> searchRepos$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public F getContents(String owner, String repo, String path, Option<String> ref, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/contents/").append(path).toString(), headers, (Map<String, String>)((Map)ref.fold(RepositoriesInterpreter::getContents$$anonfun$1, (Function1 & Serializable)r -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ref");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, r);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })), pagination, Decoders$.MODULE$.decodeNonEmptyList(Decoders$.MODULE$.decoderContent()));
    }

    @Override
    public F createFile(String owner, String repo, String path, String message, byte[] content, Option<String> branch, Option<Committer> committer, Option<Committer> author, Map<String, String> headers) {
        Base64.Encoder encoder = Base64$.MODULE$.Encoder(content);
        return this.client.put(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/contents/").append(path).toString(), headers, WriteFileRequest$.MODULE$.apply(message, encoder.toBase64(encoder.toBase64$default$1()), (Option<String>)None$.MODULE$, branch, committer, author), Encoders$.MODULE$.encoderWriteFileContentRequest(), Decoders$.MODULE$.decoderWriteFileResponse());
    }

    @Override
    public F updateFile(String owner, String repo, String path, String message, byte[] content, String sha, Option<String> branch, Option<Committer> committer, Option<Committer> author, Map<String, String> headers) {
        Base64.Encoder encoder = Base64$.MODULE$.Encoder(content);
        return this.client.put(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/contents/").append(path).toString(), headers, WriteFileRequest$.MODULE$.apply(message, encoder.toBase64(encoder.toBase64$default$1()), (Option<String>)Some$.MODULE$.apply((Object)sha), branch, committer, author), Encoders$.MODULE$.encoderWriteFileContentRequest(), Decoders$.MODULE$.decoderWriteFileResponse());
    }

    @Override
    public F deleteFile(String owner, String repo, String path, String message, String sha, Option<String> branch, Option<Committer> committer, Option<Committer> author, Map<String, String> headers) {
        return this.client.deleteWithBody(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/contents/").append(path).toString(), headers, DeleteFileRequest$.MODULE$.apply(message, sha, branch, committer, author), Encoders$.MODULE$.encoderDeleteFileRequest(), Decoders$.MODULE$.decoderWriteFileResponse());
    }

    @Override
    public F listCommits(String owner, String repo, Option<String> sha, Option<String> path, Option<String> author, Option<String> since, Option<String> until, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"sha");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, sha);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, path);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"author");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, author);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"since");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, since);
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"until");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, until);
        return this.client.get(new StringBuilder(15).append("repos/").append(owner).append("/").append(repo).append("/commits").toString(), headers, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decodeCommit()));
    }

    @Override
    public F compareCommits(String owner, String repo, String commitSha, String baseSha, Map<String, String> headers) {
        return this.client.get(new StringBuilder(19).append("repos/").append(owner).append("/").append(repo).append("/compare/").append(baseSha).append("...").append(commitSha).toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decodeCommitComparisonResponse());
    }

    @Override
    public Map<String, String> compareCommits$default$5() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    @Override
    public F listBranches(String owner, String repo, Option<Object> onlyProtected, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"protected");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)onlyProtected.map((Function1 & Serializable)_$3 -> RepositoriesInterpreter.listBranches$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$3))));
        return this.client.get(new StringBuilder(16).append("repos/").append(owner).append("/").append(repo).append("/branches").toString(), headers, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decodeBranch()));
    }

    @Override
    public F listContributors(String owner, String repo, Option<String> anon2, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"anon");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, anon2);
        return this.client.get(new StringBuilder(20).append("repos/").append(owner).append("/").append(repo).append("/contributors").toString(), headers, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderUser()));
    }

    @Override
    public F listCollaborators(String owner, String repo, Option<String> affiliation, Option<Pagination> pagination, Map<String, String> headers) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"affiliation");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, affiliation);
        return this.client.get(new StringBuilder(21).append("repos/").append(owner).append("/").append(repo).append("/collaborators").toString(), headers, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        })), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderUser()));
    }

    @Override
    public F userIsCollaborator(String owner, String repo, String username, Map<String, String> headers) {
        return (F)package.functor$.MODULE$.toFunctorOps(this.client.getWithoutResponse(new StringBuilder(22).append("repos/").append(owner).append("/").append(repo).append("/collaborators/").append(username).toString(), headers), this.evidence$1).map((Function1 & Serializable)response -> this.handleIsCollaboratorResponse((GHResponse<BoxedUnit>)response));
    }

    @Override
    public F getRepoPermissionForUser(String owner, String repo, String username, Map<String, String> headers) {
        return this.client.get(new StringBuilder(33).append("repos/").append(owner).append("/").append(repo).append("/collaborators/").append(username).append("/permission").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), this.client.get$default$4(), Decoders$.MODULE$.decoderUserRepoPermission());
    }

    @Override
    public F latestRelease(String owner, String repo, Map<String, String> headers) {
        return this.client.get(new StringBuilder(23).append("repos/").append(owner).append("/").append(repo).append("/releases/latest").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), this.client.get$default$4(), Decoder$.MODULE$.decodeOption(Decoders$.MODULE$.decoderRelease()));
    }

    @Override
    public F getRelease(long releaseId, String owner, String repo, Map<String, String> headers) {
        return this.client.get(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/releases/").append(releaseId).toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), this.client.get$default$4(), Decoder$.MODULE$.decodeOption(Decoders$.MODULE$.decoderRelease()));
    }

    @Override
    public F listReleases(String owner, String repo, Option<Pagination> pagination, Map<String, String> headers) {
        return this.client.get(new StringBuilder(16).append("repos/").append(owner).append("/").append(repo).append("/releases").toString(), headers, (Map<String, String>)Predef$.MODULE$.Map().empty(), pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderRelease()));
    }

    @Override
    public F createRelease(String owner, String repo, String tagName, String name, String body, Option<String> targetCommitish, Option<Object> draft, Option<Object> prerelease, Map<String, String> headers) {
        return this.client.post(new StringBuilder(16).append("repos/").append(owner).append("/").append(repo).append("/releases").toString(), headers, NewReleaseRequest$.MODULE$.apply(tagName, name, body, targetCommitish, draft, prerelease), Encoders$.MODULE$.encoderNewReleaseRequest(), Decoders$.MODULE$.decoderRelease());
    }

    @Override
    public F getCombinedStatus(String owner, String repo, String ref, Map<String, String> headers) {
        return this.client.get(new StringBuilder(23).append("repos/").append(owner).append("/").append(repo).append("/commits/").append(ref).append("/status").toString(), headers, this.client.get$default$3(), this.client.get$default$4(), Decoders$.MODULE$.decoderCombinedStatus());
    }

    @Override
    public F listStatuses(String owner, String repo, String ref, Option<Pagination> pagination, Map<String, String> headers) {
        String string = new StringBuilder(25).append("repos/").append(owner).append("/").append(repo).append("/commits/").append(ref).append("/statuses").toString();
        Map<String, String> map = this.client.get$default$3();
        return this.client.get(string, headers, map, pagination, Decoder$.MODULE$.decodeList(Decoders$.MODULE$.decoderStatus()));
    }

    @Override
    public F createStatus(String owner, String repo, String sha, String state, Option<String> target_url, Option<String> description, Option<String> context, Map<String, String> headers) {
        return this.client.post(new StringBuilder(17).append("repos/").append(owner).append("/").append(repo).append("/statuses/").append(sha).toString(), headers, NewStatusRequest$.MODULE$.apply(state, target_url, description, context), Encoders$.MODULE$.encoderNewStatusRequest(), Decoders$.MODULE$.decoderStatus());
    }

    private GHResponse<Object> handleIsCollaboratorResponse(GHResponse<BoxedUnit> response) {
        Either<GHError, BoxedUnit> either = response.result();
        if (either instanceof Right) {
            return response.copy((Either<GHError, BoxedUnit>)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), response.copy$default$2(), response.copy$default$3());
        }
        if (either instanceof Left) {
            if (response.statusCode() == 404) {
                return response.copy((Either<GHError, BoxedUnit>)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), response.copy$default$2(), response.copy$default$3());
            }
            GHError error = (GHError)((Left)either).value();
            return GHResponse$.MODULE$.apply(package$.MODULE$.Left().apply((Object)error), response.statusCode(), response.headers());
        }
        throw new MatchError(either);
    }

    private static final Map listOrgRepos$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Map listUserRepos$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Map getContents$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ String listBranches$$anonfun$1(boolean _$3) {
        return BoxesRunTime.boxToBoolean((boolean)_$3).toString();
    }
}

