/*
 * Decompiled with CFR 0.152.
 */
package github4s.modules;

import cats.effect.kernel.GenConcurrent;
import github4s.GithubConfig;
import github4s.algebras.AccessToken;
import github4s.algebras.Activities;
import github4s.algebras.Auth;
import github4s.algebras.Gists;
import github4s.algebras.GitData;
import github4s.algebras.GithubAPIs;
import github4s.algebras.Issues;
import github4s.algebras.Organizations;
import github4s.algebras.Projects;
import github4s.algebras.PullRequests;
import github4s.algebras.Repositories;
import github4s.algebras.Search;
import github4s.algebras.Teams;
import github4s.algebras.Users;
import github4s.http.HttpClient;
import github4s.interpreters.ActivitiesInterpreter;
import github4s.interpreters.AuthInterpreter;
import github4s.interpreters.GistsInterpreter;
import github4s.interpreters.GitDataInterpreter;
import github4s.interpreters.IssuesInterpreter;
import github4s.interpreters.OrganizationsInterpreter;
import github4s.interpreters.ProjectsInterpreter;
import github4s.interpreters.PullRequestsInterpreter;
import github4s.interpreters.RepositoriesInterpreter;
import github4s.interpreters.SearchInterpreter;
import github4s.interpreters.TeamsInterpreter;
import github4s.interpreters.UsersInterpreter;
import github4s.modules.GithubAPIv3$;
import org.http4s.client.Client;

public class GithubAPIv3<F>
implements GithubAPIs<F> {
    private final HttpClient httpClient;
    private final Users users;
    private final Repositories repos;
    private final Auth auth;
    private final Gists gists;
    private final Issues issues;
    private final Activities activities;
    private final GitData gitData;
    private final PullRequests pullRequests;
    private final Organizations organizations;
    private final Teams teams;
    private final Projects projects;
    private final Search search;

    public static <F> GithubAPIv3<F> noAuth(Client<F> client, GithubConfig githubConfig, GenConcurrent<F, Throwable> genConcurrent) {
        return GithubAPIv3$.MODULE$.noAuth(client, githubConfig, genConcurrent);
    }

    public GithubAPIv3(Client<F> client, GithubConfig config, AccessToken<F> accessToken, GenConcurrent<F, Throwable> evidence$1) {
        this.httpClient = new HttpClient<F>(client, config, accessToken, evidence$1);
        this.users = new UsersInterpreter<F>(this.httpClient());
        this.repos = new RepositoriesInterpreter<F>(evidence$1, this.httpClient());
        this.auth = new AuthInterpreter<F>(evidence$1, this.httpClient());
        this.gists = new GistsInterpreter<F>(this.httpClient());
        this.issues = new IssuesInterpreter<F>(this.httpClient());
        this.activities = new ActivitiesInterpreter<F>(this.httpClient());
        this.gitData = new GitDataInterpreter<F>(this.httpClient());
        this.pullRequests = new PullRequestsInterpreter<F>(this.httpClient());
        this.organizations = new OrganizationsInterpreter<F>(this.httpClient());
        this.teams = new TeamsInterpreter<F>(this.httpClient());
        this.projects = new ProjectsInterpreter<F>(this.httpClient());
        this.search = new SearchInterpreter<F>(this.httpClient());
    }

    public HttpClient<F> httpClient() {
        return this.httpClient;
    }

    @Override
    public Users<F> users() {
        return this.users;
    }

    @Override
    public Repositories<F> repos() {
        return this.repos;
    }

    @Override
    public Auth<F> auth() {
        return this.auth;
    }

    @Override
    public Gists<F> gists() {
        return this.gists;
    }

    @Override
    public Issues<F> issues() {
        return this.issues;
    }

    @Override
    public Activities<F> activities() {
        return this.activities;
    }

    @Override
    public GitData<F> gitData() {
        return this.gitData;
    }

    @Override
    public PullRequests<F> pullRequests() {
        return this.pullRequests;
    }

    @Override
    public Organizations<F> organizations() {
        return this.organizations;
    }

    @Override
    public Teams<F> teams() {
        return this.teams;
    }

    @Override
    public Projects<F> projects() {
        return this.projects;
    }

    @Override
    public Search<F> search() {
        return this.search;
    }
}

