/*
 * Decompiled with CFR 0.152.
 */
package github4s.free.interpreters;

import cats.ApplicativeError;
import cats.MonadError;
import cats.arrow.FunctionK;
import cats.data.EitherK;
import cats.data.Kleisli;
import github4s.GithubDefaultUrls$;
import github4s.HttpRequestBuilderExtension;
import github4s.api.Activities;
import github4s.api.Auth;
import github4s.api.Gists;
import github4s.api.GitData;
import github4s.api.Issues;
import github4s.api.Organizations;
import github4s.api.PullRequests;
import github4s.api.Repos;
import github4s.api.Users;
import github4s.free.algebra.ActivityOp;
import github4s.free.algebra.AddLabels;
import github4s.free.algebra.AuthOp;
import github4s.free.algebra.AuthorizeUrl;
import github4s.free.algebra.CreateBlob;
import github4s.free.algebra.CreateComment;
import github4s.free.algebra.CreateCommit;
import github4s.free.algebra.CreateIssue;
import github4s.free.algebra.CreatePullRequest;
import github4s.free.algebra.CreateReference;
import github4s.free.algebra.CreateRelease;
import github4s.free.algebra.CreateStatus;
import github4s.free.algebra.CreateTag;
import github4s.free.algebra.CreateTree;
import github4s.free.algebra.DeleteComment;
import github4s.free.algebra.EditComment;
import github4s.free.algebra.EditGist;
import github4s.free.algebra.EditIssue;
import github4s.free.algebra.GetAccessToken;
import github4s.free.algebra.GetAuthUser;
import github4s.free.algebra.GetCombinedStatus;
import github4s.free.algebra.GetCommit;
import github4s.free.algebra.GetContents;
import github4s.free.algebra.GetGist;
import github4s.free.algebra.GetIssue;
import github4s.free.algebra.GetPullRequest;
import github4s.free.algebra.GetPullRequestReview;
import github4s.free.algebra.GetReference;
import github4s.free.algebra.GetRepo;
import github4s.free.algebra.GetTree;
import github4s.free.algebra.GetUser;
import github4s.free.algebra.GetUsers;
import github4s.free.algebra.GistOp;
import github4s.free.algebra.GitDataOp;
import github4s.free.algebra.IssueOp;
import github4s.free.algebra.ListAvailableAssignees;
import github4s.free.algebra.ListBranches;
import github4s.free.algebra.ListCollaborators;
import github4s.free.algebra.ListComments;
import github4s.free.algebra.ListCommits;
import github4s.free.algebra.ListContributors;
import github4s.free.algebra.ListIssues;
import github4s.free.algebra.ListLabels;
import github4s.free.algebra.ListMembers;
import github4s.free.algebra.ListOrgRepos;
import github4s.free.algebra.ListOutsideCollaborators;
import github4s.free.algebra.ListPullRequestFiles;
import github4s.free.algebra.ListPullRequestReviews;
import github4s.free.algebra.ListPullRequests;
import github4s.free.algebra.ListStargazers;
import github4s.free.algebra.ListStarredRepositories;
import github4s.free.algebra.ListStatuses;
import github4s.free.algebra.ListUserRepos;
import github4s.free.algebra.NewAuth;
import github4s.free.algebra.NewGist;
import github4s.free.algebra.OrganizationOp;
import github4s.free.algebra.PullRequestOp;
import github4s.free.algebra.RemoveLabel;
import github4s.free.algebra.RepositoryOp;
import github4s.free.algebra.SearchIssues;
import github4s.free.algebra.SetThreadSub;
import github4s.free.algebra.UpdateReference;
import github4s.free.algebra.UserOp;
import github4s.free.domain.EditGistFile;
import github4s.free.domain.GistFile;
import github4s.free.domain.NewPullRequest;
import github4s.free.domain.PRFilter;
import github4s.free.domain.Pagination;
import github4s.free.domain.RefAuthor;
import github4s.free.domain.SearchParam;
import github4s.free.domain.TreeData;
import github4s.free.interpreters.Capture;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\t\u0012\u0001aA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006Y!\t\u0005\t\u0003\u0002\u0011\t\u0011)A\u0006\u0005\"Aa\t\u0001B\u0001B\u0003-q\tC\u0003O\u0001\u0011\u0005q*\u0002\u0003V\u0001\u00011\u0006\"\u0002\n\u0001\t\u0007Y\u0007bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003[\u0002A\u0011AA8\u00051Ie\u000e^3saJ,G/\u001a:t\u0015\t\u00112#\u0001\u0007j]R,'\u000f\u001d:fi\u0016\u00148O\u0003\u0002\u0015+\u0005!aM]3f\u0015\u00051\u0012\u0001C4ji\",(\rN:\u0004\u0001U\u0019\u0011$\u000b'\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\u0001B!\u0011\u0011SeJ\u001b\u000e\u0003\rR\u0011\u0001J\u0001\u0005G\u0006$8/\u0003\u0002'G\t\u0001\u0012\t\u001d9mS\u000e\fG/\u001b<f\u000bJ\u0014xN\u001d\t\u0003Q%b\u0001\u0001B\u0003+\u0001\t\u00071FA\u0001N+\ta3'\u0005\u0002.aA\u00111DL\u0005\u0003_q\u0011qAT8uQ&tw\r\u0005\u0002\u001cc%\u0011!\u0007\b\u0002\u0004\u0003:LH!\u0002\u001b*\u0005\u0004a#!A0\u0011\u0005YrdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQt#\u0001\u0004=e>|GOP\u0005\u0002;%\u0011Q\bH\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0005UQJ|w/\u00192mK*\u0011Q\bH\u0001\u0002\u0007B\u00191\tR\u0014\u000e\u0003EI!!R\t\u0003\u000f\r\u000b\u0007\u000f^;sK\u0006q\u0001\u000e\u001e;q\u00072LWM\u001c;J[Bd\u0007\u0003\u0002%J\u0017\u001ej\u0011!F\u0005\u0003\u0015V\u00111\u0004\u0013;uaJ+\u0017/^3ti\n+\u0018\u000e\u001c3fe\u0016CH/\u001a8tS>t\u0007C\u0001\u0015M\t\u0015i\u0005A1\u0001-\u0005\u0005\u0019\u0015A\u0002\u001fj]&$h\bF\u0001Q)\u0011\t&k\u0015+\u0011\t\r\u0003qe\u0013\u0005\u0006A\u0011\u0001\u001d!\t\u0005\u0006\u0003\u0012\u0001\u001dA\u0011\u0005\u0006\r\u0012\u0001\u001da\u0012\u0002\u0002\u0017V\u0011q+\u001b\t\u00061n;S\f[\u0007\u00023*\u0011!lI\u0001\u0005I\u0006$\u0018-\u0003\u0002]3\n91\n\\3jg2L\u0007\u0003\u00020cK\u0016t!a\u00181\u0011\u0005ab\u0012BA1\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0004\u001b\u0006\u0004(BA1\u001d!\tqf-\u0003\u0002hI\n11\u000b\u001e:j]\u001e\u0004\"\u0001K5\u0005\u000b),!\u0019\u0001\u0017\u0003\u0003\u0005#\"\u0001\\@\u0011\t5\fH/ \b\u0003]Bt!\u0001O8\n\u0003\u0011J!!P\u0012\n\u0005I\u001c(A\u0004\u0013uS2$W\rJ4sK\u0006$XM\u001d\u0006\u0003{\r\u0002\"!\u001e>\u000f\u0005YDhB\u0001\u001dx\u0013\u00051\u0012BA=\u0016\u0003\r\t\u0007\u000f]\u0005\u0003wr\u0014\u0001bR5u\u0011V\u0014Gg\u001d\u0006\u0003sV\u0001\"A`\u0003\u000e\u0003\u0001Aa\u0001\t\u0004A\u0004\u0005\u0005\u0001#\u0002\u0012\u0002\u0004\u001d*\u0014bAA\u0003G\tQQj\u001c8bI\u0016\u0013(o\u001c:\u00021I,\u0007o\\:ji>\u0014\u0018p\u00149t\u0013:$XM\u001d9sKR,'/\u0006\u0002\u0002\fA)Q.]A\u0007{B!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014M\tq!\u00197hK\n\u0014\u0018-\u0003\u0003\u0002\u0018\u0005E!\u0001\u0004*fa>\u001c\u0018\u000e^8ss>\u0003\u0018AE;tKJ|\u0005o]%oi\u0016\u0014\bO]3uKJ,\"!!\b\u0011\u000b5\f\u0018qD?\u0011\t\u0005=\u0011\u0011E\u0005\u0005\u0003G\t\tB\u0001\u0004Vg\u0016\u0014x\n]\u0001\u0013CV$\bn\u00149t\u0013:$XM\u001d9sKR,'/\u0006\u0002\u0002*A)Q.]A\u0016{B!\u0011qBA\u0017\u0013\u0011\ty#!\u0005\u0003\r\u0005+H\u000f[(q\u0003I9\u0017n\u001d;PaNLe\u000e^3saJ,G/\u001a:\u0016\u0005\u0005U\u0002#B7r\u0003oi\b\u0003BA\b\u0003sIA!a\u000f\u0002\u0012\t1q)[:u\u001fB\f1#[:tk\u0016|\u0005o]%oi\u0016\u0014\bO]3uKJ,\"!!\u0011\u0011\u000b5\f\u00181I?\u0011\t\u0005=\u0011QI\u0005\u0005\u0003\u000f\n\tBA\u0004JgN,Xm\u00149\u0002-\u0005\u001cG/\u001b<jif|\u0005o]%oi\u0016\u0014\bO]3uKJ,\"!!\u0014\u0011\u000b5\f\u0018qJ?\u0011\t\u0005=\u0011\u0011K\u0005\u0005\u0003'\n\tB\u0001\u0006BGRLg/\u001b;z\u001fB\fQcZ5u\t\u0006$\u0018m\u00149t\u0013:$XM\u001d9sKR,'/\u0006\u0002\u0002ZA)Q.]A.{B!\u0011qBA/\u0013\u0011\ty&!\u0005\u0003\u0013\u001dKG\u000fR1uC>\u0003\u0018!\u00079vY2\u0014V-];fgR|\u0005o]%oi\u0016\u0014\bO]3uKJ,\"!!\u001a\u0011\u000b5\f\u0018qM?\u0011\t\u0005=\u0011\u0011N\u0005\u0005\u0003W\n\tBA\u0007Qk2d'+Z9vKN$x\n]\u0001\u001b_J<\u0017M\\5{CRLwN\\(qg&sG/\u001a:qe\u0016$XM]\u000b\u0003\u0003c\u0002R!\\9\u0002tu\u0004B!a\u0004\u0002v%!\u0011qOA\t\u00059y%oZ1oSj\fG/[8o\u001fB\u0004")
public class Interpreters<M, C> {
    public final Capture<M> github4s$free$interpreters$Interpreters$$C;
    public final HttpRequestBuilderExtension<C, M> github4s$free$interpreters$Interpreters$$httpClientImpl;

    public FunctionK<EitherK, Kleisli> interpreters(MonadError<M, Throwable> A) {
        FunctionK c01interpreter = this.repositoryOpsInterpreter().or(this.userOpsInterpreter());
        FunctionK c02interpreter = this.gistOpsInterpreter().or(c01interpreter);
        FunctionK c03interpreter = this.issueOpsInterpreter().or(c02interpreter);
        FunctionK c04interpreter = this.authOpsInterpreter().or(c03interpreter);
        FunctionK c05interpreter = this.gitDataOpsInterpreter().or(c04interpreter);
        FunctionK c06interpreter = this.pullRequestOpsInterpreter().or(c05interpreter);
        FunctionK c07interpreter = this.activityOpsInterpreter().or(c06interpreter);
        FunctionK all = this.organizationOpsInterpreter().or(c07interpreter);
        return all;
    }

    public FunctionK<RepositoryOp, Kleisli> repositoryOpsInterpreter() {
        return new FunctionK<RepositoryOp, Kleisli>(this){
            private final Repos<C, M> repos;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, RepositoryOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<RepositoryOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<RepositoryOp, ?> and(FunctionK<RepositoryOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Repos<C, M> repos() {
                return this.repos;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(RepositoryOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    RepositoryOp repositoryOp = fa;
                    if (repositoryOp instanceof GetRepo) {
                        GetRepo getRepo = (GetRepo)repositoryOp;
                        String owner = getRepo.owner();
                        String repo = getRepo.repo();
                        Option<String> accessToken = getRepo.accessToken();
                        m = this.repos().get(accessToken, (Map<String, String>)headers, owner, repo);
                    } else if (repositoryOp instanceof ListOrgRepos) {
                        ListOrgRepos listOrgRepos = (ListOrgRepos)repositoryOp;
                        String org = listOrgRepos.org();
                        Option<String> tipe = listOrgRepos.type();
                        Option<Pagination> pagination = listOrgRepos.pagination();
                        Option<String> accessToken = listOrgRepos.accessToken();
                        m = this.repos().listOrgRepos(accessToken, (Map<String, String>)headers, org, tipe, pagination);
                    } else if (repositoryOp instanceof ListUserRepos) {
                        ListUserRepos listUserRepos = (ListUserRepos)repositoryOp;
                        String user = listUserRepos.user();
                        Option<String> tipe = listUserRepos.type();
                        Option<Pagination> pagination = listUserRepos.pagination();
                        Option<String> accessToken = listUserRepos.accessToken();
                        m = this.repos().listUserRepos(accessToken, (Map<String, String>)headers, user, tipe, pagination);
                    } else if (repositoryOp instanceof GetContents) {
                        GetContents getContents = (GetContents)repositoryOp;
                        String owner = getContents.owner();
                        String repo = getContents.repo();
                        String path = getContents.path();
                        Option<String> ref = getContents.ref();
                        Option<String> accessToken = getContents.accessToken();
                        m = this.repos().getContents(accessToken, (Map<String, String>)headers, owner, repo, path, ref);
                    } else if (repositoryOp instanceof ListCommits) {
                        ListCommits listCommits2 = (ListCommits)repositoryOp;
                        String owner = listCommits2.owner();
                        String repo = listCommits2.repo();
                        Option<String> sha = listCommits2.sha();
                        Option<String> path = listCommits2.path();
                        Option<String> author = listCommits2.author();
                        Option<String> since = listCommits2.since();
                        Option<String> until = listCommits2.until();
                        Option<Pagination> pagination = listCommits2.pagination();
                        Option<String> accessToken = listCommits2.accessToken();
                        m = this.repos().listCommits(accessToken, (Map<String, String>)headers, owner, repo, sha, path, author, since, until, pagination);
                    } else if (repositoryOp instanceof ListBranches) {
                        ListBranches listBranches2 = (ListBranches)repositoryOp;
                        String owner = listBranches2.owner();
                        String repo = listBranches2.repo();
                        Option<Object> branchProtected = listBranches2.protected();
                        Option<String> accessToken = listBranches2.accessToken();
                        m = this.repos().listBranches(accessToken, (Map<String, String>)headers, owner, repo, branchProtected);
                    } else if (repositoryOp instanceof ListContributors) {
                        ListContributors listContributors2 = (ListContributors)repositoryOp;
                        String owner = listContributors2.owner();
                        String repo = listContributors2.repo();
                        Option<String> anon2 = listContributors2.anon();
                        Option<String> accessToken = listContributors2.accessToken();
                        m = this.repos().listContributors(accessToken, (Map<String, String>)headers, owner, repo, anon2);
                    } else if (repositoryOp instanceof ListCollaborators) {
                        ListCollaborators listCollaborators2 = (ListCollaborators)repositoryOp;
                        String owner = listCollaborators2.owner();
                        String repo = listCollaborators2.repo();
                        Option<String> affiliation = listCollaborators2.affiliation();
                        Option<String> accessToken = listCollaborators2.accessToken();
                        m = this.repos().listCollaborators(accessToken, (Map<String, String>)headers, owner, repo, affiliation);
                    } else if (repositoryOp instanceof CreateRelease) {
                        CreateRelease createRelease = (CreateRelease)repositoryOp;
                        String owner = createRelease.owner();
                        String repo = createRelease.repo();
                        String tagName = createRelease.tagName();
                        String name = createRelease.name();
                        String body = createRelease.body();
                        Option<String> targetCommitish = createRelease.targetCommitish();
                        Option<Object> draft = createRelease.draft();
                        Option<Object> prerelease = createRelease.prerelease();
                        Option<String> accessToken = createRelease.accessToken();
                        m = this.repos().createRelease(accessToken, (Map<String, String>)headers, owner, repo, tagName, name, body, targetCommitish, draft, prerelease);
                    } else if (repositoryOp instanceof GetCombinedStatus) {
                        GetCombinedStatus getCombinedStatus = (GetCombinedStatus)repositoryOp;
                        String owner = getCombinedStatus.owner();
                        String repo = getCombinedStatus.repo();
                        String ref = getCombinedStatus.ref();
                        Option<String> accessToken = getCombinedStatus.accessToken();
                        m = this.repos().getStatus(accessToken, (Map<String, String>)headers, owner, repo, ref);
                    } else if (repositoryOp instanceof ListStatuses) {
                        ListStatuses listStatuses = (ListStatuses)repositoryOp;
                        String owner = listStatuses.owner();
                        String repo = listStatuses.repo();
                        String ref = listStatuses.ref();
                        Option<String> accessToken = listStatuses.accessToken();
                        m = this.repos().listStatuses(accessToken, (Map<String, String>)headers, owner, repo, ref);
                    } else if (repositoryOp instanceof CreateStatus) {
                        CreateStatus createStatus = (CreateStatus)repositoryOp;
                        String owner = createStatus.owner();
                        String repo = createStatus.repo();
                        String sha = createStatus.sha();
                        String state = createStatus.state();
                        Option<String> target_url = createStatus.target_url();
                        Option<String> description = createStatus.description();
                        Option<String> context = createStatus.context();
                        Option<String> accessToken = createStatus.accessToken();
                        m = this.repos().createStatus(accessToken, (Map<String, String>)headers, owner, repo, sha, state, target_url, description, context);
                    } else {
                        throw new MatchError((Object)repositoryOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.repos = new Repos<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(github4s.free.interpreters.Interpreters$$anon$3 github4s.free.algebra.RepositoryOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<UserOp, Kleisli> userOpsInterpreter() {
        return new FunctionK<UserOp, Kleisli>(this){
            private final Users<C, M> users;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, UserOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<UserOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<UserOp, ?> and(FunctionK<UserOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Users<C, M> users() {
                return this.users;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(UserOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    UserOp userOp = fa;
                    if (userOp instanceof GetUser) {
                        GetUser getUser = (GetUser)userOp;
                        String username = getUser.username();
                        Option<String> accessToken = getUser.accessToken();
                        m = this.users().get(accessToken, (Map<String, String>)headers, username);
                    } else if (userOp instanceof GetAuthUser) {
                        GetAuthUser getAuthUser = (GetAuthUser)userOp;
                        Option<String> accessToken = getAuthUser.accessToken();
                        m = this.users().getAuth(accessToken, (Map<String, String>)headers);
                    } else if (userOp instanceof GetUsers) {
                        GetUsers getUsers = (GetUsers)userOp;
                        int since = getUsers.since();
                        Option<Pagination> pagination = getUsers.pagination();
                        Option<String> accessToken = getUsers.accessToken();
                        m = this.users().getUsers(accessToken, (Map<String, String>)headers, since, pagination);
                    } else {
                        throw new MatchError((Object)userOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.users = new Users<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$2(github4s.free.interpreters.Interpreters$$anon$4 github4s.free.algebra.UserOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<AuthOp, Kleisli> authOpsInterpreter() {
        return new FunctionK<AuthOp, Kleisli>(this){
            private final Auth<C, M> auth;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, AuthOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<AuthOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<AuthOp, ?> and(FunctionK<AuthOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Auth<C, M> auth() {
                return this.auth;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(AuthOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    AuthOp authOp = fa;
                    if (authOp instanceof NewAuth) {
                        NewAuth newAuth = (NewAuth)authOp;
                        String username = newAuth.username();
                        String password = newAuth.password();
                        List<String> scopes = newAuth.scopes();
                        String note = newAuth.note();
                        String client_id = newAuth.client_id();
                        String client_secret = newAuth.client_secret();
                        m = this.auth().newAuth(username, password, scopes, note, client_id, client_secret, (Map<String, String>)headers);
                    } else if (authOp instanceof AuthorizeUrl) {
                        AuthorizeUrl authorizeUrl = (AuthorizeUrl)authOp;
                        String client_id = authorizeUrl.client_id();
                        String redirect_uri = authorizeUrl.redirect_uri();
                        List<String> scopes = authorizeUrl.scopes();
                        m = this.auth().authorizeUrl(client_id, redirect_uri, scopes);
                    } else if (authOp instanceof GetAccessToken) {
                        GetAccessToken getAccessToken = (GetAccessToken)authOp;
                        String client_id = getAccessToken.client_id();
                        String client_secret = getAccessToken.client_secret();
                        String code = getAccessToken.code();
                        String redirect_uri = getAccessToken.redirect_uri();
                        String state = getAccessToken.state();
                        m = this.auth().getAccessToken(client_id, client_secret, code, redirect_uri, state, (Map<String, String>)headers);
                    } else {
                        throw new MatchError((Object)authOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.auth = new Auth<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$3(github4s.free.interpreters.Interpreters$$anon$5 github4s.free.algebra.AuthOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<GistOp, Kleisli> gistOpsInterpreter() {
        return new FunctionK<GistOp, Kleisli>(this){
            private final Gists<C, M> gists;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, GistOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<GistOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<GistOp, ?> and(FunctionK<GistOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Gists<C, M> gists() {
                return this.gists;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(GistOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    GistOp gistOp = fa;
                    if (gistOp instanceof NewGist) {
                        NewGist newGist = (NewGist)gistOp;
                        String description = newGist.description();
                        boolean bl = newGist.public();
                        Map<String, GistFile> files = newGist.files();
                        Option<String> accessToken = newGist.accessToken();
                        m = this.gists().newGist(description, bl, files, (Map<String, String>)headers, accessToken);
                    } else if (gistOp instanceof GetGist) {
                        GetGist getGist = (GetGist)gistOp;
                        String gistId = getGist.gistId();
                        Option<String> sha = getGist.sha();
                        Option<String> accessToken = getGist.accessToken();
                        m = this.gists().getGist(gistId, sha, (Map<String, String>)headers, accessToken);
                    } else if (gistOp instanceof EditGist) {
                        EditGist editGist = (EditGist)gistOp;
                        String gistId = editGist.gistId();
                        String description = editGist.description();
                        Map<String, Option<EditGistFile>> files = editGist.files();
                        Option<String> accessToken = editGist.accessToken();
                        m = this.gists().editGist(gistId, description, files, (Map<String, String>)headers, accessToken);
                    } else {
                        throw new MatchError((Object)gistOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.gists = new Gists<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$4(github4s.free.interpreters.Interpreters$$anon$6 github4s.free.algebra.GistOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<IssueOp, Kleisli> issueOpsInterpreter() {
        return new FunctionK<IssueOp, Kleisli>(this){
            private final Issues<C, M> issues;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, IssueOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<IssueOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<IssueOp, ?> and(FunctionK<IssueOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Issues<C, M> issues() {
                return this.issues;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(IssueOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    IssueOp issueOp = fa;
                    if (issueOp instanceof ListIssues) {
                        ListIssues listIssues = (ListIssues)issueOp;
                        String owner = listIssues.owner();
                        String repo = listIssues.repo();
                        Option<String> accessToken = listIssues.accessToken();
                        m = this.issues().list(accessToken, (Map<String, String>)headers, owner, repo);
                    } else if (issueOp instanceof GetIssue) {
                        GetIssue getIssue = (GetIssue)issueOp;
                        String owner = getIssue.owner();
                        String repo = getIssue.repo();
                        int number = getIssue.number();
                        Option<String> accessToken = getIssue.accessToken();
                        m = this.issues().get(accessToken, (Map<String, String>)headers, owner, repo, number);
                    } else if (issueOp instanceof SearchIssues) {
                        SearchIssues searchIssues = (SearchIssues)issueOp;
                        String query = searchIssues.query();
                        List<SearchParam> searchParams = searchIssues.searchParams();
                        Option<String> accessToken = searchIssues.accessToken();
                        m = this.issues().search(accessToken, (Map<String, String>)headers, query, searchParams);
                    } else if (issueOp instanceof CreateIssue) {
                        CreateIssue createIssue = (CreateIssue)issueOp;
                        String owner = createIssue.owner();
                        String repo = createIssue.repo();
                        String title = createIssue.title();
                        String body = createIssue.body();
                        Option<Object> milestone = createIssue.milestone();
                        List<String> labels = createIssue.labels();
                        List<String> assignees = createIssue.assignees();
                        Option<String> accessToken = createIssue.accessToken();
                        m = this.issues().create(accessToken, (Map<String, String>)headers, owner, repo, title, body, milestone, labels, assignees);
                    } else if (issueOp instanceof EditIssue) {
                        EditIssue editIssue = (EditIssue)issueOp;
                        String owner = editIssue.owner();
                        String repo = editIssue.repo();
                        int issue = editIssue.issue();
                        String state = editIssue.state();
                        String title = editIssue.title();
                        String body = editIssue.body();
                        Option<Object> milestone = editIssue.milestone();
                        List<String> labels = editIssue.labels();
                        List<String> assignees = editIssue.assignees();
                        Option<String> accessToken = editIssue.accessToken();
                        m = this.issues().edit(accessToken, (Map<String, String>)headers, owner, repo, issue, state, title, body, milestone, labels, assignees);
                    } else if (issueOp instanceof ListComments) {
                        ListComments listComments = (ListComments)issueOp;
                        String owner = listComments.owner();
                        String repo = listComments.repo();
                        int number = listComments.number();
                        Option<String> accessToken = listComments.accessToken();
                        m = this.issues().listComments(accessToken, (Map<String, String>)headers, owner, repo, number);
                    } else if (issueOp instanceof CreateComment) {
                        CreateComment createComment = (CreateComment)issueOp;
                        String owner = createComment.owner();
                        String repo = createComment.repo();
                        int number = createComment.number();
                        String body = createComment.body();
                        Option<String> accessToken = createComment.accessToken();
                        m = this.issues().createComment(accessToken, (Map<String, String>)headers, owner, repo, number, body);
                    } else if (issueOp instanceof EditComment) {
                        EditComment editComment = (EditComment)issueOp;
                        String owner = editComment.owner();
                        String repo = editComment.repo();
                        int id = editComment.id();
                        String body = editComment.body();
                        Option<String> accessToken = editComment.accessToken();
                        m = this.issues().editComment(accessToken, (Map<String, String>)headers, owner, repo, id, body);
                    } else if (issueOp instanceof DeleteComment) {
                        DeleteComment deleteComment = (DeleteComment)issueOp;
                        String owner = deleteComment.owner();
                        String repo = deleteComment.repo();
                        int id = deleteComment.id();
                        Option<String> accessToken = deleteComment.accessToken();
                        m = this.issues().deleteComment(accessToken, (Map<String, String>)headers, owner, repo, id);
                    } else if (issueOp instanceof ListLabels) {
                        ListLabels listLabels = (ListLabels)issueOp;
                        String owner = listLabels.owner();
                        String repo = listLabels.repo();
                        int number = listLabels.number();
                        Option<String> accessToken = listLabels.accessToken();
                        m = this.issues().listLabels(accessToken, (Map<String, String>)headers, owner, repo, number);
                    } else if (issueOp instanceof AddLabels) {
                        AddLabels addLabels = (AddLabels)issueOp;
                        String owner = addLabels.owner();
                        String repo = addLabels.repo();
                        int number = addLabels.number();
                        List<String> labels = addLabels.labels();
                        Option<String> accessToken = addLabels.accessToken();
                        m = this.issues().addLabels(accessToken, (Map<String, String>)headers, owner, repo, number, labels);
                    } else if (issueOp instanceof RemoveLabel) {
                        RemoveLabel removeLabel = (RemoveLabel)issueOp;
                        String owner = removeLabel.owner();
                        String repo = removeLabel.repo();
                        int number = removeLabel.number();
                        String label = removeLabel.label();
                        Option<String> accessToken = removeLabel.accessToken();
                        m = this.issues().removeLabel(accessToken, (Map<String, String>)headers, owner, repo, number, label);
                    } else if (issueOp instanceof ListAvailableAssignees) {
                        ListAvailableAssignees listAvailableAssignees = (ListAvailableAssignees)issueOp;
                        String owner = listAvailableAssignees.owner();
                        String repo = listAvailableAssignees.repo();
                        Option<Pagination> pagination = listAvailableAssignees.pagination();
                        Option<String> accessToken = listAvailableAssignees.accessToken();
                        m = this.issues().listAvailableAssignees(accessToken, (Map<String, String>)headers, owner, repo, pagination);
                    } else {
                        throw new MatchError((Object)issueOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.issues = new Issues<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$5(github4s.free.interpreters.Interpreters$$anon$7 github4s.free.algebra.IssueOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<ActivityOp, Kleisli> activityOpsInterpreter() {
        return new FunctionK<ActivityOp, Kleisli>(this){
            private final Activities<C, M> activities;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, ActivityOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<ActivityOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<ActivityOp, ?> and(FunctionK<ActivityOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Activities<C, M> activities() {
                return this.activities;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(ActivityOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    ActivityOp activityOp = fa;
                    if (activityOp instanceof SetThreadSub) {
                        SetThreadSub setThreadSub = (SetThreadSub)activityOp;
                        int id = setThreadSub.id();
                        boolean subscribed = setThreadSub.subscribed();
                        boolean ignored = setThreadSub.ignored();
                        Option<String> accessToken = setThreadSub.accessToken();
                        m = this.activities().setThreadSub(accessToken, (Map<String, String>)headers, id, subscribed, ignored);
                    } else if (activityOp instanceof ListStargazers) {
                        ListStargazers listStargazers = (ListStargazers)activityOp;
                        String owner = listStargazers.owner();
                        String repo = listStargazers.repo();
                        boolean timeline = listStargazers.timeline();
                        Option<Pagination> pagination = listStargazers.pagination();
                        Option<String> accessToken = listStargazers.accessToken();
                        m = this.activities().listStargazers(accessToken, (Map<String, String>)headers, owner, repo, timeline, pagination);
                    } else if (activityOp instanceof ListStarredRepositories) {
                        ListStarredRepositories listStarredRepositories2 = (ListStarredRepositories)activityOp;
                        String username = listStarredRepositories2.username();
                        boolean timeline = listStarredRepositories2.timeline();
                        Option<String> sort = listStarredRepositories2.sort();
                        Option<String> direction = listStarredRepositories2.direction();
                        Option<Pagination> pagination = listStarredRepositories2.pagination();
                        Option<String> accessToken = listStarredRepositories2.accessToken();
                        m = this.activities().listStarredRepositories(accessToken, (Map<String, String>)headers, username, timeline, sort, direction, pagination);
                    } else {
                        throw new MatchError((Object)activityOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.activities = new Activities<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$6(github4s.free.interpreters.Interpreters$$anon$8 github4s.free.algebra.ActivityOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<GitDataOp, Kleisli> gitDataOpsInterpreter() {
        return new FunctionK<GitDataOp, Kleisli>(this){
            private final GitData<C, M> gitData;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, GitDataOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<GitDataOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<GitDataOp, ?> and(FunctionK<GitDataOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private GitData<C, M> gitData() {
                return this.gitData;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(GitDataOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    GitDataOp gitDataOp = fa;
                    if (gitDataOp instanceof GetReference) {
                        GetReference getReference = (GetReference)gitDataOp;
                        String owner = getReference.owner();
                        String repo = getReference.repo();
                        String ref = getReference.ref();
                        Option<String> accessToken = getReference.accessToken();
                        m = this.gitData().reference(accessToken, (Map<String, String>)headers, owner, repo, ref);
                    } else if (gitDataOp instanceof CreateReference) {
                        CreateReference createReference = (CreateReference)gitDataOp;
                        String owner = createReference.owner();
                        String repo = createReference.repo();
                        String ref = createReference.ref();
                        String sha = createReference.sha();
                        Option<String> accessToken = createReference.accessToken();
                        m = this.gitData().createReference(accessToken, (Map<String, String>)headers, owner, repo, ref, sha);
                    } else if (gitDataOp instanceof UpdateReference) {
                        UpdateReference updateReference = (UpdateReference)gitDataOp;
                        String owner = updateReference.owner();
                        String repo = updateReference.repo();
                        String ref = updateReference.ref();
                        String sha = updateReference.sha();
                        boolean force = updateReference.force();
                        Option<String> accessToken = updateReference.accessToken();
                        m = this.gitData().updateReference(accessToken, (Map<String, String>)headers, owner, repo, ref, sha, force);
                    } else if (gitDataOp instanceof GetCommit) {
                        GetCommit getCommit = (GetCommit)gitDataOp;
                        String owner = getCommit.owner();
                        String repo = getCommit.repo();
                        String sha = getCommit.sha();
                        Option<String> accessToken = getCommit.accessToken();
                        m = this.gitData().commit(accessToken, (Map<String, String>)headers, owner, repo, sha);
                    } else if (gitDataOp instanceof CreateCommit) {
                        CreateCommit createCommit = (CreateCommit)gitDataOp;
                        String owner = createCommit.owner();
                        String repo = createCommit.repo();
                        String message = createCommit.message();
                        String tree = createCommit.tree();
                        List<String> parents = createCommit.parents();
                        Option<RefAuthor> author = createCommit.author();
                        Option<String> accessToken = createCommit.accessToken();
                        m = this.gitData().createCommit(accessToken, (Map<String, String>)headers, owner, repo, message, tree, parents, author);
                    } else if (gitDataOp instanceof CreateBlob) {
                        CreateBlob createBlob = (CreateBlob)gitDataOp;
                        String owner = createBlob.owner();
                        String repo = createBlob.repo();
                        String content = createBlob.content();
                        Option<String> encoding = createBlob.encoding();
                        Option<String> accessToken = createBlob.accessToken();
                        m = this.gitData().createBlob(accessToken, (Map<String, String>)headers, owner, repo, content, encoding);
                    } else if (gitDataOp instanceof CreateTree) {
                        CreateTree createTree = (CreateTree)gitDataOp;
                        String owner = createTree.owner();
                        String repo = createTree.repo();
                        Option<String> baseTree = createTree.baseTree();
                        List<TreeData> treeDataList = createTree.treeDataList();
                        Option<String> accessToken = createTree.accessToken();
                        m = this.gitData().createTree(accessToken, (Map<String, String>)headers, owner, repo, baseTree, treeDataList);
                    } else if (gitDataOp instanceof GetTree) {
                        GetTree getTree = (GetTree)gitDataOp;
                        String owner = getTree.owner();
                        String repo = getTree.repo();
                        String sha = getTree.sha();
                        boolean recursive = getTree.recursive();
                        Option<String> accessToken = getTree.accessToken();
                        m = this.gitData().tree(accessToken, (Map<String, String>)headers, owner, repo, sha, recursive);
                    } else if (gitDataOp instanceof CreateTag) {
                        CreateTag createTag = (CreateTag)gitDataOp;
                        String owner = createTag.owner();
                        String repo = createTag.repo();
                        String tag = createTag.tag();
                        String message = createTag.message();
                        String objectSha = createTag.objectSha();
                        String objectType = createTag.objectType();
                        Option<RefAuthor> author = createTag.author();
                        Option<String> accessToken = createTag.accessToken();
                        m = this.gitData().createTag(accessToken, (Map<String, String>)headers, owner, repo, tag, message, objectSha, objectType, author);
                    } else {
                        throw new MatchError((Object)gitDataOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.gitData = new GitData<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$7(github4s.free.interpreters.Interpreters$$anon$9 github4s.free.algebra.GitDataOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<PullRequestOp, Kleisli> pullRequestOpsInterpreter() {
        return new FunctionK<PullRequestOp, Kleisli>(this){
            private final PullRequests<C, M> pullRequests;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, PullRequestOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<PullRequestOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<PullRequestOp, ?> and(FunctionK<PullRequestOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private PullRequests<C, M> pullRequests() {
                return this.pullRequests;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(PullRequestOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    PullRequestOp pullRequestOp = fa;
                    if (pullRequestOp instanceof GetPullRequest) {
                        GetPullRequest getPullRequest = (GetPullRequest)pullRequestOp;
                        String owner = getPullRequest.owner();
                        String repo = getPullRequest.repo();
                        int number = getPullRequest.number();
                        Option<String> accessToken = getPullRequest.accessToken();
                        m = this.pullRequests().get(accessToken, (Map<String, String>)headers, owner, repo, number);
                    } else if (pullRequestOp instanceof ListPullRequests) {
                        ListPullRequests listPullRequests = (ListPullRequests)pullRequestOp;
                        String owner = listPullRequests.owner();
                        String repo = listPullRequests.repo();
                        List<PRFilter> filters = listPullRequests.filters();
                        Option<String> accessToken = listPullRequests.accessToken();
                        Option<Pagination> pagination = listPullRequests.pagination();
                        m = this.pullRequests().list(accessToken, (Map<String, String>)headers, owner, repo, filters, pagination);
                    } else if (pullRequestOp instanceof ListPullRequestFiles) {
                        ListPullRequestFiles listPullRequestFiles = (ListPullRequestFiles)pullRequestOp;
                        String owner = listPullRequestFiles.owner();
                        String repo = listPullRequestFiles.repo();
                        int number = listPullRequestFiles.number();
                        Option<String> accessToken = listPullRequestFiles.accessToken();
                        Option<Pagination> pagination = listPullRequestFiles.pagination();
                        m = this.pullRequests().listFiles(accessToken, (Map<String, String>)headers, owner, repo, number, pagination);
                    } else if (pullRequestOp instanceof CreatePullRequest) {
                        CreatePullRequest createPullRequest = (CreatePullRequest)pullRequestOp;
                        String owner = createPullRequest.owner();
                        String repo = createPullRequest.repo();
                        NewPullRequest newPullRequest = createPullRequest.newPullRequest();
                        String head = createPullRequest.head();
                        String base = createPullRequest.base();
                        Option<Object> maintainerCanModify = createPullRequest.maintainerCanModify();
                        Option<String> accessToken = createPullRequest.accessToken();
                        m = this.pullRequests().create(accessToken, (Map<String, String>)headers, owner, repo, newPullRequest, head, base, maintainerCanModify);
                    } else if (pullRequestOp instanceof ListPullRequestReviews) {
                        ListPullRequestReviews listPullRequestReviews = (ListPullRequestReviews)pullRequestOp;
                        String owner = listPullRequestReviews.owner();
                        String repo = listPullRequestReviews.repo();
                        int pullRequest = listPullRequestReviews.pullRequest();
                        Option<String> accessToken = listPullRequestReviews.accessToken();
                        Option<Pagination> pagination = listPullRequestReviews.pagination();
                        m = this.pullRequests().listReviews(accessToken, (Map<String, String>)headers, owner, repo, pullRequest, pagination);
                    } else if (pullRequestOp instanceof GetPullRequestReview) {
                        GetPullRequestReview getPullRequestReview = (GetPullRequestReview)pullRequestOp;
                        String owner = getPullRequestReview.owner();
                        String repo = getPullRequestReview.repo();
                        int pullRequest = getPullRequestReview.pullRequest();
                        int review = getPullRequestReview.review();
                        Option<String> accessToken = getPullRequestReview.accessToken();
                        m = this.pullRequests().getReview(accessToken, (Map<String, String>)headers, owner, repo, pullRequest, review);
                    } else {
                        throw new MatchError((Object)pullRequestOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.pullRequests = new PullRequests<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$8(github4s.free.interpreters.Interpreters$$anon$10 github4s.free.algebra.PullRequestOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public FunctionK<OrganizationOp, Kleisli> organizationOpsInterpreter() {
        return new FunctionK<OrganizationOp, Kleisli>(this){
            private final Organizations<C, M> organizations;

            public <E> FunctionK<E, Kleisli> compose(FunctionK<E, OrganizationOp> f) {
                return FunctionK.compose$((FunctionK)this, f);
            }

            public <H> FunctionK<OrganizationOp, H> andThen(FunctionK<Kleisli, H> f) {
                return FunctionK.andThen$((FunctionK)this, f);
            }

            public <H> FunctionK<?, Kleisli> or(FunctionK<H, Kleisli> h) {
                return FunctionK.or$((FunctionK)this, h);
            }

            public <H> FunctionK<OrganizationOp, ?> and(FunctionK<OrganizationOp, H> h) {
                return FunctionK.and$((FunctionK)this, h);
            }

            private Organizations<C, M> organizations() {
                return this.organizations;
            }

            public <A> Kleisli<M, Map<String, String>, A> apply(OrganizationOp<A> fa) {
                return new Kleisli((Function1 & Serializable & scala.Serializable)headers -> {
                    M m;
                    OrganizationOp organizationOp = fa;
                    if (organizationOp instanceof ListMembers) {
                        ListMembers listMembers2 = (ListMembers)organizationOp;
                        String org = listMembers2.org();
                        Option<String> filter = listMembers2.filter();
                        Option<String> role = listMembers2.role();
                        Option<Pagination> pagination = listMembers2.pagination();
                        Option<String> accessToken = listMembers2.accessToken();
                        m = this.organizations().listMembers(accessToken, (Map<String, String>)headers, org, filter, role, pagination);
                    } else if (organizationOp instanceof ListOutsideCollaborators) {
                        ListOutsideCollaborators listOutsideCollaborators2 = (ListOutsideCollaborators)organizationOp;
                        String org = listOutsideCollaborators2.org();
                        Option<String> filter = listOutsideCollaborators2.filter();
                        Option<Pagination> pagination = listOutsideCollaborators2.pagination();
                        Option<String> accessToken = listOutsideCollaborators2.accessToken();
                        m = this.organizations().listOutsideCollaborators(accessToken, (Map<String, String>)headers, org, filter, pagination);
                    } else {
                        throw new MatchError((Object)organizationOp);
                    }
                    return m;
                });
            }
            {
                FunctionK.$init$((FunctionK)this);
                this.organizations = new Organizations<C, M>(GithubDefaultUrls$.MODULE$.defaultUrls(), $outer.github4s$free$interpreters$Interpreters$$C, $outer.github4s$free$interpreters$Interpreters$$httpClientImpl);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$9(github4s.free.interpreters.Interpreters$$anon$11 github4s.free.algebra.OrganizationOp scala.collection.immutable.Map )}, serializedLambda);
            }
        };
    }

    public Interpreters(ApplicativeError<M, Throwable> A, Capture<M> C, HttpRequestBuilderExtension<C, M> httpClientImpl) {
        this.github4s$free$interpreters$Interpreters$$C = C;
        this.github4s$free$interpreters$Interpreters$$httpClientImpl = httpClientImpl;
    }
}

