/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.easypicker;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.keenfin.easypicker.FileUtil;
import com.keenfin.easypicker.PhotoViewHolder;
import com.keenfin.easypicker.PreviewActivity;
import com.keenfin.easypicker.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PhotoPicker
extends RecyclerView {
    private int mMaxPhotos = -1;
    private int mRowHeight;
    private int mImagesPerRow;
    private int mImagesPerRowPortrait = 3;
    private int mImagesPerRowLandscape = 5;
    private String mNewPhotosDir = "EasyPicker";
    private int mColorPrimary;
    private int mColorAccent;
    private int mCameraRequest;
    private int mPickRequest;
    private boolean mIsOneLine = false;
    private boolean mIsUsePreview = true;
    private boolean mPrimaryColorDefined;
    private boolean mAccentColorDefined;
    private Context mContext;
    private PhotoAdapter mPhotoAdapter;
    private Bitmap mNewPhotoIcon;

    public PhotoPicker(Context context) {
        this(context, false);
    }

    public PhotoPicker(Context context, boolean noControls) {
        super(context);
        this.mNewPhotoIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_add_white_48dp);
        this.init(context, noControls);
    }

    public PhotoPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PhotoPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, boolean noControls) {
        this.mContext = context;
        PhotoAdapter adapter = new PhotoAdapter(noControls);
        this.setAdapter(adapter);
        this.mImagesPerRow = this.getResources().getConfiguration().orientation == 2 ? this.mImagesPerRowLandscape : this.mImagesPerRowPortrait;
        this.setHasFixedSize(true);
        Object layoutManager = this.mIsOneLine ? new LinearLayoutManager(this.getContext(), 0, false) : new GridLayoutManager(context, this.mImagesPerRow);
        this.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        int[] attrs = new int[]{R.attr.colorPrimary, R.attr.colorAccent};
        TypedArray styleable2 = context.obtainStyledAttributes(attrs);
        if (!this.mPrimaryColorDefined) {
            this.mColorPrimary = this.getColor(styleable2, 0, R.color.primary);
        }
        if (!this.mAccentColorDefined) {
            this.mColorAccent = this.getColor(styleable2, 1, R.color.accent);
        }
        styleable2.recycle();
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray styleable2 = context.obtainStyledAttributes(attrs, R.styleable.PhotoPicker, 0, 0);
        this.mImagesPerRowLandscape = styleable2.getInt(R.styleable.PhotoPicker_photosPerRowLandscape, this.mImagesPerRowLandscape);
        this.mImagesPerRowPortrait = styleable2.getInt(R.styleable.PhotoPicker_photosPerRowPortrait, this.mImagesPerRowPortrait);
        this.mIsOneLine = styleable2.getBoolean(R.styleable.PhotoPicker_oneLineGallery, false);
        int icon = styleable2.getResourceId(R.styleable.PhotoPicker_newPhotosIcon, R.drawable.ic_add_white_48dp);
        this.mNewPhotoIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)icon);
        boolean noControls = styleable2.getBoolean(R.styleable.PhotoPicker_noControls, false);
        this.init(context, noControls);
        this.mPrimaryColorDefined = styleable2.hasValue(R.styleable.PhotoPicker_primaryColor);
        if (this.mPrimaryColorDefined) {
            this.mColorPrimary = this.getColor(styleable2, R.styleable.PhotoPicker_primaryColor, R.color.primary);
        }
        if (this.mAccentColorDefined = styleable2.hasValue(R.styleable.PhotoPicker_accentColor)) {
            this.mColorAccent = this.getColor(styleable2, R.styleable.PhotoPicker_accentColor, R.color.accent);
        }
        this.mIsUsePreview = styleable2.getBoolean(R.styleable.PhotoPicker_usePreview, true);
        this.mMaxPhotos = styleable2.getInt(R.styleable.PhotoPicker_maxPhotos, this.mMaxPhotos);
        this.mNewPhotosDir = styleable2.getString(R.styleable.PhotoPicker_newPhotosDirectory);
        this.mNewPhotosDir = this.mNewPhotosDir == null ? "EasyPicker" : this.mNewPhotosDir;
        styleable2.recycle();
    }

    private int getColor(TypedArray array2, int index, int defValue) {
        return array2.getColor(index, this.mContext.getResources().getColor(defValue));
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putStringArrayList("attached_images", this.mPhotoAdapter.getImagesPath());
        bundle.putInt("camera_request", this.mCameraRequest);
        bundle.putInt("pick_request", this.mPickRequest);
        if (this.mPhotoAdapter.getPhotoUri() != null) {
            bundle.putString("new_photo_path", this.mPhotoAdapter.getPhotoUri().getPath());
        }
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            if (bundle.containsKey("new_photo_path")) {
                this.mPhotoAdapter.setPhotoUri(Uri.parse((String)bundle.getString("new_photo_path")));
            }
            this.mPhotoAdapter.restoreImages(bundle.getStringArrayList("attached_images"));
            this.mCameraRequest = bundle.getInt("camera_request");
            this.mPickRequest = bundle.getInt("pick_request");
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        super.onMeasure(widthSpec, heightSpec);
        this.mRowHeight = this.getMeasuredWidth() / this.mImagesPerRow;
        this.mPhotoAdapter.measureParent();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mPhotoAdapter.onActivityResult(requestCode, resultCode, data);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!(adapter instanceof PhotoAdapter)) {
            throw new IllegalArgumentException("You should not pass adapter to PhotoPicker. It uses specific one.");
        }
        this.mPhotoAdapter = (PhotoAdapter)adapter;
        super.setAdapter(adapter);
    }

    public void restoreImages(List<String> imagesPath) {
        this.mPhotoAdapter.restoreImages(imagesPath);
    }

    public void setMaxPhotos(int maxPhotos) {
        this.mMaxPhotos = maxPhotos;
    }

    public void setNewPhotosDirectory(String directoryName) {
        this.mNewPhotosDir = directoryName;
    }

    public void setUsePreview(boolean usePreview) {
        this.mIsUsePreview = usePreview;
    }

    public void setNewPhotosDrawable(int drawableResourceId) {
        this.mPhotoAdapter.replaceNewPhotoIcon(drawableResourceId);
    }

    public ArrayList<String> getImagesPath() {
        return this.mPhotoAdapter.getImagesPath();
    }

    public static Bitmap getBitmap(String path, int requiredSize) throws OutOfMemoryError {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int scale = 1;
        while (options.outWidth / scale > requiredSize && options.outHeight / scale > requiredSize) {
            scale *= 2;
        }
        options.inSampleSize = scale;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public class PhotoAdapter
    extends RecyclerView.Adapter<PhotoViewHolder>
    implements PhotoViewHolder.IViewHolderClick {
        private List<Bitmap> mImages = new ArrayList<Bitmap>();
        private List<String> mImagesPath = new ArrayList<String>();
        private Uri mPhotoUri;
        private boolean mNoControls = false;

        public PhotoAdapter() {
            this(false);
        }

        public PhotoAdapter(boolean noControls) {
            this.mNoControls = noControls;
            if (!noControls) {
                this.addNewPhotoIcon();
            }
        }

        private void addNewPhotoIcon() {
            this.mImages.add(0, PhotoPicker.this.mNewPhotoIcon);
            this.mImagesPath.add(0, null);
            this.notifyItemInserted(0);
        }

        protected void replaceNewPhotoIcon(int drawableResourceId) {
            if (!this.mNoControls && this.mImages.size() > 0) {
                this.mImages.remove(0);
                this.mImages.add(0, BitmapFactory.decodeResource((Resources)PhotoPicker.this.getResources(), (int)drawableResourceId));
                this.notifyItemChanged(0);
            }
        }

        public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.photo_item, parent, false);
            view.setBackgroundColor(PhotoPicker.this.mColorAccent);
            return new PhotoViewHolder(view);
        }

        public void onBindViewHolder(PhotoViewHolder holder, int position) {
            holder.setOnClickListener(this);
            holder.setPhoto(this.mImages.get(position));
            boolean isControl = position == 0 && !this.mNoControls;
            holder.adjustControl(PhotoPicker.this.mRowHeight, PhotoPicker.this.mColorPrimary, isControl, PhotoPicker.this.mIsOneLine, this.mNoControls);
        }

        public int getItemCount() {
            return this.mImages.size();
        }

        public ArrayList<String> getImagesPath() {
            ArrayList<String> images = new ArrayList<String>();
            images.addAll(this.mImagesPath);
            if (!this.mNoControls) {
                images.remove(0);
            }
            return images;
        }

        protected void restoreImages(List<String> imagesPath) {
            for (String imagePath : imagesPath) {
                this.addImage(imagePath);
            }
        }

        public Uri getPhotoUri() {
            return this.mPhotoUri;
        }

        public void setPhotoUri(Uri photoUri) {
            this.mPhotoUri = photoUri;
        }

        @Override
        public void onItemClick(View caller, int position) {
            int i = caller.getId();
            if (i == R.id.iv_photo) {
                if (position == 0 && !this.mNoControls) {
                    if (PhotoPicker.this.mMaxPhotos > -1 && this.getItemCount() - 1 >= PhotoPicker.this.mMaxPhotos) {
                        Toast.makeText((Context)PhotoPicker.this.mContext, (CharSequence)String.format(PhotoPicker.this.mContext.getString(R.string.max_photos), PhotoPicker.this.mMaxPhotos), (int)0).show();
                        return;
                    }
                    AlertDialog.Builder builder = new AlertDialog.Builder(PhotoPicker.this.mContext);
                    builder.setTitle(R.string.photo_add);
                    builder.setItems(R.array.report_add_photos, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int item) {
                            Random randomizeRequest = new Random(System.currentTimeMillis());
                            switch (item) {
                                case 0: {
                                    Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                                    File photo = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), PhotoPicker.this.mNewPhotosDir);
                                    if (!photo.mkdirs() && !photo.exists()) {
                                        Toast.makeText((Context)PhotoPicker.this.mContext, (int)R.string.hw_error, (int)0).show();
                                        return;
                                    }
                                    photo = new File(photo, System.currentTimeMillis() + ".jpg");
                                    PhotoAdapter.this.mPhotoUri = Uri.fromFile((File)photo);
                                    intent.putExtra("output", (Parcelable)PhotoAdapter.this.mPhotoUri);
                                    PhotoPicker.this.mCameraRequest = randomizeRequest.nextInt(65535);
                                    ((Activity)PhotoPicker.this.mContext).startActivityForResult(intent, PhotoPicker.this.mCameraRequest);
                                    break;
                                }
                                case 1: {
                                    Intent intent = new Intent("android.intent.action.GET_CONTENT");
                                    intent.setType("image/*");
                                    PhotoPicker.this.mPickRequest = randomizeRequest.nextInt(65535);
                                    ((Activity)PhotoPicker.this.mContext).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)PhotoPicker.this.mContext.getString(R.string.photo_pick)), PhotoPicker.this.mPickRequest);
                                }
                            }
                        }
                    });
                    builder.show();
                } else {
                    if (!PhotoPicker.this.mIsUsePreview) {
                        return;
                    }
                    int offset = this.mNoControls ? 0 : 1;
                    Intent preview = new Intent(PhotoPicker.this.getContext(), PreviewActivity.class);
                    preview.putExtra("attached_images", this.getImagesPath());
                    preview.putExtra("new_photo_path", position - offset);
                    PhotoPicker.this.getContext().startActivity(preview);
                }
            } else if (i == R.id.ib_remove) {
                if (position <= 0) {
                    return;
                }
                this.mImages.remove(position);
                this.mImagesPath.remove(position);
                this.notifyItemRemoved(position);
                this.measureParent();
            }
        }

        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (resultCode == -1) {
                String selectedImagePath;
                if (requestCode == PhotoPicker.this.mCameraRequest) {
                    selectedImagePath = this.mPhotoUri.getPath();
                } else if (requestCode == PhotoPicker.this.mPickRequest) {
                    selectedImagePath = FileUtil.getPath(PhotoPicker.this.mContext, data.getData());
                } else {
                    return;
                }
                this.addImage(selectedImagePath);
            }
        }

        private boolean addImage(String imagePath) {
            Bitmap selectedImage = PhotoPicker.getBitmap(imagePath, 200);
            if (selectedImage == null) {
                Toast.makeText((Context)PhotoPicker.this.mContext, (CharSequence)PhotoPicker.this.mContext.getString(R.string.photo_fail_attach), (int)0).show();
                return false;
            }
            boolean result = this.mImages.add(selectedImage);
            this.notifyItemInserted(this.mImages.size() - 1);
            this.measureParent();
            return result &= this.mImagesPath.add(imagePath);
        }

        public void measureParent() {
            ViewGroup.LayoutParams params = PhotoPicker.this.getLayoutParams();
            int itemsCount = PhotoPicker.this.mIsOneLine ? 1 : this.mImages.size();
            params.height = (int)Math.ceil(1.0f * (float)itemsCount / (float)PhotoPicker.this.mImagesPerRow) * PhotoPicker.this.mRowHeight;
            PhotoPicker.this.setLayoutParams(params);
        }
    }
}

