/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.easypicker;

import android.graphics.Bitmap;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.keenfin.easypicker.R;

public class PhotoViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private ImageButton mPhotoRemove;
    private ImageView mPhoto;
    private IViewHolderClick mViewHolderClick;

    public PhotoViewHolder(View itemView) {
        super(itemView);
        this.mPhotoRemove = (ImageButton)itemView.findViewById(R.id.ib_remove);
        this.mPhotoRemove.setOnClickListener((View.OnClickListener)this);
        this.mPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
        this.mPhoto.setOnClickListener((View.OnClickListener)this);
    }

    public void adjustControl(int side, int color2, boolean isControl, boolean isOneLine, boolean noControls) {
        View parentBox = this.mPhoto.getRootView();
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)parentBox.getLayoutParams();
        if (isControl) {
            if (isOneLine) {
                lp.height = lp.width = side / 2;
            }
            lp.setMargins(side / 4, side / 4, side / 4, side / 4);
            this.mPhotoRemove.setVisibility(8);
            this.mPhoto.setColorFilter(color2);
        } else {
            lp.height = lp.width = side - lp.leftMargin - lp.rightMargin;
            this.mPhotoRemove.setColorFilter(color2);
        }
        if (noControls) {
            this.mPhotoRemove.setVisibility(8);
        }
        parentBox.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setPhoto(Bitmap photo) {
        this.mPhoto.setImageBitmap(photo);
    }

    public void setOnClickListener(IViewHolderClick listener) {
        this.mViewHolderClick = listener;
    }

    public void onClick(View view) {
        this.mViewHolderClick.onItemClick(view, this.getAdapterPosition());
    }

    public static interface IViewHolderClick {
        public void onItemClick(View var1, int var2);
    }
}

