/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.easypicker;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.keenfin.easypicker.PhotoPicker;
import com.keenfin.easypicker.R;
import java.util.ArrayList;
import java.util.List;

public class PreviewActivity
extends AppCompatActivity {
    private List<String> mImages;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_preview);
        Bundle bundle = this.getIntent().getExtras();
        int position = 0;
        if (bundle != null && bundle.containsKey("attached_images")) {
            this.mImages = bundle.getStringArrayList("attached_images");
            position = bundle.getInt("new_photo_path", 0);
        }
        if (this.mImages == null) {
            this.mImages = new ArrayList<String>();
        }
        PreviewAdapter adapter = new PreviewAdapter(this.getSupportFragmentManager(), this.mImages);
        ViewPager pager = (ViewPager)this.findViewById(R.id.vp_photos);
        pager.setAdapter((PagerAdapter)adapter);
        pager.setCurrentItem(position);
    }

    public static class PreviewFragment
    extends Fragment {
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            ImageView view = (ImageView)inflater.inflate(R.layout.preview_item, container, false);
            int maxSide = Math.max(this.getActivity().getWindowManager().getDefaultDisplay().getWidth(), this.getActivity().getWindowManager().getDefaultDisplay().getHeight());
            String imagePath = null;
            if (this.getArguments() != null) {
                imagePath = this.getArguments().getString("attached_images");
            }
            view.setImageBitmap(PhotoPicker.getBitmap(imagePath, maxSide));
            return view;
        }
    }

    private static class PreviewAdapter
    extends FragmentPagerAdapter {
        private List<String> mImages;

        public PreviewAdapter(FragmentManager fm, List<String> images) {
            super(fm);
            this.mImages = images;
        }

        public int getCount() {
            return this.mImages.size();
        }

        public PreviewFragment getItem(int position) {
            PreviewFragment fragment = new PreviewFragment();
            Bundle bundle = new Bundle();
            bundle.putString("attached_images", this.mImages.get(position));
            fragment.setArguments(bundle);
            return fragment;
        }
    }
}

