/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.sfcdialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Environment;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SimpleFileChooser
extends DialogFragment
implements DialogInterface.OnClickListener {
    private SimpleFileChooserListener simpleFileChooserListener;
    private String rootPath;
    private String currentPath;
    private ArrayList<String> dirs;
    private ArrayAdapter<String> adapter;
    private ListView lvDirs;
    private boolean showHidden = true;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.rootPath = this.rootPath == null ? Environment.getExternalStorageDirectory().getAbsolutePath() : this.rootPath;
        this.currentPath = this.rootPath;
        try {
            this.rootPath = new File(this.rootPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dirs = this.getFilesInDirectory(this.rootPath);
        this.adapter = new ArrayAdapter((Context)this.getActivity(), 17367055, this.dirs);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setSingleChoiceItems(this.adapter, -1, (DialogInterface.OnClickListener)this).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).setTitle((CharSequence)this.getDirectoryName());
        AlertDialog alert = builder.create();
        this.lvDirs = alert.getListView();
        return alert;
    }

    public void onClick(DialogInterface dialog, int which) {
        File current = new File(this.currentPath);
        switch (which) {
            case -1: {
                if (current.isDirectory()) {
                    this.simpleFileChooserListener.onDirectoryChosen(current);
                }
                if (!current.isFile()) break;
                this.simpleFileChooserListener.onFileChosen(current);
                break;
            }
            case -2: {
                this.simpleFileChooserListener.onCancel();
                break;
            }
            default: {
                this.selectFile(which);
            }
        }
    }

    private void selectFile(int which) {
        String selected;
        File current = new File(this.currentPath);
        try {
            current.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (current.isFile()) {
            this.currentPath = this.currentPath.substring(0, this.currentPath.lastIndexOf("/"));
        }
        if ((selected = this.dirs.get(which).replace("/", "")).equals("..")) {
            this.currentPath = this.currentPath.substring(0, this.currentPath.lastIndexOf("/"));
            this.refreshListView();
        } else {
            this.currentPath = this.currentPath + "/" + selected;
            current = new File(this.currentPath);
            if (!current.isFile()) {
                this.refreshListView();
            }
        }
        if (!current.isFile()) {
            this.getDialog().setTitle((CharSequence)this.getDirectoryName());
        }
    }

    private void refreshListView() {
        this.dirs.clear();
        this.dirs.addAll(this.getFilesInDirectory(this.currentPath));
        this.adapter.notifyDataSetChanged();
        if (!new File(this.currentPath).isFile()) {
            for (int i = 0; i < this.lvDirs.getCount(); ++i) {
                this.lvDirs.setItemChecked(i, false);
            }
        }
    }

    private String getDirectoryName() {
        return this.currentPath.substring(this.currentPath.lastIndexOf("/"));
    }

    private ArrayList<String> getFilesInDirectory(String dir) {
        ArrayList<String> dirs = new ArrayList<String>();
        try {
            File currentDir = new File(dir);
            if (!dir.equals(this.rootPath)) {
                dirs.add("..");
            }
            if (!currentDir.exists() || !currentDir.isDirectory()) {
                return dirs;
            }
            for (File file : currentDir.listFiles()) {
                if (!this.showHidden && file.isHidden()) continue;
                if (file.isDirectory()) {
                    dirs.add(file.getName() + "/");
                    continue;
                }
                dirs.add(file.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(dirs, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        return dirs;
    }

    public void setOnChosenListener(SimpleFileChooserListener sfc) {
        this.simpleFileChooserListener = sfc;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public static interface SimpleFileChooserListener {
        public void onFileChosen(File var1);

        public void onDirectoryChosen(File var1);

        public void onCancel();
    }
}

