/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.cloud.flowelements;

import fiftyone.devicedetection.cloud.data.DeviceDataCloud;
import fiftyone.pipeline.cloudrequestengine.data.CloudRequestData;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudAspectEngineBase;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.core.data.AccessiblePropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.data.types.JavaScript;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaDataDefault;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.data.AspectPropertyValueDefault;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class DeviceDetectionCloudEngine
extends CloudAspectEngineBase<DeviceDataCloud> {
    List<AspectPropertyMetaData> aspectProperties;
    private String dataSourceTier;
    CloudRequestEngine cloudRequestEngine = null;

    public DeviceDetectionCloudEngine(Logger logger, ElementDataFactory<DeviceDataCloud> deviceDataFactory) {
        super(logger, deviceDataFactory);
    }

    public List<AspectPropertyMetaData> getProperties() {
        return this.aspectProperties;
    }

    public String getDataSourceTier() {
        return this.dataSourceTier;
    }

    public String getElementDataKey() {
        return "device";
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return new EvidenceKeyFilterWhitelist(new ArrayList());
    }

    protected void processEngine(FlowData data, DeviceDataCloud aspectData) {
        if (this.cloudRequestEngine == null) {
            throw new PipelineConfigurationException("The '" + ((Object)((Object)this)).getClass().getName() + "' requires a 'CloudRequestEngine' before it in the Pipeline. This engine will be unable to produce results until this is corrected.");
        }
        CloudRequestData requestData = (CloudRequestData)data.getFromElement((FlowElement)this.cloudRequestEngine);
        String json = "";
        json = requestData.getJsonResponse();
        JSONObject jsonObj = new JSONObject(json);
        JSONObject deviceObj = jsonObj.getJSONObject("device");
        TreeMap<String, Object> deviceMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        block16: for (AspectPropertyMetaData property : this.getProperties()) {
            String type;
            switch (type = property.getType().getSimpleName()) {
                case "List": {
                    deviceMap.put(property.getName(), this.getListAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
                case "JavaScript": {
                    deviceMap.put(property.getName(), this.getJavaScriptAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
                case "String": {
                    deviceMap.put(property.getName(), this.getStringAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
                case "boolean": {
                    deviceMap.put(property.getName(), this.getBooleanAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
                case "int": {
                    deviceMap.put(property.getName(), this.getIntegerAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
                case "double": {
                    deviceMap.put(property.getName(), this.getDoubleAspectPropertyValue(deviceObj, property));
                    continue block16;
                }
            }
            deviceMap.put(property.getName(), this.getStringAspectPropertyValue(deviceObj, property));
        }
        for (String key : deviceObj.keySet()) {
            String actualKey;
            if (!key.endsWith("nullreason") || deviceMap.containsKey(actualKey = key.replace("nullreason", ""))) continue;
            AspectPropertyValueDefault nullValue = new AspectPropertyValueDefault();
            nullValue.setNoValueMessage(deviceObj.optString(key, "Unknown"));
            deviceMap.put(actualKey, nullValue);
        }
        aspectData.populateFromMap(deviceMap);
    }

    protected void unmanagedResourcesCleanup() {
    }

    public void addPipeline(Pipeline pipeline) {
        if (this.cloudRequestEngine == null) {
            this.cloudRequestEngine = (CloudRequestEngine)pipeline.getElement(CloudRequestEngine.class);
            if (this.cloudRequestEngine != null && !this.loadAspectProperties(this.cloudRequestEngine)) {
                this.logger.error("Failed to load aspect properties");
            }
        }
        super.addPipeline(pipeline);
    }

    private boolean loadAspectProperties(CloudRequestEngine engine) {
        Map map = engine.getPublicProperties();
        if (map != null && map.size() > 0 && map.containsKey(this.getElementDataKey())) {
            this.aspectProperties = new ArrayList<AspectPropertyMetaData>();
            this.dataSourceTier = ((AccessiblePropertyMetaData.ProductMetaData)map.get((Object)this.getElementDataKey())).dataTier;
            for (AccessiblePropertyMetaData.PropertyMetaData item : ((AccessiblePropertyMetaData.ProductMetaData)map.get((Object)this.getElementDataKey())).properties) {
                AspectPropertyMetaDataDefault property = new AspectPropertyMetaDataDefault(item.name, (FlowElement)this, item.category, item.getPropertyType(), new ArrayList(), true);
                this.aspectProperties.add((AspectPropertyMetaData)property);
            }
            return true;
        }
        this.logger.error("Aspect properties could not be loaded for the Device Detection cloud engine", (Object)this);
        return false;
    }

    private AspectPropertyValue<Integer> getIntegerAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault intValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            intValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            intValue.setValue((Object)deviceObj.getInt(key));
        }
        return intValue;
    }

    private AspectPropertyValue<Double> getDoubleAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault doubleValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            doubleValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            doubleValue.setValue((Object)deviceObj.getDouble(key));
        }
        return doubleValue;
    }

    private AspectPropertyValue<Boolean> getBooleanAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault booleanValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            booleanValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            booleanValue.setValue((Object)deviceObj.getBoolean(key));
        }
        return booleanValue;
    }

    private AspectPropertyValue<List<String>> getListAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault listValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            listValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            JSONArray jsonArray = deviceObj.getJSONArray(key);
            ArrayList<String> strings = new ArrayList<String>(jsonArray.length());
            for (Object object : jsonArray.toList()) {
                strings.add(Objects.toString(object, null));
            }
            listValue.setValue(strings);
        }
        return listValue;
    }

    private AspectPropertyValue<JavaScript> getJavaScriptAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault jsValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            jsValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            jsValue.setValue((Object)new JavaScript(deviceObj.getString(key)));
        }
        return jsValue;
    }

    private AspectPropertyValue<String> getStringAspectPropertyValue(JSONObject deviceObj, AspectPropertyMetaData property) {
        String key = property.getName().toLowerCase();
        AspectPropertyValueDefault stringValue = new AspectPropertyValueDefault();
        if (deviceObj.isNull(key)) {
            stringValue.setNoValueMessage(this.getNoValueReason(deviceObj, key));
        } else {
            stringValue.setValue((Object)deviceObj.getString(key));
        }
        return stringValue;
    }

    private String getNoValueReason(JSONObject deviceObj, String key) {
        Object reason = this.tryToGet(deviceObj, key + "nullreason");
        return reason == null ? null : reason.toString();
    }

    private Object tryToGet(JSONObject jsonObj, String key) {
        if (jsonObj.has(key)) {
            return jsonObj.opt(key);
        }
        return null;
    }
}

