/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples;

import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngineBuilder;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Comparison
extends ProgramBase {
    private static final int defaultNumberOfThreads = 1;
    private static final int QUEUE_SIZE = 512;
    private static final float CACHE_MULTIPLIER = 0.25f;
    private static final String UNSUPPORTED_VALUE = "NOT AVAILABLE";
    private static final String CSV_INPUT_REGEX = "\\s\\|\\s";
    private static final char CSV_SEPARATER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_SINGLE_QUOTE = new String(new char[]{'\"'});
    private static final String CSV_DOUBLE_QUOTE = new String(new char[]{'\"', '\"'});
    private static final int PROGRESS_REPORT_INTERVAL = 5000;
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong elapsedNano = new AtomicLong();
    private final LinkedBlockingQueue<Result> queue = new LinkedBlockingQueue(512);
    private boolean addingComplete = false;
    private ComparisonProvider provider;

    private static void runComparison(ComparisonProvider provider, LinkedList<Request> requests, int numberOfThreads) throws IOException, InterruptedException {
        new Comparison().run(provider, requests, numberOfThreads);
    }

    static LinkedList<Request> readUserAgents(String userAgentFile) throws IOException {
        String line;
        LinkedList<Request> requests = new LinkedList<Request>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(userAgentFile));
        while ((line = bufferedReader.readLine()) != null) {
            String[] values = line.split(CSV_INPUT_REGEX);
            Request request = null;
            try {
                request = new Request(values[0], values.length > 1 ? Integer.parseInt(values[1]) : 4);
            }
            catch (NumberFormatException e) {
                request = new Request(line, 4);
            }
            requests.add(request);
        }
        bufferedReader.close();
        return requests;
    }

    private static void writeFirstString(BufferedWriter bufferedWriter, String value) throws IOException {
        Comparison.writeString(bufferedWriter, value, true);
    }

    private static void writeString(BufferedWriter bufferedWriter, String value) throws IOException {
        Comparison.writeString(bufferedWriter, value, false);
    }

    private static void writeString(BufferedWriter bufferedWriter, String value, boolean isFirst) throws IOException {
        if (!isFirst) {
            bufferedWriter.write(44);
        }
        bufferedWriter.write(34);
        if (value != null) {
            bufferedWriter.write(value.replace(CSV_SINGLE_QUOTE, CSV_DOUBLE_QUOTE));
        }
        bufferedWriter.write(34);
    }

    private static void writeBoolean(BufferedWriter bufferedWriter, boolean value) throws IOException {
        bufferedWriter.write(44);
        bufferedWriter.write(Boolean.toString(value));
    }

    private static void writeDouble(BufferedWriter bufferedWriter, double value) throws IOException {
        bufferedWriter.write(44);
        bufferedWriter.write(Double.toString(value));
    }

    private static void writeInteger(BufferedWriter bufferedWriter, int value) throws IOException {
        bufferedWriter.write(44);
        bufferedWriter.write(Integer.toString(value));
    }

    private static void writeResult(BufferedWriter bufferedWriter, Result result) throws IOException {
        try {
            result.setForWrite();
            for (Field field : Result.class.getDeclaredFields()) {
                if (field.getType() == String.class) {
                    Comparison.writeString(bufferedWriter, (String)field.get(result));
                    continue;
                }
                if (field.getType() == Integer.TYPE) {
                    Comparison.writeInteger(bufferedWriter, field.getInt(result));
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    Comparison.writeBoolean(bufferedWriter, field.getBoolean(result));
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    Comparison.writeDouble(bufferedWriter, field.getDouble(result));
                    continue;
                }
                if (field.getType() != Float.TYPE) continue;
                Comparison.writeDouble(bufferedWriter, field.getDouble(result));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(Comparison.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void writeHeaders(BufferedWriter bufferedWriter, ArrayList<String> providerNames) throws IOException {
        Comparison.writeFirstString(bufferedWriter, "User-Agent");
        for (String providerName : providerNames) {
            for (Field field : Result.class.getDeclaredFields()) {
                if (field.getType() != String.class && field.getType() != Integer.TYPE && field.getType() != Boolean.TYPE && field.getType() != Double.TYPE && field.getType() != Float.TYPE) continue;
                Comparison.writeString(bufferedWriter, providerName + "-" + field.getName());
            }
        }
        bufferedWriter.newLine();
    }

    private static void writeResults(LinkedList<Request> requests, ArrayList<String> providerNames, String outputFile) throws IOException {
        System.out.printf("Writing comparison CSV file: %s\r\n", outputFile);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
        Comparison.writeHeaders(bufferedWriter, providerNames);
        for (Request request : requests) {
            Comparison.writeFirstString(bufferedWriter, request.userAgentString);
            for (Result result : request.results) {
                Comparison.writeResult(bufferedWriter, result);
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runFiftyOneDegreesHashMemory(ArrayList<String> providerNames, LinkedList<Request> requests, int numberOfThreads, String dataFile) throws Exception {
        if (dataFile != null && new File(dataFile).exists()) {
            providerNames.add("51DHashTrie");
            System.out.printf("Processing 51Degrees Hash Trie File: %s\r\n", dataFile);
            long startTime = System.currentTimeMillis();
            FiftyOneDegreesHashMemoryProvider fodhtf = new FiftyOneDegreesHashMemoryProvider(dataFile);
            long endTime = System.currentTimeMillis();
            System.out.printf("Initialised 51Degrees Hash Trie file provider in %d ms\r\n", endTime - startTime);
            try {
                Comparison.runComparison(fodhtf, requests, numberOfThreads);
            }
            finally {
                fodhtf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWurfl(ArrayList<String> providerNames, LinkedList<Request> requests, int cacheSize, int numberOfThreads, String dataFile) throws IOException, InterruptedException {
        if (dataFile != null && new File(dataFile).exists()) {
            providerNames.add("WURFL");
            System.out.printf("Processing WURFL: %s\r\n", dataFile);
            long startTime = System.currentTimeMillis();
            WurflProvider wurfl = new WurflProvider(dataFile, cacheSize);
            long endTime = System.currentTimeMillis();
            System.out.printf("Initialised WURFL in %d ms\r\n", endTime - startTime);
            try {
                Comparison.runComparison(wurfl, requests, numberOfThreads);
            }
            finally {
                wurfl.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runDeviceAtlas(ArrayList<String> providerNames, LinkedList<Request> requests, int cacheSize, int numberOfThreads, String dataFile) throws IOException, InterruptedException {
        if (dataFile != null && new File(dataFile).exists()) {
            providerNames.add("DA");
            System.out.printf("Processing DeviceAtlas: %s\r\n", dataFile);
            long startTime = System.currentTimeMillis();
            DeviceAtlasProvider da = new DeviceAtlasProvider(dataFile, cacheSize);
            long endTime = System.currentTimeMillis();
            System.out.printf("Initialised DeviceAtlas in %d ms\r\n", endTime - startTime);
            try {
                Comparison.runComparison(da, requests, numberOfThreads);
            }
            finally {
                da.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBrowserCaps(ArrayList<String> providerNames, LinkedList<Request> requests, int cacheSize, int numberOfThreads) throws IOException, InterruptedException {
        providerNames.add("BC");
        System.out.println("Processing Browscap");
        try (Closeable bc = null;){
            long startTime = System.currentTimeMillis();
            bc = new BrowsCapProvider(cacheSize);
            long endTime = System.currentTimeMillis();
            System.out.printf("Initialised Browscap provider in %d ms\r\n", endTime - startTime);
            Comparison.runComparison((ComparisonProvider)bc, requests, numberOfThreads);
        }
    }

    private static void runComparisons(String userAgentsFile, String fiftyoneDegreesHashTrieFile, String wurflFile, String deviceAtlasFile, String csvOutputFile, int numberOfThreads) throws Exception {
        if (!new File(userAgentsFile).exists()) {
            throw new IllegalArgumentException(String.format("File %s does not exist", userAgentsFile));
        }
        ArrayList<String> providerNames = new ArrayList<String>();
        LinkedList<Request> requests = Comparison.readUserAgents(userAgentsFile);
        int cacheSize = (int)((float)requests.size() * 0.25f);
        Comparison.runBrowserCaps(providerNames, requests, cacheSize, numberOfThreads);
        Comparison.runFiftyOneDegreesHashMemory(providerNames, requests, numberOfThreads, fiftyoneDegreesHashTrieFile);
        Comparison.runWurfl(providerNames, requests, cacheSize, numberOfThreads, wurflFile);
        Comparison.runDeviceAtlas(providerNames, requests, cacheSize, numberOfThreads, deviceAtlasFile);
        Comparison.writeResults(requests, providerNames, csvOutputFile);
    }

    public static void main(String[] args) throws Exception {
        int numberOfThreads = 1;
        int existingFiles = 0;
        String hashFile = null;
        ArrayList<String> otherFiles = new ArrayList<String>();
        for (String arg : args) {
            try {
                numberOfThreads = Integer.parseInt(arg);
            }
            catch (NumberFormatException ex) {
                ++existingFiles;
                if (arg.contains("51Degrees")) {
                    if (!arg.endsWith(".hash")) continue;
                    hashFile = arg;
                    continue;
                }
                otherFiles.add(arg);
            }
        }
        if (hashFile == null) {
            hashFile = Comparison.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        }
        if (otherFiles.size() < 2) {
            throw new IllegalArgumentException("At least 2 valid files need to be provided");
        }
        Comparison.runComparisons((String)otherFiles.get(0), hashFile, null, null, (String)otherFiles.get(otherFiles.size() - 1), numberOfThreads);
    }

    public double getAverageDetectionTimePerThread() {
        return this.elapsedNano.doubleValue() / 1000000.0 / (double)this.getCount();
    }

    public int getCount() {
        return this.count.intValue();
    }

    public void run(ComparisonProvider provider, LinkedList<Request> requests, int numberOfThreads) throws IOException, InterruptedException {
        this.provider = provider;
        this.elapsedNano.set(0L);
        this.count.set(0);
        ResultIterator iterator = new ResultIterator(requests);
        System.out.printf("Starting processing %.0f requests from %d User-Agents\r\n", Float.valueOf(iterator.total), requests.size());
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            executor.execute(new ComparisonRunnable(this));
        }
        long next = System.currentTimeMillis() + 5000L;
        while (iterator.hasNext()) {
            this.queue.put(iterator.next());
            if (System.currentTimeMillis() <= next) continue;
            System.out.printf("%.2f%% complete\r\n", Float.valueOf(iterator.getPercentageComplete() * 100.0f));
            next += 5000L;
        }
        this.addingComplete = true;
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        System.out.printf("Average millseconds per detection per thread: %f \r\n", this.getAverageDetectionTimePerThread());
        System.out.printf("Concurrent threads: %d \r\n", numberOfThreads);
        System.out.printf("User-Agents processed: %d \r\n", this.getCount());
    }

    private static class ComparisonRunnable
    implements Runnable {
        private final Comparison cp;

        ComparisonRunnable(Comparison cp) throws IOException {
            this.cp = cp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object guard = new Object();
                Result result = (Result)this.cp.queue.poll(1L, TimeUnit.SECONDS);
                while (result != null || !this.cp.addingComplete) {
                    if (result != null) {
                        long start = System.nanoTime();
                        Object object = guard;
                        synchronized (object) {
                            this.cp.provider.calculateResult(result.request.userAgentString, result);
                        }
                        long detectionTime = System.nanoTime() - start;
                        result.totalDetectionTime.addAndGet(detectionTime);
                        this.cp.elapsedNano.addAndGet(detectionTime);
                        this.cp.count.incrementAndGet();
                    }
                    result = (Result)this.cp.queue.poll(1L, TimeUnit.SECONDS);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Comparison.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static class BrowsCapProvider
    implements ComparisonProvider {
        BrowsCapProvider(int cacheSize) throws Exception {
        }

        @Override
        public void calculateResult(String userAgent, Result result) throws Exception {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class FiftyOneDegreesHashMemoryProvider
    extends FiftyOneDegreesBaseProvider {
        FiftyOneDegreesHashMemoryProvider(String dataFile) throws Exception {
            super(((DeviceDetectionHashEngineBuilder)new DeviceDetectionHashEngineBuilder().setPerformanceProfile(Constants.PerformanceProfiles.HighPerformance).setUpdateMatchedUserAgent(false).setAllowUnmatched(true).setAutoUpdate(false)).build(dataFile, false));
            System.out.println("Created 51Degrees memory provider");
        }
    }

    static abstract class FiftyOneDegreesBaseProvider<T extends DeviceData>
    implements ComparisonProvider {
        private final ElementPropertyMetaData isMobile;
        private final ElementPropertyMetaData hardwareVendor;
        private final ElementPropertyMetaData hardwareModel;
        private final ElementPropertyMetaData browserName;
        private final ElementPropertyMetaData browserVersion;
        private final ElementPropertyMetaData deviceType;
        private Pipeline pipeline;
        private final OnPremiseAspectEngine<T, ?> engine;

        FiftyOneDegreesBaseProvider(OnPremiseAspectEngine<T, ?> engine) throws Exception {
            this.engine = engine;
            this.pipeline = ((PipelineBuilder)((PipelineBuilder)new PipelineBuilder().addFlowElement(engine)).setAutoCloseElements(true)).build();
            Map availablePropertes = (Map)this.pipeline.getElementAvailableProperties().get(engine.getElementDataKey());
            this.isMobile = (ElementPropertyMetaData)availablePropertes.get("ismobile");
            this.hardwareVendor = (ElementPropertyMetaData)availablePropertes.get("hardwarevendor");
            this.hardwareModel = (ElementPropertyMetaData)availablePropertes.get("hardwaremodel");
            this.browserName = (ElementPropertyMetaData)availablePropertes.get("browsername");
            this.browserVersion = (ElementPropertyMetaData)availablePropertes.get("browserversion");
            this.deviceType = (ElementPropertyMetaData)availablePropertes.get("devicetype");
            System.out.printf("51Degrees '%s %s' published '%s'\r\n", engine.getClass().getSimpleName(), engine.getDataSourceTier(), engine.getDataFileMetaData().getDataPublishedDateTime().toString());
        }

        @Override
        public void calculateResult(String userAgent, Result result) throws Exception {
            try (FlowData flowData = this.pipeline.createFlowData();){
                flowData.addEvidence("header.user-agent", (Object)userAgent).process();
                DeviceData device = (DeviceData)flowData.getFromElement(this.engine);
                result.isMobile = (Boolean)device.getIsMobile().getValue();
                result.browserName = this.browserName != null ? (String)device.getBrowserName().getValue() : Comparison.UNSUPPORTED_VALUE;
                result.browserVersion = this.browserVersion != null ? (String)device.getBrowserVersion().getValue() : Comparison.UNSUPPORTED_VALUE;
                result.hardwareVendor = this.hardwareVendor != null ? (String)device.getHardwareVendor().getValue() : Comparison.UNSUPPORTED_VALUE;
                result.hardwareModel = this.hardwareModel != null ? (String)device.getHardwareModel().getValue() : Comparison.UNSUPPORTED_VALUE;
                result.deviceType = this.deviceType != null ? (String)device.getDeviceType().getValue() : Comparison.UNSUPPORTED_VALUE;
                result.difference = (Integer)device.getDifference().getValue();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.pipeline.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ElementPropertyMetaData getIsMobile() {
            return this.isMobile;
        }
    }

    static class DeviceAtlasProvider
    implements ComparisonProvider {
        DeviceAtlasProvider(String dataFile, int cacheSize) {
        }

        @Override
        public void calculateResult(String userAgent, Result result) throws Exception {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class WurflProvider
    implements ComparisonProvider {
        WurflProvider(String dataFile, int cacheSize) {
        }

        @Override
        public void calculateResult(String userAgent, Result result) throws Exception {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class Request {
        final String userAgentString;
        final int frequency;
        final LinkedList<Result> results;

        Request(String userAgentString, int frequency) {
            this.userAgentString = userAgentString;
            this.frequency = frequency;
            this.results = new LinkedList();
        }
    }

    static class Result {
        final Request request;
        final AtomicLong totalDetectionTime = new AtomicLong(0L);
        double averageDetectionTimeMs;
        boolean isMobile;
        String hardwareVendor;
        String hardwareModel;
        String browserName;
        String browserVersion;
        String deviceType;
        int difference;
        int count;

        Result(Request request) {
            this.request = request;
        }

        void setForWrite() {
            this.averageDetectionTimeMs = (double)this.totalDetectionTime.get() / 1000000.0 / (double)this.count;
        }
    }

    static class ResultIterator
    implements Iterator<Result> {
        private final LinkedList<LinkedList<Result>> queue;
        private final float total;
        private float fetches;

        ResultIterator(LinkedList<Request> requests) {
            long localTotal = 0L;
            TreeMap map = new TreeMap();
            for (Request request : requests) {
                localTotal += (long)request.frequency;
            }
            this.total = localTotal;
            for (Request request : requests) {
                float weight = (float)request.frequency / (float)localTotal;
                Result result = new Result(request);
                request.results.add(result);
                if (!map.containsKey(Float.valueOf(weight))) {
                    map.put(Float.valueOf(weight), new LinkedList());
                }
                ((LinkedList)map.get(Float.valueOf(weight))).add(result);
            }
            this.queue = new LinkedList();
            for (Map.Entry entry : map.entrySet()) {
                this.queue.add((LinkedList<Result>)entry.getValue());
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Result next() {
            LinkedList<Result> current = this.queue.remove();
            Result result = current.remove();
            ++result.count;
            this.fetches += 1.0f;
            if (result.count < result.request.frequency) {
                current.addLast(result);
            }
            if (current.size() > 0) {
                this.queue.addLast(current);
            }
            return result;
        }

        @Override
        public void remove() {
        }

        float getPercentageComplete() {
            return this.fetches / this.total;
        }
    }

    static interface ComparisonProvider
    extends Closeable {
        public void calculateResult(String var1, Result var2) throws Exception;
    }
}

