/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExampleBase {
    private final boolean printOutput;

    public ExampleBase(boolean printOutput) {
        this.printOutput = printOutput;
    }

    protected static Iterable<String> getUserAgents(String userAgentsFile, int count) throws IOException {
        Path path = Paths.get(userAgentsFile, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(String.format("File '%s' not found", path));
        }
        return new UserAgentIterable(path, count);
    }

    protected static Iterable<String> getUserAgents(String userAgentsFile, int count, int randomness) throws IOException {
        Path path = Paths.get(userAgentsFile, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(String.format("File '%s' not found", path));
        }
        return new UserAgentIterable(path, count, randomness);
    }

    private static void addToMessage(StringBuilder message, String textToAdd, int depth) {
        for (int i = 0; i < depth; ++i) {
            message.append("   ");
        }
        message.append(textToAdd);
        message.append("\n");
    }

    protected void print(String string) {
        if (this.printOutput) {
            System.out.print(string);
        }
    }

    protected void println(String string) {
        if (this.printOutput) {
            System.out.println(string);
        }
    }

    protected void println() {
        if (this.printOutput) {
            System.out.println();
        }
    }

    protected void printf(String format, Object ... args) {
        if (this.printOutput) {
            System.out.printf(format, args);
        }
    }

    protected Iterable<String> report(Iterator<String> input, int count, int maxDistinctUAs, int marks) {
        return new ReportIterable(input, count, maxDistinctUAs, marks);
    }

    protected void outputException(Throwable ex, int depth) {
        StringBuilder message = new StringBuilder();
        ExampleBase.addToMessage(message, ex.getClass().getSimpleName() + " - " + ex.getMessage(), depth);
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        ExampleBase.addToMessage(message, writer.toString(), depth);
        this.println(message.toString());
        if (ex.getCause() != null) {
            this.outputException(ex.getCause(), depth++);
        }
    }

    protected class ReportIterable
    implements Iterable<String> {
        private final Iterator<String> userAgents;
        private final int count;
        private final double increment;
        private final int maxDistinctUAs;
        int current = 0;

        public ReportIterable(Iterator<String> input, int count, int maxDistinctUAs, int marks) {
            this.userAgents = input;
            this.count = count;
            this.increment = count / marks;
            this.maxDistinctUAs = Math.min(maxDistinctUAs, count);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return ReportIterable.this.current < ReportIterable.this.count;
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        if ((double)ReportIterable.this.current % ReportIterable.this.increment == 0.0) {
                            ExampleBase.this.print("=");
                        }
                        ++ReportIterable.this.current;
                        return (String)ReportIterable.this.userAgents.next();
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    static class UserAgentIterable
    implements Iterable<String> {
        private final Path userAgents;
        private final int count;
        private final int randomness;

        public UserAgentIterable(Path userAgents, int count) {
            this(userAgents, count, 0);
        }

        public UserAgentIterable(Path userAgents, int count, int randomness) {
            this.userAgents = userAgents;
            this.count = count;
            this.randomness = randomness;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                return new UserAgentIterator(this.userAgents, this.count, this.randomness);
            }
            catch (IOException ex) {
                Logger.getLogger(ExampleBase.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        class UserAgentIterator
        implements Iterator<String> {
            private final Path userAgents;
            private final int count;
            private final int randomness;
            private final Random random = new Random();
            private int returned = 0;
            private FileReader reader = null;
            private BufferedReader buffer = null;

            public UserAgentIterator(Path userAgents, int count, int randomness) throws FileNotFoundException, IOException {
                this.userAgents = userAgents;
                this.count = count;
                this.randomness = randomness;
                this.createReader();
            }

            @Override
            public boolean hasNext() {
                return this.returned < this.count;
            }

            @Override
            public String next() {
                String userAgent = null;
                if (this.randomness > 0) {
                    int skip = this.random.nextInt(this.randomness);
                    for (int i = 0; i < skip; ++i) {
                        try {
                            this.nextLine();
                            continue;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ExampleBase.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                try {
                    userAgent = this.nextLine();
                    ++this.returned;
                }
                catch (IOException ex) {
                    Logger.getLogger(ExampleBase.class.getName()).log(Level.SEVERE, null, ex);
                }
                return userAgent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private String nextLine() throws IOException {
                String line = this.buffer.readLine();
                if (line == null) {
                    this.createReader();
                    line = this.buffer.readLine();
                }
                return line;
            }

            private void createReader() throws FileNotFoundException, IOException {
                if (this.buffer != null) {
                    this.buffer.close();
                }
                if (this.reader != null) {
                    this.reader.close();
                }
                this.reader = new FileReader(this.userAgents.toFile());
                this.buffer = new BufferedReader(this.reader);
            }
        }
    }
}

