/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples;

import java.io.File;
import java.io.FilenameFilter;

public class ProgramBase {
    protected static File getDefaultFilePath(String searchPattern) {
        return ProgramBase.getDefaultFilePath(new SearchFilter(searchPattern));
    }

    protected static File getDefaultFilePath(FilenameFilter searchFilter) {
        File last = null;
        for (File directory = new File(System.getProperty("user.dir")); directory != null; directory = directory.getParentFile()) {
            File matchedFile = null;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory() || last != null && file.equals(last) || (matchedFile = ProgramBase.find(file, searchFilter)) == null) continue;
                return matchedFile;
            }
            last = directory;
        }
        return null;
    }

    static File find(File directory, FilenameFilter searchFilter) {
        File result = null;
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                result = ProgramBase.find(file, searchFilter);
                if (result == null) continue;
                return result;
            }
            if (!searchFilter.accept(file, file.getName())) continue;
            return file;
        }
        return null;
    }

    private static class SearchFilter
    implements FilenameFilter {
        private final String searchPattern;

        public SearchFilter(String searchPattern) {
            this.searchPattern = searchPattern;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.searchPattern);
        }
    }
}

