/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.cloud;

import fiftyone.devicedetection.cloud.flowelements.DeviceDetectionCloudEngine;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.configuration.ElementOptions;
import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.fiftyone.flowelements.FiftyOnePipelineBuilder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;

public class ConfigureFromFile
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String resourceKey = args.length > 0 ? args[0] : "!!YOUR_RESOURCE_KEY!!";
        new Example(true).run(resourceKey);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String resourceKey) throws Exception {
            File file = new File(this.getClass().getClassLoader().getResource("cloud.xml").getFile());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PipelineOptions.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PipelineOptions options = (PipelineOptions)unmarshaller.unmarshal(file);
            if (((ElementOptions)options.elements.get((int)0)).buildParameters.get("ResourceKey").toString().startsWith("!!") && resourceKey.startsWith("!!")) {
                this.println("You need to create a resource key at https://configure.51degrees.com and paste it into this example.");
                this.println("Make sure to include the 'IsMobile' property as it is used by this example.");
                return;
            }
            if (!resourceKey.startsWith("!!")) {
                ((ElementOptions)options.elements.get((int)0)).buildParameters.put("ResourceKey", resourceKey);
            }
            try (Pipeline pipeline = new FiftyOnePipelineBuilder().buildFromConfiguration(options);){
                DeviceDetectionCloudEngine engine = (DeviceDetectionCloudEngine)pipeline.getElement(DeviceDetectionCloudEngine.class);
                for (AspectPropertyMetaData property : engine.getProperties()) {
                    this.println(property.getName());
                }
                try (FlowData data = pipeline.createFlowData();){
                    data.addEvidence("header.user-agent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53").process();
                    this.println("IsMobile: " + ((DeviceData)data.get(DeviceData.class)).getIsMobile());
                    this.println(((Double)((DeviceData)data.get(DeviceData.class)).getBackCameraMegaPixels().getValue()).toString());
                }
            }
        }
    }
}

