/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.cloud;

import fiftyone.devicedetection.DeviceDetectionCloudPipelineBuilder;
import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyValue;

public class GettingStarted
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String resourceKey = args.length > 0 ? args[0] : "!!YOUR_RESOURCE_KEY!!";
        new Example(true).run(resourceKey);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String resourceKey) throws Exception {
            if (resourceKey.startsWith("!!")) {
                this.println("You need to create a resource key at https://configure.51degrees.com and paste it into this example.");
                this.println("Make sure to include the 'IsMobile' property as it is used by this example.");
            } else {
                this.println("Constructing pipeline with cloud engine with resource key: " + resourceKey);
                Pipeline pipeline = ((DeviceDetectionCloudPipelineBuilder)((DeviceDetectionCloudPipelineBuilder)new DeviceDetectionPipelineBuilder().useCloud(resourceKey).useLazyLoading(1000L)).setAutoCloseElements(true)).build();
                try (FlowData data = pipeline.createFlowData();){
                    data.addEvidence("header.user-agent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53").process();
                    AspectPropertyValue isMobile = ((DeviceData)data.get(DeviceData.class)).getIsMobile();
                    if (isMobile.hasValue()) {
                        this.println("IsMobile: " + isMobile.getValue());
                    } else {
                        this.println("IsMobile: " + isMobile.getNoValueMessage());
                    }
                }
            }
        }
    }
}

