/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.cloud;

import fiftyone.devicedetection.cloud.data.MultiDeviceDataCloud;
import fiftyone.devicedetection.cloud.flowelements.HardwareProfileCloudEngine;
import fiftyone.devicedetection.cloud.flowelements.HardwareProfileCloudEngineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngineBuilder;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.util.StringManipulation;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class TacLookup
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String resourceKey = args.length > 0 ? args[0] : "!!YOUR_RESOURCE_KEY!!";
        new Example(true).run(resourceKey);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private static final String TAC = "35925406";
        private static final String TAC2 = "86386802";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String resourceKey) throws Exception {
            if (resourceKey.startsWith("!!")) {
                this.println("You need to create a resource key at https://configure.51degrees.com and paste it into this example.");
                this.println("Make sure to include the 'HardwareVendor', 'HardwareName' and 'HardwareModel' properties as they are used by this example.");
            } else {
                this.println("This example shows the details of devices associated with a given 'Type Allocation Code' or 'TAC'.");
                this.println("More background information on TACs can be found through various online sources such as Wikipedia: https://en.wikipedia.org/wiki/Type_Allocation_Code");
                this.println("----------------------------------------");
                ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
                HttpClientDefault httpClient = new HttpClientDefault();
                try (CloudRequestEngine cloudEngine = new CloudRequestEngineBuilder(loggerFactory, (HttpClient)httpClient).setResourceKey(resourceKey).build();
                     HardwareProfileCloudEngine hardwareProfileEngine = new HardwareProfileCloudEngineBuilder(loggerFactory).build();
                     Pipeline pipeline = ((PipelineBuilder)((PipelineBuilder)new PipelineBuilder(loggerFactory).addFlowElement((FlowElement)cloudEngine)).addFlowElement((FlowElement)hardwareProfileEngine)).build();){
                    this.analyseTac(TAC, pipeline);
                    this.analyseTac(TAC2, pipeline);
                }
            }
        }

        void analyseTac(String tac, Pipeline pipeline) throws Exception {
            try (FlowData data = pipeline.createFlowData();){
                data.addEvidence("query.tac", (Object)tac);
                data.process();
                MultiDeviceDataCloud result = (MultiDeviceDataCloud)data.get(MultiDeviceDataCloud.class);
                this.printf("Which devices are associated with the TAC '%s'?\n", tac);
                for (DeviceData device : result.getProfiles()) {
                    AspectPropertyValue vendor = device.getHardwareVendor();
                    AspectPropertyValue name = device.getHardwareName();
                    AspectPropertyValue model = device.getHardwareModel();
                    if (vendor.hasValue() && model.hasValue() && name.hasValue()) {
                        this.println("\t" + (String)vendor.getValue() + " " + StringManipulation.stringJoin((List)((List)name.getValue()), (String)",") + " (" + (String)model.getValue() + ")");
                        continue;
                    }
                    this.println(vendor.getNoValueMessage());
                }
            }
        }
    }
}

