/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Benchmark
extends ProgramBase {
    private static final int defaultNumberOfThreads = Runtime.getRuntime().availableProcessors();
    private static final int QUEUE_SIZE = 512;

    protected static void runBenchmarks(String deviceDataFile, String userAgentFile, int numberOfThreads) throws Exception {
        Example example = new Example(true);
        System.out.printf("Benchmarking in memory dataset: %s\r\n", deviceDataFile);
        byte[] fileContent = Files.readAllBytes(new File(deviceDataFile).toPath());
        try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(fileContent).setAutoUpdate(false).setShareUsage(false).setConcurrency(numberOfThreads).build();){
            example.run(pipeline, userAgentFile, numberOfThreads);
        }
        System.out.printf("Benchmarking LowMemory dataset: %s\r\n", deviceDataFile);
        pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(deviceDataFile, false).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).setAutoUpdate(false).setShareUsage(false).setConcurrency(numberOfThreads).build();
        var6_6 = null;
        try {
            example.run(pipeline, userAgentFile, numberOfThreads);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (pipeline != null) {
                if (var6_6 != null) {
                    try {
                        pipeline.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    pipeline.close();
                }
            }
        }
        System.out.printf("Benchmarking HighPerformance dataset: %s\r\n", deviceDataFile);
        pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(deviceDataFile, false).setPerformanceProfile(Constants.PerformanceProfiles.HighPerformance).setAutoUpdate(false).setShareUsage(false).setConcurrency(numberOfThreads).build();
        var6_6 = null;
        try {
            example.run(pipeline, userAgentFile, numberOfThreads);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (pipeline != null) {
                if (var6_6 != null) {
                    try {
                        pipeline.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    pipeline.close();
                }
            }
        }
        System.out.printf("Benchmarking Balanced dataset: %s\r\n", deviceDataFile);
        pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(deviceDataFile, false).setPerformanceProfile(Constants.PerformanceProfiles.Balanced).setAutoUpdate(false).setShareUsage(false).setConcurrency(numberOfThreads).build();
        var6_6 = null;
        try {
            example.run(pipeline, userAgentFile, numberOfThreads);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (pipeline != null) {
                if (var6_6 != null) {
                    try {
                        pipeline.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    pipeline.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int numberOfThreads = defaultNumberOfThreads;
        String dataFile = null;
        ArrayList<String> otherFiles = new ArrayList<String>();
        for (String arg : args) {
            try {
                numberOfThreads = Integer.parseInt(arg);
            }
            catch (NumberFormatException ex) {
                if (arg.contains("51Degrees") && arg.endsWith(".trie")) {
                    dataFile = arg;
                    continue;
                }
                otherFiles.add(arg);
            }
        }
        if (dataFile == null) {
            dataFile = Benchmark.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        }
        Benchmark.runBenchmarks(dataFile, otherFiles.size() > 0 ? (String)otherFiles.get(0) : Benchmark.getDefaultFilePath("20000 User Agents.csv").getAbsolutePath(), numberOfThreads);
    }

    static class Example
    extends ExampleBase {
        private final AtomicInteger count = new AtomicInteger();
        private final AtomicLong elapsedNano = new AtomicLong();
        private int checkSum;
        private boolean addingComplete = false;
        private LinkedBlockingQueue<String> queue;
        private Pipeline pipeline;

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public double getAverageDetectionTimePerThread() {
            return this.elapsedNano.doubleValue() / 1000000.0 / (double)this.getCount();
        }

        public int getCount() {
            return this.count.intValue();
        }

        void run(Pipeline pipeline, String userAgentFile, int numberOfThreads) throws Exception {
            try (FlowData f = pipeline.createFlowData();){
                f.addEvidence("header.user-agent", (Object)"test");
                f.process();
                DeviceData d = (DeviceData)f.get(DeviceData.class);
                d.getIsMobile();
            }
            if (!new File(userAgentFile).exists()) {
                throw new IllegalArgumentException(String.format("File '%s' does not exist.", userAgentFile));
            }
            this.queue = new LinkedBlockingQueue(512);
            this.pipeline = pipeline;
            this.elapsedNano.set(0L);
            this.count.set(0);
            this.checkSum = 0;
            ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
            for (int i = 0; i < numberOfThreads; ++i) {
                executor.execute(new BenchmarkRunnable(this));
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(userAgentFile));){
                String userAgentString;
                int userAgentsRead = 0;
                while ((userAgentString = bufferedReader.readLine()) != null) {
                    this.queue.put(userAgentString);
                    if (++userAgentsRead % 50000 != 0) continue;
                    this.print("+");
                }
                this.print("\r\n");
                this.addingComplete = true;
                executor.shutdown();
                while (!executor.isTerminated()) {
                }
            }
            this.println("");
            this.printf("Average millseconds per detection per thread: %f \r\n", this.getAverageDetectionTimePerThread());
            this.printf("Concurrent threads: %d \r\n", numberOfThreads);
            this.printf("User-Agents processed: %d \r\n", this.getCount());
            this.printf("Checksum: %d \r\n", this.checkSum);
        }
    }

    private static class BenchmarkRunnable
    implements Runnable {
        private final Example bm;

        BenchmarkRunnable(Example bm) {
            this.bm = bm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int workerCheckSum = 0;
                String userAgentString = (String)this.bm.queue.poll(1L, TimeUnit.SECONDS);
                while (userAgentString != null || !this.bm.addingComplete) {
                    if (userAgentString != null) {
                        long start = System.nanoTime();
                        try (FlowData flowData = this.bm.pipeline.createFlowData();){
                            flowData.addEvidence("header.user-agent", (Object)userAgentString).process();
                            this.bm.elapsedNano.addAndGet(System.nanoTime() - start);
                            DeviceData device = (DeviceData)flowData.get(DeviceData.class);
                            if (device != null) {
                                for (Object value : device.asKeyMap().values()) {
                                    if (value == null) continue;
                                    workerCheckSum += value.hashCode();
                                }
                            }
                            this.bm.count.incrementAndGet();
                        }
                        catch (Exception e) {
                            Logger.getLogger(Benchmark.class.getName()).log(Level.SEVERE, null, e);
                        }
                    }
                    userAgentString = (String)this.bm.queue.poll(1L, TimeUnit.SECONDS);
                }
                Example example = this.bm;
                synchronized (example) {
                    Example example2 = this.bm;
                    example2.checkSum = example2.checkSum + workerCheckSum;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Benchmark.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

