/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.fiftyone.flowelements.FiftyOnePipelineBuilder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;

public class ConfigureFromFile
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        new Example(true).run();
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run() throws Exception {
            File file = new File(this.getClass().getClassLoader().getResource("hash.xml").getFile());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PipelineOptions.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PipelineOptions options = (PipelineOptions)unmarshaller.unmarshal(file);
            try (Pipeline pipeline = new FiftyOnePipelineBuilder().buildFromConfiguration(options);
                 FlowData data = pipeline.createFlowData();){
                data.addEvidence("header.user-agent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53").process();
                AspectPropertyValue isMobile = ((DeviceData)data.get(DeviceData.class)).getIsMobile();
                if (isMobile.hasValue()) {
                    this.println("IsMobile: " + isMobile.getValue());
                } else {
                    this.println(isMobile.getNoValueMessage());
                }
            }
        }
    }
}

