/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.data.AspectPropertyValue;

public class GettingStarted
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : GettingStarted.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        new Example(true).run(dataFile);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String dataFile) throws Exception {
            this.println("Constructing pipeline with engine from file " + dataFile);
            try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(dataFile, false).setAutoUpdate(false).setShareUsage(false).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).build();
                 FlowData data = pipeline.createFlowData();){
                data.addEvidence("header.user-agent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 7_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D167 Safari/9537.53").process();
                AspectPropertyValue isMobile = ((DeviceData)data.get(DeviceData.class)).getIsMobile();
                if (isMobile.hasValue()) {
                    this.println("IsMobile: " + isMobile.getValue());
                } else {
                    this.println(isMobile.getNoValueMessage());
                }
            }
        }
    }
}

