/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.hash.engine.onpremise.data.DeviceDataHash;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import java.util.List;
import java.util.Map;

public class MatchMetrics
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : MatchMetrics.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        new Example(true).run(dataFile);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Mobile Safari/537.36";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String dataFile) throws Exception {
            this.println("Constructing pipeline with engine from file " + dataFile);
            try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(dataFile, false).setAutoUpdate(false).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).setShareUsage(false).setProperty("IsMobile").setProperty("HardwareName").setUsePredictiveGraph(true).setUsePerformanceGraph(false).build();
                 FlowData data = pipeline.createFlowData();){
                data.addEvidence("header.user-agent", (Object)"Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Mobile Safari/537.36").process();
                DeviceDataHash device = (DeviceDataHash)data.get(DeviceDataHash.class);
                this.println("User-Agent:         Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Mobile Safari/537.36");
                this.println("Matched User-Agent: " + (String)((List)device.getUserAgents().getValue()).get(0));
                this.println("Id: " + (String)device.getDeviceId().getValue());
                this.println("Difference: " + device.getDifference().getValue());
                this.println("Drift: " + device.getDrift().getValue());
                this.println("Iterations: " + device.getIterations().getValue());
                this.println("Method: " + (String)device.getMethod().getValue());
                Map entries = device.asKeyMap();
                for (Map.Entry entry : entries.entrySet()) {
                    this.println((String)entry.getKey() + ": " + entry.getValue());
                }
            }
        }
    }
}

