/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngine;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngineBuilder;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.fiftyone.data.FiftyOneAspectPropertyMetaData;
import fiftyone.pipeline.engines.fiftyone.data.ValueMetaData;

public class MetaData
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : MetaData.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        new Example(true).run(dataFile);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        public Example(boolean printOutput) {
            super(printOutput);
        }

        private String truncateToNl(String s) {
            int i = s.indexOf(10, 3);
            if (i == -1) {
                return s;
            }
            return s.substring(0, i + 2) + " ...";
        }

        public void run(String dataFile) throws Exception {
            this.println("Constructing pipeline with engine from file " + dataFile);
            try (DeviceDetectionHashEngine engine = (DeviceDetectionHashEngine)((DeviceDetectionHashEngineBuilder)new DeviceDetectionHashEngineBuilder().setAutoUpdate(false)).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).build(dataFile, false);){
                for (FiftyOneAspectPropertyMetaData property : engine.getProperties()) {
                    this.printf("%s (%s) - %s%n", property.getName(), property.getType().getSimpleName(), property.getDescription());
                    if (property.getCategory() == "Device Metrics") continue;
                    StringBuilder values = new StringBuilder("Possible values: ");
                    int numValues = 0;
                    for (ValueMetaData value : property.getValues()) {
                        if (numValues <= 20) {
                            values.append(this.truncateToNl(value.getName()));
                            if (!value.getDescription().isEmpty()) {
                                values.append(value.getDescription());
                            }
                            values.append(",");
                        }
                        ++numValues;
                    }
                    if (numValues > 20) {
                        values.append(" + " + (numValues - 20) + " more ...");
                    }
                    this.println(values.toString());
                }
            }
        }
    }
}

