/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;

public class OfflineProcessing
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : OfflineProcessing.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        new Example(true).run(dataFile, OfflineProcessing.getDefaultFilePath("20000 User Agents.csv").getAbsolutePath(), "batch-processing-example-results.csv");
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        public static final String outputFilePath = "batch-processing-example-results.csv";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String dataFile, String inputFile, String outputFile) throws Exception {
            this.println("Constructing pipeline with engine from file " + dataFile);
            try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(dataFile, false).setAutoUpdate(false).setShareUsage(false).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).build();){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(inputFile));
                     FileWriter fileWriter = new FileWriter(outputFile);){
                    for (int i = 0; i < 20; ++i) {
                        String userAgentString = bufferedReader.readLine();
                        try (FlowData flowData = pipeline.createFlowData();){
                            flowData.addEvidence("header.user-agent", (Object)userAgentString).process();
                            DeviceData device = (DeviceData)flowData.get(DeviceData.class);
                            fileWriter.write(userAgentString + "," + device.getIsMobile() + "," + device.getPlatformName() + "," + device.getPlatformVersion() + "\n");
                            continue;
                        }
                    }
                }
                this.println("Output written to " + outputFile);
            }
        }
    }
}

