/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class Performance
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : Performance.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        String uaFile = args.length > 1 ? args[1] : Performance.getDefaultFilePath("20000 User Agents.csv").getAbsolutePath();
        new Example(true).run(dataFile, uaFile, 10000);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private String uaFile;
        private int count;
        private Pipeline pipeline;
        private AtomicInteger isMobileTrue;
        private AtomicInteger isMobileFalse;
        private AtomicInteger isMobileUnknown;
        private final int maxDistinctUAs = 10000;
        private final int threadCount = 4;

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String dataFile, String uaFile, int count) throws Exception {
            this.println("Constructing pipeline with engine from file " + dataFile);
            try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(dataFile, false).setAutoUpdate(false).setShareUsage(false).setPerformanceProfile(Constants.PerformanceProfiles.MaxPerformance).setUsePredictiveGraph(false).setUsePerformanceGraph(true).setConcurrency(4).build();){
                this.run(uaFile, count, pipeline);
            }
        }

        private void run(String uaFile, int count, Pipeline pipeline) throws Exception {
            this.uaFile = uaFile;
            this.count = count;
            this.pipeline = pipeline;
            this.println("Processing " + count + " User-Agents from " + uaFile);
            this.println("The " + count + " process calls will use a maximum of " + 10000 + " distinct User-Agents");
            this.println("Calibrating");
            long calibrationTime = this.runThreads(true);
            this.println();
            this.println("Processing");
            long time = this.runThreads(false);
            double detectionsPerSecond = (double)(count * 4) / ((double)(time - calibrationTime) / 1000.0);
            this.println();
            this.printf("Average %.2f detections per second using %d threads (%2f per thread)\n", detectionsPerSecond, 4, detectionsPerSecond / 4.0);
            this.printf("%4f ms per User-Agent effective (%4f actual)\n", 1000.0 / detectionsPerSecond, 4000.0 / detectionsPerSecond);
            this.println("IsMobile = True  : " + this.isMobileTrue.get());
            this.println("IsMobile = False : " + this.isMobileFalse.get());
            this.println("IsMobile = Unknown : " + this.isMobileUnknown.get());
        }

        private long runThreads(boolean calibration) throws IOException, InterruptedException, ExecutionException {
            this.isMobileTrue = new AtomicInteger(0);
            this.isMobileFalse = new AtomicInteger(0);
            this.isMobileUnknown = new AtomicInteger(0);
            ArrayList<PerformanceCallable> callables = new ArrayList<PerformanceCallable>();
            for (int i = 0; i < 4; ++i) {
                callables.add(new PerformanceCallable(new ExampleBase.ReportIterable(Example.getUserAgents(this.uaFile, this.count).iterator(), this.count, 10000, 10), this.pipeline, this.isMobileTrue, this.isMobileFalse, this.isMobileUnknown, calibration));
            }
            ExecutorService service = Executors.newFixedThreadPool(4);
            long start = System.currentTimeMillis();
            List results = service.invokeAll(callables);
            for (Future result : results) {
                result.get();
            }
            service.shutdown();
            return System.currentTimeMillis() - start;
        }

        private static class PerformanceCallable
        implements Callable<Void> {
            private final Iterable<String> userAgents;
            private final Pipeline pipeline;
            final AtomicInteger isMobileTrue;
            final AtomicInteger isMobileFalse;
            final AtomicInteger isMobileUnknown;
            private final boolean calibration;

            public PerformanceCallable(Iterable<String> userAgents, Pipeline pipeline, AtomicInteger isMobileTrue, AtomicInteger isMobileFalse, AtomicInteger isMobileUnknown, boolean calibration) {
                this.userAgents = userAgents;
                this.pipeline = pipeline;
                this.isMobileTrue = isMobileTrue;
                this.isMobileFalse = isMobileFalse;
                this.isMobileUnknown = isMobileUnknown;
                this.calibration = calibration;
            }

            @Override
            public Void call() throws Exception {
                for (String userAgent : this.userAgents) {
                    if (this.calibration) {
                        this.isMobileFalse.incrementAndGet();
                        continue;
                    }
                    FlowData data = this.pipeline.createFlowData();
                    Throwable throwable = null;
                    try {
                        data.addEvidence("header.User-Agent", (Object)userAgent).process();
                        DeviceData device = (DeviceData)data.get(DeviceData.class);
                        AspectPropertyValue isMobile = device.getIsMobile();
                        if (isMobile.hasValue()) {
                            if (((Boolean)isMobile.getValue()).booleanValue()) {
                                this.isMobileTrue.incrementAndGet();
                                continue;
                            }
                            this.isMobileFalse.incrementAndGet();
                            continue;
                        }
                        this.isMobileUnknown.incrementAndGet();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (data == null) continue;
                        if (throwable != null) {
                            try {
                                data.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        data.close();
                    }
                }
                return null;
            }
        }
    }
}

