/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.shared.DeviceData;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.data.AspectPropertyValue;

public class UserAgentClientHints
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String dataFile = args.length > 0 ? args[0] : UserAgentClientHints.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        new Example(true).run(dataFile);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        private final String mobileUserAgent = "Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G960U) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36";
        private final String secchua = "\"Google Chrome\";v=\"89\", \"Chromium\";v=\"89\", \";Not A Brand\";v=\"99\"";

        public Example(boolean printOutput) {
            super(printOutput);
        }

        public void run(String dataFile) throws Exception {
            System.out.printf("Using data file at '%s'\n", dataFile);
            System.out.println("---------------------------------------");
            System.out.println("This example demonstrates detection using user-agent client hints.");
            System.out.println("The sec-ch-ua value can be used to determine the browser of the connecting device, but not other components such as the hardware.");
            System.out.println("We show this by first performing detection with sec-ch-ua only.");
            System.out.println("We then repeat with the user-agent header only.");
            System.out.println("Finally, we use both sec-ch-ua and user-agent. Note that sec-ch-ua takes priority over the user-agent for detection of the browser.");
            System.out.println("---------------------------------------");
            try (Pipeline pipeline = new DeviceDetectionPipelineBuilder().useOnPremise(dataFile, false).setAutoUpdate(false).setShareUsage(false).setPerformanceProfile(Constants.PerformanceProfiles.LowMemory).build();){
                this.analyseClientHints(pipeline, false, true);
                System.out.println();
                this.analyseClientHints(pipeline, true, false);
                System.out.println();
                this.analyseClientHints(pipeline, true, true);
            }
        }

        private void analyseClientHints(Pipeline pipeline, boolean setUserAgent, boolean setSecChUa) throws Exception {
            try (FlowData data = pipeline.createFlowData();){
                if (setSecChUa) {
                    data.addEvidence("query.sec-ch-ua", (Object)"\"Google Chrome\";v=\"89\", \"Chromium\";v=\"89\", \";Not A Brand\";v=\"99\"");
                }
                if (setUserAgent) {
                    data.addEvidence("query.user-agent", (Object)"Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G960U) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36");
                }
                data.process();
                DeviceData device = (DeviceData)data.get(DeviceData.class);
                AspectPropertyValue browserName = device.getBrowserName();
                AspectPropertyValue browserVersion = device.getBrowserVersion();
                AspectPropertyValue isMobile = device.getIsMobile();
                String displayCh = setSecChUa ? "\"Google Chrome\";v=\"89\", \"Chromium\";v=\"89\", \";Not A Brand\";v=\"99\"" : "NOT_SET";
                System.out.printf("Sec-CH-UA = '%s'\n", displayCh);
                String ua = setUserAgent ? "Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G960U) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36" : "NOT_SET";
                System.out.printf("User-Agent = '%s'\n", ua);
                if (browserName.hasValue() && browserVersion.hasValue()) {
                    System.out.printf("\tBrowser = %s %s\n", browserName.getValue(), browserVersion.getValue());
                } else if (browserName.hasValue()) {
                    System.out.printf("\tBrowser = %s (version unknown)\n", browserName.getValue());
                } else {
                    System.out.printf("\tBrowser = %s\n", browserName.getNoValueMessage());
                }
                if (isMobile.hasValue()) {
                    System.out.printf("\tIsMobile = %b\n", isMobile.getValue());
                } else {
                    System.out.printf("\tIsMobile = %s\n", isMobile.getNoValueMessage());
                }
            }
        }
    }
}

