/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash.automaticupdates;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngine;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.DataUpdateServiceDefault;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.engines.services.OnUpdateComplete;
import java.util.Date;
import org.slf4j.LoggerFactory;

public class DataFileSystemWatcher
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        String licenseKey;
        String dataFile = args.length > 0 ? args[0] : DataFileSystemWatcher.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        String string = licenseKey = args.length > 1 ? args[1] : "!!Your license key!!";
        if (licenseKey.startsWith("!!")) {
            System.out.println("You need a license key to run this example, you can obtain one by subscribing to a 51Degrees bundle: https://51degrees.com/pricing");
            System.in.read();
            return;
        }
        new Example(true).run(dataFile, licenseKey);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        static Pipeline pipeline;

        public Example(boolean printOutput) {
            super(printOutput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String dataFile, String licenseKey) throws Exception {
            this.println("Using data file at " + dataFile);
            HttpClientDefault httpClient = new HttpClientDefault();
            try (DataUpdateServiceDefault dataUpdateService = new DataUpdateServiceDefault(LoggerFactory.getLogger((String)DataUpdateServiceDefault.class.getName()), (HttpClient)httpClient);){
                dataUpdateService.onUpdateComplete((OnUpdateComplete)new GetAutoUpdateStatus());
                pipeline = new DeviceDetectionPipelineBuilder(LoggerFactory.getILoggerFactory(), (HttpClient)httpClient, (DataUpdateService)dataUpdateService).useOnPremise(dataFile, true).setDataUpdateLicenseKey(licenseKey).setAutoUpdate(true).setDataFileSystemWatcher(true).setUpdatePollingInterval(30).setUpdateRandomisationMax(10).setDataUpdateOnStartup(false).build();
                Date publishedDate = ((DeviceDetectionHashEngine)pipeline.getElement(DeviceDetectionHashEngine.class)).getDataFilePublishedDate();
                this.println("Data file published date: " + publishedDate);
                this.println("The pipeline has now been set up to watch for changes to the data file at the path shown above.");
                this.println("Copy a new data file over the existing one to trigger this process.");
                this.println("You can obtain a new file from https://51degrees.com/developers/downloads/enhanced-device-data?licenceKey=" + licenseKey);
                this.println("Press a key to end the program.");
                System.in.read();
            }
        }

        public static class GetAutoUpdateStatus
        implements OnUpdateComplete {
            public void call(Object o, DataUpdateService.DataUpdateCompleteArgs duca) {
                if (pipeline != null) {
                    Date publishedDate = ((DeviceDetectionHashEngine)pipeline.getElement(DeviceDetectionHashEngine.class)).getDataFilePublishedDate();
                    System.out.println("Data file published date: " + publishedDate.toString());
                }
                System.out.println("Update completed. Status " + duca.getStatus());
            }
        }
    }
}

