/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection.examples.hash.automaticupdates;

import fiftyone.devicedetection.DeviceDetectionPipelineBuilder;
import fiftyone.devicedetection.examples.ExampleBase;
import fiftyone.devicedetection.examples.ProgramBase;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngine;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngineBuilder;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.DataUpdateServiceDefault;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.engines.services.OnUpdateComplete;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.LoggerFactory;

public class UpdateOnStartUp
extends ProgramBase {
    public static void main(String[] args) throws Exception {
        String licenseKey;
        String dataFile = args.length > 0 ? args[0] : UpdateOnStartUp.getDefaultFilePath("51Degrees-LiteV4.1.hash").getAbsolutePath();
        String string = licenseKey = args.length > 1 ? args[1] : "!!Your license key!!";
        if (licenseKey.startsWith("!!")) {
            System.out.println("You need a license key to run this example, you can obtain one by subscribing to a 51Degrees bundle: https://51degrees.com/pricing");
            System.in.read();
            return;
        }
        new Example(true).run(dataFile, licenseKey);
        System.out.println("Complete. Press enter to exit.");
        System.in.read();
    }

    public static class Example
    extends ExampleBase {
        public Example(boolean printOutput) {
            super(printOutput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String dataFile, String licenseKey) throws Exception {
            Date initialPublishedDate;
            this.println("Using data file at " + dataFile);
            HttpClientDefault httpClient = new HttpClientDefault();
            try (DataUpdateServiceDefault tmpDataUpdateService = new DataUpdateServiceDefault(LoggerFactory.getLogger((String)DataUpdateServiceDefault.class.getName()), (HttpClient)httpClient);
                 DeviceDetectionHashEngine deviceDetectionHashEngine = (DeviceDetectionHashEngine)new DeviceDetectionHashEngineBuilder(LoggerFactory.getILoggerFactory(), (DataUpdateService)tmpDataUpdateService).build(dataFile, true);){
                initialPublishedDate = deviceDetectionHashEngine.getDataFilePublishedDate();
            }
            this.println("Data file published date: " + initialPublishedDate.toString());
            this.println("Creating pipeline and updating device data");
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(() -> {
                while (!executor.isShutdown()) {
                    this.print(".");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            try (DataUpdateServiceDefault dataUpdateService = new DataUpdateServiceDefault(LoggerFactory.getLogger((String)DataUpdateServiceDefault.class.getName()), (HttpClient)httpClient);){
                dataUpdateService.onUpdateComplete((OnUpdateComplete)new GetAutoUpdateStatus());
                Pipeline pipeline = new DeviceDetectionPipelineBuilder(LoggerFactory.getILoggerFactory(), (HttpClient)httpClient, (DataUpdateService)dataUpdateService).useOnPremise(dataFile, true).setDataUpdateLicenseKey(licenseKey).setAutoUpdate(true).setDataFileSystemWatcher(true).setDataUpdateOnStartup(true).build();
                executor.shutdownNow();
                Date updatedPublishedDate = ((DeviceDetectionHashEngine)pipeline.getElement(DeviceDetectionHashEngine.class)).getDataFilePublishedDate();
                if (initialPublishedDate.equals(updatedPublishedDate)) {
                    this.println("There was no update available at this time.");
                }
                this.println("Data file published date: " + updatedPublishedDate.toString());
                System.in.read();
            }
        }

        class GetAutoUpdateStatus
        implements OnUpdateComplete {
            GetAutoUpdateStatus() {
            }

            public void call(Object o, DataUpdateService.DataUpdateCompleteArgs duca) {
                System.out.println("Update completed. Status " + duca.getStatus());
            }
        }
    }
}

