/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection;

import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngine;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngineBuilder;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.data.DataUpdateUrlFormatter;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageBuilder;
import fiftyone.pipeline.engines.flowelements.PrePackagedPipelineBuilderBase;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.HttpClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class DeviceDetectionOnPremisePipelineBuilder
extends PrePackagedPipelineBuilderBase<DeviceDetectionOnPremisePipelineBuilder> {
    protected boolean shareUsageEnabled = true;
    private String filename;
    private boolean createTempDataCopy;
    private byte[] engineData;
    private int concurrency = -1;
    private Integer difference = null;
    private Boolean allowUnmatched = null;
    private Integer drift = null;
    private Boolean usePerformanceGraph = null;
    private Boolean usePredictiveGraph = null;
    private final List<String> properties = new ArrayList<String>();
    private Boolean autoUpdateEnabled = null;
    private Boolean dataFileSystemWatcher = null;
    private Boolean dataUpdateOnStartup = null;
    private Long updatePollingInterval = null;
    private Long updateRandomisationMax = null;
    private String dataUpdateLicenseKey = null;
    private String dataUpdateUrl = null;
    private Boolean dataUpdateVerifyMd5 = null;
    private DataUpdateUrlFormatter dataUpdateUrlFormatter = null;
    private Constants.PerformanceProfiles performanceProfile = Constants.PerformanceProfiles.Balanced;
    private DataUpdateService dataUpdateService;
    private final HttpClient httpClient;

    DeviceDetectionOnPremisePipelineBuilder(DataUpdateService dataUpdateService, HttpClient httpClient) {
        this(LoggerFactory.getILoggerFactory(), dataUpdateService, httpClient);
    }

    DeviceDetectionOnPremisePipelineBuilder(ILoggerFactory loggerFactory, DataUpdateService dataUpdateService, HttpClient httpClient) {
        super(loggerFactory);
        this.dataUpdateService = dataUpdateService;
        this.httpClient = httpClient;
        this.addService((PipelineService)dataUpdateService);
    }

    DeviceDetectionOnPremisePipelineBuilder setFilename(String filename, boolean createTempDataCopy) throws Exception {
        this.filename = filename;
        this.createTempDataCopy = createTempDataCopy;
        if (filename.endsWith(".dat")) {
            throw new Exception("The Pattern data format data files can not be used in version 4. Please use a Hash V4.1 data file.");
        }
        if (!filename.endsWith(".hash")) {
            throw new Exception("Unrecognised filename. Expected a '*.hash' hash data file.");
        }
        return this;
    }

    DeviceDetectionOnPremisePipelineBuilder setEngineData(byte[] data) {
        this.engineData = data;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setShareUsage(boolean enabled) {
        this.shareUsageEnabled = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setAutoUpdate(boolean enabled) {
        this.autoUpdateEnabled = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataFileSystemWatcher(boolean enabled) {
        this.dataFileSystemWatcher = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateService(DataUpdateService dataUpdateService) {
        this.dataUpdateService = dataUpdateService;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateOnStartup(boolean enabled) {
        this.dataUpdateOnStartup = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUpdatePollingInterval(int pollingIntervalSeconds) {
        this.updatePollingInterval = (long)pollingIntervalSeconds * 1000L;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUpdatePollingIntervalMillis(long pollingIntervalMillis) {
        this.updatePollingInterval = pollingIntervalMillis;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUpdateRandomisationMax(int randomisationMaxSeconds) {
        this.updateRandomisationMax = (long)randomisationMaxSeconds * 1000L;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUpdateRandomisationMaxMillis(long randomisationMaxMillis) {
        this.updateRandomisationMax = randomisationMaxMillis;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateLicenseKey(String key) {
        this.dataUpdateLicenseKey = key;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setPerformanceProfile(Constants.PerformanceProfiles profile) {
        this.performanceProfile = profile;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDifference(int difference) {
        this.difference = difference;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setAllowUnmatched(boolean allow) {
        this.allowUnmatched = allow;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDrift(int drift) {
        this.drift = drift;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUsePerformanceGraph(boolean use) {
        this.usePerformanceGraph = use;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setUsePredictiveGraph(boolean use) {
        this.usePredictiveGraph = use;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setProperty(String property) {
        this.properties.add(property);
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateUrl(String url) {
        this.dataUpdateUrl = url;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateVerifyMd5(Boolean verify) {
        this.dataUpdateVerifyMd5 = verify;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateUrlFormatter(DataUpdateUrlFormatter formatter) {
        this.dataUpdateUrlFormatter = formatter;
        return this;
    }

    public Pipeline build() throws Exception {
        DeviceDetectionHashEngineBuilder hashBuilder = new DeviceDetectionHashEngineBuilder(this.loggerFactory, this.dataUpdateService);
        DeviceDetectionHashEngine deviceDetectionEngine = this.configureAndBuild(hashBuilder);
        if (deviceDetectionEngine != null) {
            if (this.shareUsageEnabled) {
                this.getFlowElements().add(new ShareUsageBuilder(this.loggerFactory).build());
            }
        } else {
            throw new RuntimeException("Unexpected error creating device detection engine.");
        }
        this.getFlowElements().add(deviceDetectionEngine);
        this.setAutoCloseElements(true);
        return super.build();
    }

    private DeviceDetectionHashEngine configureAndBuild(DeviceDetectionHashEngineBuilder builder) throws Exception {
        DeviceDetectionHashEngine engine;
        if (this.autoUpdateEnabled != null) {
            builder.setAutoUpdate(this.autoUpdateEnabled.booleanValue());
        }
        if (this.dataFileSystemWatcher != null) {
            builder.setDataFileSystemWatcher(this.dataFileSystemWatcher.booleanValue());
        }
        if (this.dataUpdateOnStartup != null) {
            builder.setDataUpdateOnStartup(this.dataUpdateOnStartup.booleanValue());
        }
        if (this.updatePollingInterval != null) {
            builder.setUpdatePollingIntervalMillis(this.updatePollingInterval.longValue());
        }
        if (this.updateRandomisationMax != null) {
            builder.setUpdateRandomisationMaxMillis(this.updateRandomisationMax.longValue());
        }
        if (this.dataUpdateLicenseKey != null) {
            builder.setDataUpdateLicenseKey(this.dataUpdateLicenseKey);
        }
        if (this.properties.size() > 0) {
            for (String property : this.properties) {
                builder.setProperty(property);
            }
        }
        builder.setPerformanceProfile(this.performanceProfile);
        if (this.concurrency > 1) {
            builder.setConcurrency(this.concurrency);
        }
        if (this.difference != null) {
            builder.setDifference(this.difference.intValue());
        }
        if (this.allowUnmatched != null) {
            builder.setAllowUnmatched(this.allowUnmatched.booleanValue());
        }
        if (this.drift != null) {
            builder.setDrift(this.drift.intValue());
        }
        if (this.usePerformanceGraph != null) {
            builder.setUsePerformanceGraph(this.usePerformanceGraph.booleanValue());
        }
        if (this.usePredictiveGraph != null) {
            builder.setUsePredictiveGraph(this.usePredictiveGraph.booleanValue());
        }
        if (this.dataUpdateUrl != null) {
            builder.setDataUpdateUrl(this.dataUpdateUrl);
        }
        if (this.dataUpdateVerifyMd5 != null) {
            builder.setDataUpdateVerifyMd5(this.dataUpdateVerifyMd5.booleanValue());
        }
        if (this.dataUpdateUrlFormatter != null) {
            builder.setDataUpdateUrlFormatter(this.dataUpdateUrlFormatter);
        }
        if (this.filename != null && !this.filename.isEmpty()) {
            engine = (DeviceDetectionHashEngine)builder.build(this.filename, this.createTempDataCopy);
        } else if (this.engineData != null) {
            engine = (DeviceDetectionHashEngine)builder.build(this.engineData);
        } else {
            throw new PipelineConfigurationException("No source for engine data. Use setFilename or setEngineData to configure this.");
        }
        return engine;
    }
}

