/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.caching;

import fiftyone.caching.Cache;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class LruCacheBase<K, V>
implements Cache<K, V>,
Closeable {
    final CacheLinkedList[] linkedLists;
    final Random random = new Random();
    private final ConcurrentHashMap<K, CachedItem> hashMap;
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong requests = new AtomicLong(0L);
    private boolean closed = false;
    private final Object lock = new Object();
    private int cacheSize;
    private final boolean updateExisting;

    LruCacheBase(int cacheSize, int concurrency, boolean updateExisting) {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency must be a positive integer greater than 0.");
        }
        this.cacheSize = cacheSize;
        this.updateExisting = updateExisting;
        this.hashMap = new ConcurrentHashMap(cacheSize);
        CacheLinkedList[] linkedListsUnchecked = (CacheLinkedList[])Array.newInstance(CacheLinkedList.class, concurrency);
        this.linkedLists = linkedListsUnchecked;
        for (int i = 0; i < this.linkedLists.length; ++i) {
            this.linkedLists[i] = new CacheLinkedList(this);
        }
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public long getCacheMisses() {
        return this.misses.get();
    }

    public long getCacheRequests() {
        return this.requests.get();
    }

    public double getPercentageMisses() {
        return this.misses.doubleValue() / this.requests.doubleValue();
    }

    @Override
    public V get(K key) {
        this.requests.incrementAndGet();
        CachedItem node = this.hashMap.get(key);
        if (node == null) {
            this.misses.incrementAndGet();
            return null;
        }
        node.list.moveFirst(node);
        return node.value;
    }

    protected CachedItem add(K key, V value) {
        CachedItem newNode = new CachedItem(this.getRandomLinkedList(), key, value);
        CachedItem node = this.hashMap.putIfAbsent(key, newNode);
        if (node == null) {
            newNode.list.addNew(newNode);
            node = newNode;
        } else {
            if (this.updateExisting) {
                newNode.list.replace(node, newNode);
                node = newNode;
            }
            node.list.moveFirst(node);
        }
        return node;
    }

    public void resetCache() {
        this.hashMap.clear();
        this.misses.set(0L);
        this.requests.set(0L);
        for (CacheLinkedList linkedList : this.linkedLists) {
            linkedList.clear();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean closing) {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.hashMap.clear();
                    for (CacheLinkedList list : this.linkedLists) {
                        list.clear();
                    }
                }
                this.closed = true;
            }
        }
    }

    private CacheLinkedList getRandomLinkedList() {
        return this.linkedLists[this.random.nextInt(this.linkedLists.length)];
    }

    class CacheLinkedList {
        LruCacheBase<K, V> cache = null;
        CachedItem first = null;
        CachedItem last = null;

        public CacheLinkedList(LruCacheBase<K, V> cache) {
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addNew(CachedItem item) {
            CacheLinkedList cacheLinkedList;
            boolean added = false;
            if (item != this.first) {
                cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (item != this.first) {
                        if (this.first == null) {
                            this.first = item;
                            this.last = item;
                        } else {
                            item.next = this.first;
                            this.first.previous = item;
                            this.first = item;
                            added = true;
                        }
                        item.isValid = true;
                    }
                }
            }
            if (added && this.cache.hashMap.size() > this.cache.cacheSize) {
                cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (this.cache.hashMap.size() > this.cache.cacheSize) {
                        this.last.isValid = false;
                        this.cache.hashMap.remove(this.last.key);
                        this.last = this.last.previous;
                        this.last.next = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveFirst(CachedItem item) {
            if (item != this.first && item.isValid) {
                CacheLinkedList cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (item != this.first && item.isValid) {
                        if (item == this.last) {
                            this.last = item.previous;
                            this.last.next = null;
                        } else {
                            item.previous.next = item.next;
                            item.next.previous = item.previous;
                        }
                        item.next = this.first;
                        item.previous = null;
                        this.first.previous = item;
                        this.first = item;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replace(CachedItem oldItem, CachedItem newItem) {
            if (oldItem.isValid) {
                CacheLinkedList cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (oldItem.isValid) {
                        newItem.previous = oldItem.previous;
                        newItem.next = oldItem.next;
                        if (newItem.previous == null) {
                            this.first = newItem;
                        } else {
                            newItem.previous.next = newItem;
                        }
                        if (newItem.next == null) {
                            this.last = newItem;
                        } else {
                            newItem.next.previous = newItem;
                        }
                        newItem.isValid = true;
                        oldItem.isValid = false;
                        this.cache.hashMap.replace(newItem.key, newItem);
                    }
                }
            }
        }

        void clear() {
            this.first = null;
            this.last = null;
        }
    }

    class CachedItem {
        final K key;
        final V value;
        final CacheLinkedList list;
        CachedItem next;
        CachedItem previous;
        boolean isValid;

        public CachedItem(CacheLinkedList list, K key, V value) {
            this.list = list;
            this.key = key;
            this.value = value;
        }
    }
}

