/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.caching;

import fiftyone.caching.Cache;
import fiftyone.caching.LoadingCache;
import fiftyone.caching.LoadingCacheBuilder;
import fiftyone.caching.LruCacheBase;
import fiftyone.caching.ValueLoader;
import java.io.IOException;

public class LruLoadingCache<K, V>
extends LruCacheBase<K, V>
implements LoadingCache<K, V> {
    private ValueLoader<K, V> loader;

    LruLoadingCache(int cacheSize) {
        super(cacheSize, Runtime.getRuntime().availableProcessors(), false);
    }

    LruLoadingCache(int cacheSize, int concurrency) {
        super(cacheSize, concurrency, false);
    }

    public LruLoadingCache(int cacheSize, ValueLoader<K, V> loader) {
        this(cacheSize, loader, Runtime.getRuntime().availableProcessors());
    }

    LruLoadingCache(int cacheSize, ValueLoader<K, V> loader, int concurrency) {
        super(cacheSize, concurrency, false);
        this.setCacheLoader(loader);
    }

    public void setCacheLoader(ValueLoader<K, V> loader) {
        this.loader = loader;
    }

    @Override
    public V get(K key) {
        try {
            return this.get(key, this.loader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public V get(K key, ValueLoader<K, V> loader) throws IOException {
        Object result = super.get(key);
        if (result == null) {
            result = loader.load(key);
            super.add(key, result);
        }
        return result;
    }

    public static class Builder
    implements LoadingCacheBuilder {
        @Override
        public <K, V> Cache<K, V> build(Cache<K, V> c, int cacheSize) {
            return new LruLoadingCache(cacheSize);
        }
    }
}

