/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.caching;

import fiftyone.caching.Cache;
import fiftyone.caching.LruCacheBase;
import fiftyone.caching.PutCache;
import fiftyone.caching.PutCacheBuilder;

public class LruPutCache<K, V>
extends LruCacheBase<K, V>
implements PutCache<K, V> {
    LruPutCache(int cacheSize, int concurrency, boolean updateExisting) {
        super(cacheSize, concurrency, updateExisting);
    }

    @Override
    public void put(K key, V value) {
        super.add(key, value);
    }

    public static class Builder
    implements PutCacheBuilder {
        private boolean updateExisting = false;
        private int concurrency = Runtime.getRuntime().availableProcessors();

        @Override
        public <K, V> PutCache<K, V> build(Cache<K, V> c, int cacheSize) {
            return new LruPutCache(cacheSize, this.concurrency, this.updateExisting);
        }

        public Builder setConcurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Override
        public Builder setUpdateExisting(boolean update) {
            this.updateExisting = update;
            return this;
        }
    }
}

