/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.cloudrequestengine.flowelements;

import fiftyone.pipeline.cloudrequestengine.NotImplementedException;
import fiftyone.pipeline.cloudrequestengine.data.CloudRequestData;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.core.data.AccessiblePropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaDataDefault;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.data.types.JavaScript;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaDataDefault;
import fiftyone.pipeline.engines.data.AspectPropertyValueDefault;
import fiftyone.pipeline.engines.flowelements.AspectEngineBase;
import fiftyone.pipeline.engines.flowelements.CloudAspectEngine;
import fiftyone.pipeline.util.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class CloudAspectEngineBase<TData extends AspectData>
extends AspectEngineBase<TData, AspectPropertyMetaData>
implements CloudAspectEngine<TData, AspectPropertyMetaData> {
    private volatile List<AspectPropertyMetaData> aspectProperties;
    private String dataSourceTier;
    private RequestEngineAccessor requestEngine;

    public CloudAspectEngineBase(Logger logger, ElementDataFactory<TData> aspectDataFactory) {
        super(logger, aspectDataFactory);
        this.setRequestEngine(new RequestEngineAccessor(this.getPipelines(), (FlowElement<?, ?>)this));
    }

    public String getDataSourceTier() {
        return this.dataSourceTier;
    }

    protected RequestEngineAccessor getRequestEngine() {
        return this.requestEngine;
    }

    protected void setRequestEngine(RequestEngineAccessor requestEngine) {
        this.requestEngine = requestEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AspectPropertyMetaData> getProperties() {
        List<AspectPropertyMetaData> localRef = this.aspectProperties;
        if (localRef == null) {
            CloudAspectEngineBase cloudAspectEngineBase = this;
            synchronized (cloudAspectEngineBase) {
                localRef = this.aspectProperties;
                if (localRef == null && !this.loadAspectProperties()) {
                    throw new RuntimeException(String.format("Failed to load aspect properties for element '%s'. This is because your resource key does not include access to any properties under '%s'. For more details on resource keys, see our explainer: https://51degrees.com/documentation/_info__resource_keys.html", this.getElementDataKey(), this.getElementDataKey()));
                }
            }
        }
        return this.aspectProperties;
    }

    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault(this.getElementDataKey(), Types.findSubClassParameterType((Object)((Object)this), CloudAspectEngineBase.class, (int)0));
        }
        return this.typedKey;
    }

    private boolean loadAspectProperties() {
        CloudRequestEngine requestEngine = this.getRequestEngine().getInstance();
        Map<String, AccessiblePropertyMetaData.ProductMetaData> map = requestEngine.getPublicProperties();
        if (map != null && map.size() > 0 && map.containsKey(this.getElementDataKey())) {
            ArrayList<AspectPropertyMetaData> properties = new ArrayList<AspectPropertyMetaData>();
            this.dataSourceTier = map.get((Object)this.getElementDataKey()).dataTier;
            for (AccessiblePropertyMetaData.PropertyMetaData item : map.get((Object)this.getElementDataKey()).properties) {
                AspectPropertyMetaDataDefault property = new AspectPropertyMetaDataDefault(item.name, (FlowElement)this, item.category, item.getPropertyType(), new ArrayList(), true, this.loadElementProperties(item.itemProperties), item.delayExecution != null ? item.delayExecution : false, item.evidenceProperties != null ? item.evidenceProperties : new ArrayList());
                properties.add((AspectPropertyMetaData)property);
            }
            this.aspectProperties = properties;
            return true;
        }
        this.logger.error("Aspect properties could not be loaded for " + ((Object)((Object)this)).getClass().getName(), (Object)this);
        return false;
    }

    private List<ElementPropertyMetaData> loadElementProperties(List<AccessiblePropertyMetaData.PropertyMetaData> itemProperties) {
        ArrayList<ElementPropertyMetaDataDefault> result = null;
        if (itemProperties != null) {
            result = new ArrayList<ElementPropertyMetaDataDefault>();
            for (AccessiblePropertyMetaData.PropertyMetaData item : itemProperties) {
                result.add(new ElementPropertyMetaDataDefault(item.name, (FlowElement)this, item.category, item.getPropertyType(), true, this.loadElementProperties(item.itemProperties)));
            }
        }
        return result;
    }

    private Map<String, ElementPropertyMetaData> buildMetaDataMap(List<ElementPropertyMetaData> properties) {
        HashMap<String, ElementPropertyMetaData> result = new HashMap<String, ElementPropertyMetaData>();
        for (ElementPropertyMetaData property : properties) {
            result.put(property.getName().toLowerCase(), property);
        }
        return result;
    }

    protected Map<String, Object> createAPVMap(Map<String, Object> cloudData, List<ElementPropertyMetaData> propertyMetaData) {
        Map<String, ElementPropertyMetaData> metaDataMap = this.buildMetaDataMap(propertyMetaData);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> property : cloudData.entrySet()) {
            if (property.getKey().endsWith("nullreason")) continue;
            Object outputValue = property.getValue();
            if (metaDataMap.containsKey(property.getKey().toLowerCase())) {
                ElementPropertyMetaData metaData = metaDataMap.get(property.getKey().toLowerCase());
                AspectPropertyValueDefault apv = new AspectPropertyValueDefault();
                if (property.getValue() != null) {
                    Object newValue = property.getValue();
                    if (metaData.getType().equals(JavaScript.class)) {
                        newValue = new JavaScript(newValue.toString());
                    }
                    apv.setValue(newValue);
                } else if (cloudData.containsKey(property.getKey() + "nullreason")) {
                    apv.setNoValueMessage(cloudData.get(property.getKey() + "nullreason").toString());
                } else {
                    apv.setNoValueMessage("Unknown");
                }
                outputValue = apv;
            } else {
                this.logger.warn("No meta-data entry for property '" + property.getKey() + "' in '" + ((Object)((Object)this)).getClass().getSimpleName() + "'");
            }
            result.put(property.getKey(), outputValue);
        }
        return result;
    }

    protected void processEngine(FlowData data, TData aspectData) {
        String json;
        CloudRequestData requestData;
        try {
            requestData = (CloudRequestData)data.getFromElement((FlowElement)this.getRequestEngine().getInstance());
        }
        catch (Exception ex) {
            throw new PipelineConfigurationException("The " + ((Object)((Object)this)).getClass().getSimpleName() + " requires a 'CloudRequestEngine'before it in the Pipeline. This engine will be unable to produce results until this is corrected", (Throwable)ex);
        }
        if (!requestData.getProcessStarted().booleanValue()) {
            throw new PipelineConfigurationException("The " + ((Object)((Object)this)).getClass().getSimpleName() + " requires a 'CloudRequestEngine' before it in the Pipeline. This engine will be unable to produce results until this is corrected.");
        }
        String string = json = requestData == null ? null : requestData.getJsonResponse();
        if (json != null && !json.isEmpty()) {
            this.processCloudEngine(data, aspectData, json);
        } else {
            this.logger.warn("The  " + ((Object)((Object)this)).getClass().getSimpleName() + "  did not process as the JSON response from the CloudRequestEngine was null or empty. Please refer to errors generated by the CloudRequestEngine in the logs as this indicates an error occurred there.");
        }
    }

    protected void processCloudEngine(FlowData data, TData aspectData, String json) {
        throw new NotImplementedException("This method should be overridden in the class derived from CloudAspectEngineBase class. The implementation should use the 'json' parameter to populate the 'aspectData' accordingly. This method will be called by the CloudAspectEngine.ProcessEngine() method after it has successfully retrieved the JsonResponse from the CloudRequestEngine.");
    }

    protected class RequestEngineAccessor {
        private final List<Pipeline> pipelines;
        private volatile CloudRequestEngine cloudRequestEngine;
        private FlowElement<?, ?> currentElement;

        public RequestEngineAccessor(List<Pipeline> pipelines, FlowElement<?, ?> currentElement) {
            this.pipelines = pipelines;
            this.currentElement = currentElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloudRequestEngine getInstance() throws PipelineConfigurationException {
            if (this.cloudRequestEngine == null) {
                RequestEngineAccessor requestEngineAccessor = this;
                synchronized (requestEngineAccessor) {
                    if (this.cloudRequestEngine == null) {
                        if (this.pipelines.size() > 1) {
                            throw new PipelineConfigurationException("'" + this.currentElement.getClass().getName() + "' does not support being added to multiple pipelines");
                        }
                        if (this.pipelines.size() == 0) {
                            throw new PipelineConfigurationException("'" + this.currentElement.getClass().getName() + "' has not yet been added to a Pipeline.");
                        }
                        this.cloudRequestEngine = (CloudRequestEngine)this.pipelines.get(0).getElement(CloudRequestEngine.class);
                        if (this.cloudRequestEngine == null) {
                            throw new PipelineConfigurationException("'" + this.currentElement.getClass().getName() + "' requires a 'CloudRequestEngine' before it in the Pipeline.This engine will be unable to produce results until thisis corrected.");
                        }
                    }
                }
            }
            return this.cloudRequestEngine;
        }
    }
}

