/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.cloudrequestengine.flowelements;

import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.annotations.ElementBuilder;
import fiftyone.pipeline.cloudrequestengine.data.CloudRequestData;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngineDefault;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.flowelements.AspectEngineBuilderBase;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import java.util.List;
import java.util.function.Function;
import org.slf4j.ILoggerFactory;

@ElementBuilder
public class CloudRequestEngineBuilder
extends AspectEngineBuilderBase<CloudRequestEngineBuilder, CloudRequestEngine> {
    private final HttpClient httpClient;
    private String endPoint = null;
    private String dataEndpoint = null;
    private String propertiesEndpoint = null;
    private String evidenceKeysEndpoint = null;
    private String resourceKey = null;
    private String licenseKey = null;
    private String cloudRequestOrigin = null;
    private int timeoutMillis = 100000;
    private Function<String, String> getEnvVar = name -> System.getenv(name);

    public CloudRequestEngineBuilder(ILoggerFactory loggerFactory) {
        this(loggerFactory, (HttpClient)new HttpClientDefault());
    }

    public CloudRequestEngineBuilder(ILoggerFactory loggerFactory, HttpClient httpClient) {
        super(loggerFactory);
        this.httpClient = httpClient;
    }

    protected CloudRequestEngine newEngine(List<String> properties) throws Exception {
        if (this.resourceKey == null || this.resourceKey.isEmpty()) {
            throw new PipelineConfigurationException("A resource key is required to access the cloud server. Please use the 'setResourceKey(String) method to supply your resource key obtained from https://configure.51degrees.com");
        }
        if (this.endPoint == null || this.endPoint.isEmpty()) {
            String envVarEndPoint = this.getEnvVar.apply("FOD_CLOUD_API_URL");
            if (envVarEndPoint == null || envVarEndPoint.isEmpty()) {
                this.setEndpoint("https://cloud.51degrees.com/api/v4");
            } else {
                this.setEndpoint(envVarEndPoint);
            }
        }
        return new CloudRequestEngineDefault(this.loggerFactory.getLogger(CloudRequestEngine.class.getName()), new CloudRequestDataFactory(this.loggerFactory), this.httpClient, this.dataEndpoint, this.resourceKey, this.licenseKey, this.propertiesEndpoint, this.evidenceKeysEndpoint, this.timeoutMillis, this.cloudRequestOrigin);
    }

    private String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    public CloudRequestEngine build() throws Exception {
        return (CloudRequestEngine)this.buildEngine();
    }

    @DefaultValue(value="https://cloud.51degrees.com/api/v4")
    public CloudRequestEngineBuilder setEndpoint(String uri) {
        if (!uri.endsWith("/")) {
            uri = uri + '/';
        }
        this.endPoint = uri;
        return this.setDataEndpoint(uri + (this.resourceKey != null ? this.resourceKey + "." : "") + "json").setPropertiesEndpoint(uri + "accessibleproperties").setEvidenceKeysEndpoint(uri + "evidencekeys");
    }

    @DefaultValue(value="https://cloud.51degrees.com/api/v4{resourcekey}.json")
    public CloudRequestEngineBuilder setDataEndpoint(String uri) {
        this.dataEndpoint = uri;
        return this;
    }

    @DefaultValue(value="https://cloud.51degrees.com/api/v4accessibleproperties")
    public CloudRequestEngineBuilder setPropertiesEndpoint(String uri) {
        this.propertiesEndpoint = uri;
        return this;
    }

    @DefaultValue(value="https://cloud.51degrees.com/api/v4evidencekeys")
    public CloudRequestEngineBuilder setEvidenceKeysEndpoint(String uri) {
        this.evidenceKeysEndpoint = uri;
        return this;
    }

    @DefaultValue(value="No default - a resource key must be supplied")
    public CloudRequestEngineBuilder setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    @DefaultValue(value="No default")
    public CloudRequestEngineBuilder setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    @DefaultValue(intValue=100)
    public CloudRequestEngineBuilder setTimeOutSeconds(int timeout) {
        this.timeoutMillis = timeout * 1000;
        return this;
    }

    @DefaultValue(value="None")
    public CloudRequestEngineBuilder setCloudRequestOrigin(String cloudRequestOrigin) {
        this.cloudRequestOrigin = cloudRequestOrigin;
        return this;
    }

    @DefaultValue(value="No cache")
    public CloudRequestEngineBuilder setCacheSize(int size) {
        this.cacheConfig = new CacheConfiguration(size);
        return this;
    }

    private static class CloudRequestDataFactory
    implements ElementDataFactory<CloudRequestData> {
        private final ILoggerFactory loggerFactory;

        public CloudRequestDataFactory(ILoggerFactory loggerFactory) {
            this.loggerFactory = loggerFactory;
        }

        public CloudRequestData create(FlowData flowData, FlowElement<CloudRequestData, ?> engine) {
            return new CloudRequestData(this.loggerFactory.getLogger(CloudRequestData.class.getName()), flowData, (CloudRequestEngine)engine);
        }
    }
}

