/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.cloudrequestengine.flowelements;

import fiftyone.pipeline.cloudrequestengine.CloudRequestException;
import fiftyone.pipeline.cloudrequestengine.data.CloudRequestData;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.core.data.AccessiblePropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PropertyNotLoadedException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaDataDefault;
import fiftyone.pipeline.engines.flowelements.AspectEngineBase;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.exceptions.AggregateException;
import fiftyone.pipeline.util.StringManipulation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class CloudRequestEngineDefault
extends AspectEngineBase<CloudRequestData, AspectPropertyMetaData>
implements CloudRequestEngine {
    private HttpClient httpClient;
    private String endPoint;
    private String resourceKey;
    private String licenseKey;
    private String propertiesEndpoint;
    private String evidenceKeysEndpoint;
    private String cloudRequestOrigin;
    private Integer timeoutMillis;
    private List<AspectPropertyMetaData> propertyMetaData;
    private volatile Map<String, AccessiblePropertyMetaData.ProductMetaData> publicProperties;
    private final Object publicPropertiesLock = new Object();
    private volatile EvidenceKeyFilter evidenceKeyFilter;
    private final Object evidenceKeyFilterLock = new Object();

    public CloudRequestEngineDefault(Logger logger, ElementDataFactory<CloudRequestData> aspectDataFactory, HttpClient httpClient, String endPoint, String resourceKey, String propertiesEndpoint, String evidenceKeysEndpoint, int timeoutMillis) {
        this(logger, aspectDataFactory, httpClient, endPoint, resourceKey, null, propertiesEndpoint, evidenceKeysEndpoint, timeoutMillis, null);
    }

    public CloudRequestEngineDefault(Logger logger, ElementDataFactory<CloudRequestData> aspectDataFactory, HttpClient httpClient, String endPoint, String resourceKey, String propertiesEndpoint, String evidenceKeysEndpoint, int timeoutMillis, String cloudRequestOrigin) {
        this(logger, aspectDataFactory, httpClient, endPoint, resourceKey, null, propertiesEndpoint, evidenceKeysEndpoint, timeoutMillis, cloudRequestOrigin);
    }

    public CloudRequestEngineDefault(Logger logger, ElementDataFactory<CloudRequestData> aspectDataFactory, HttpClient httpClient, String endPoint, String resourceKey, String licenseKey, String propertiesEndpoint, String evidenceKeysEndpoint, int timeoutMillis, String cloudRequestOrigin) {
        super(logger, aspectDataFactory);
        this.endPoint = endPoint;
        this.resourceKey = resourceKey;
        this.licenseKey = licenseKey;
        this.propertiesEndpoint = propertiesEndpoint;
        this.evidenceKeysEndpoint = evidenceKeysEndpoint;
        this.httpClient = httpClient;
        this.cloudRequestOrigin = cloudRequestOrigin;
        this.timeoutMillis = timeoutMillis > 0 ? Integer.valueOf(timeoutMillis) : null;
        this.propertyMetaData = new ArrayList<AspectPropertyMetaData>();
        this.propertyMetaData.add((AspectPropertyMetaData)new AspectPropertyMetaDataDefault("json-response", (FlowElement)this, "", String.class, new ArrayList(), true));
        this.propertyMetaData.add((AspectPropertyMetaData)new AspectPropertyMetaDataDefault("process-started", (FlowElement)this, "", Boolean.class, new ArrayList(), true));
    }

    public List<AspectPropertyMetaData> getProperties() {
        return this.propertyMetaData;
    }

    public String getDataSourceTier() {
        return "cloud";
    }

    public String getElementDataKey() {
        return "cloud-response";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvidenceKeyFilter getEvidenceKeyFilter() throws CloudRequestException, AggregateException, PropertyNotLoadedException {
        if (this.evidenceKeyFilter == null) {
            Object object = this.evidenceKeyFilterLock;
            synchronized (object) {
                if (this.evidenceKeyFilter == null) {
                    this.getCloudEvidenceKeys();
                }
            }
        }
        return this.evidenceKeyFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AccessiblePropertyMetaData.ProductMetaData> getPublicProperties() throws CloudRequestException, AggregateException, PropertyNotLoadedException {
        if (this.publicProperties == null) {
            Object object = this.publicPropertiesLock;
            synchronized (object) {
                if (this.publicProperties == null) {
                    this.getCloudProperties();
                }
            }
        }
        return this.publicProperties;
    }

    protected void processEngine(FlowData data, CloudRequestData aspectData) throws IOException {
        byte[] content = this.getContent(data);
        HttpURLConnection connection = this.httpClient.connect(new URL(this.endPoint.trim()));
        if (this.timeoutMillis != null) {
            connection.setConnectTimeout(this.timeoutMillis);
            connection.setReadTimeout(this.timeoutMillis);
        }
        aspectData.setProcessStarted(true);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.setCommonHeaders(headers);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Content-Length", Integer.toString(content.length));
        String response = this.httpClient.postData(connection, headers, content);
        aspectData.setJsonResponse(response);
        this.validateResponse(response, connection);
    }

    private byte[] getContent(FlowData data) throws UnsupportedEncodingException {
        Map<String, Object> formData = this.getFormData(data);
        ArrayList<String> formItems = new ArrayList<String>();
        formItems.add("resource=" + this.resourceKey);
        if (this.licenseKey != null && !this.licenseKey.isEmpty()) {
            formItems.add("license=" + this.licenseKey);
        }
        List<String> formKeys = Arrays.asList(formData.keySet().toArray(new String[0]));
        Collections.sort(formKeys, Collections.reverseOrder());
        for (String key : formKeys) {
            formItems.add(key + "=" + URLEncoder.encode(formData.get(key).toString(), "UTF-8"));
        }
        String string = StringManipulation.stringJoin(formItems, (String)"&");
        return string.getBytes(StandardCharsets.UTF_8);
    }

    Map<String, Object> getFormData(FlowData flowData) {
        Map evidence = flowData.getEvidence().asKeyMap();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        this.addFormData(formData, evidence, this.getSelectedEvidence(evidence, "other"));
        this.addFormData(formData, evidence, this.getSelectedEvidence(evidence, "cookie"));
        this.addFormData(formData, evidence, this.getSelectedEvidence(evidence, "header"));
        this.addFormData(formData, evidence, this.getSelectedEvidence(evidence, "query"));
        return formData;
    }

    private void addFormData(Map<String, Object> formData, Map<String, Object> allEvidence, Map<String, Object> evidence) {
        List<String> evidenceKeys = Arrays.asList(evidence.keySet().toArray(new String[0]));
        Collections.sort(evidenceKeys, Collections.reverseOrder());
        for (String evidenceKey : evidenceKeys) {
            String[] evidenceKeyParts = evidenceKey.split(Pattern.quote("."));
            String prefix = evidenceKeyParts[0];
            String suffix = evidenceKeyParts[1];
            if (!formData.containsKey(suffix)) {
                formData.put(suffix, evidence.get(evidenceKey));
                continue;
            }
            if (!prefix.equals("query")) {
                HashMap<String, Object> conflicts = new HashMap<String, Object>();
                for (String string : allEvidence.keySet()) {
                    if (string.equals(evidenceKey) || !string.contains(suffix)) continue;
                    conflicts.put(string, allEvidence.get(string));
                }
                StringBuilder conflictStr = new StringBuilder();
                for (Map.Entry conflict : conflicts.entrySet()) {
                    if (conflictStr.length() > 0) {
                        conflictStr.append(", ");
                    }
                    conflictStr.append(String.format("%s:%s", conflict.getKey(), conflict.getValue()));
                }
                String string = String.format("'%s:%s' evidence conflicts with %s", evidenceKey, evidence.get(evidenceKey), conflictStr.toString());
                this.logger.warn(string);
            }
            formData.put(suffix, evidence.get(evidenceKey));
        }
    }

    Map<String, Object> getSelectedEvidence(Map<String, Object> evidence, String type) {
        HashMap<String, Object> selectedEvidence = new HashMap<String, Object>();
        if (type.equals("other")) {
            for (Map.Entry<String, Object> entry : evidence.entrySet()) {
                if (this.hasKeyPrefix(entry.getKey(), "query") || this.hasKeyPrefix(entry.getKey(), "header") || this.hasKeyPrefix(entry.getKey(), "cookie")) continue;
                selectedEvidence.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> entry : evidence.entrySet()) {
                if (!this.hasKeyPrefix(entry.getKey(), type)) continue;
                selectedEvidence.put(entry.getKey(), entry.getValue());
            }
        }
        return selectedEvidence;
    }

    private boolean hasKeyPrefix(String itemKey, String prefix) {
        return itemKey.startsWith(prefix + ".");
    }

    protected void unmanagedResourcesCleanup() {
    }

    private void setCommonHeaders(Map<String, String> headers) {
        if (this.cloudRequestOrigin != null && this.cloudRequestOrigin.length() > 0) {
            headers.put("Origin", this.cloudRequestOrigin);
        }
    }

    private void getCloudProperties() throws CloudRequestException, AggregateException, PropertyNotLoadedException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setCommonHeaders(headers);
            HttpURLConnection connection = this.httpClient.connect(new URL(this.propertiesEndpoint.trim() + (this.resourceKey != null ? "?Resource=" + this.resourceKey : "")));
            String jsonResult = this.httpClient.getResponseString(connection, headers);
            this.validateResponse(jsonResult, connection);
            JSONObject jsonObj = null;
            if (!jsonResult.isEmpty()) {
                jsonObj = new JSONObject(jsonResult);
            }
            if (jsonObj == null) {
                throw new RuntimeException("Failed to retrieve available properties from cloud service at " + this.propertiesEndpoint + ".");
            }
            AccessiblePropertyMetaData.LicencedProducts accessiblePropertyData = new AccessiblePropertyMetaData.LicencedProducts(jsonObj.getJSONObject("Products"));
            this.publicProperties = accessiblePropertyData.products;
        }
        catch (IOException e) {
            throw new PropertyNotLoadedException((Throwable)e);
        }
    }

    private void getCloudEvidenceKeys() throws CloudRequestException, AggregateException, PropertyNotLoadedException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setCommonHeaders(headers);
            HttpURLConnection connection = this.httpClient.connect(new URL(this.evidenceKeysEndpoint.trim()));
            String jsonResult = this.httpClient.getResponseString(connection, headers);
            this.validateResponse(jsonResult, connection, false);
            if (jsonResult != null && !jsonResult.isEmpty()) {
                JSONArray jsonArray = new JSONArray(jsonResult);
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    keys.add(jsonArray.get(i).toString());
                }
                this.evidenceKeyFilter = new EvidenceKeyFilterWhitelist(keys, String.CASE_INSENSITIVE_ORDER);
            }
        }
        catch (IOException e) {
            throw new PropertyNotLoadedException((Throwable)e);
        }
    }

    private void validateResponse(String jsonResult, HttpURLConnection connection) throws IOException, CloudRequestException, AggregateException {
        this.validateResponse(jsonResult, connection, true);
    }

    private void validateResponse(String jsonResult, HttpURLConnection connection, boolean checkForErrorMessages) throws IOException, CloudRequestException, AggregateException {
        String message;
        int code = connection.getResponseCode();
        boolean hasData = jsonResult != null && !jsonResult.isEmpty();
        ArrayList<String> messages = new ArrayList<String>();
        if (hasData && checkForErrorMessages) {
            JSONObject jObj = new JSONObject(jsonResult);
            boolean hasErrors = jObj.keySet().contains("errors");
            boolean bl = hasErrors ? jObj.keySet().size() > 1 : (hasData = jObj.keySet().size() > 0);
            if (hasErrors) {
                JSONArray errors = jObj.getJSONArray("errors");
                messages.addAll(errors.toList().stream().map(Object::toString).collect(Collectors.toList()));
            }
        }
        if (messages.size() == 0 && !hasData) {
            message = String.format("No data in response from cloud service at '%s'", this.endPoint);
            messages.add(message);
        } else if (messages.size() == 0 && code != 200) {
            message = String.format("Cloud service at '%s' returned status code '%d' with content: %s", this.endPoint, code, jsonResult);
            messages.add(message);
        }
        Map<String, List<String>> headers = null;
        if (messages.size() > 0) {
            headers = connection.getHeaderFields();
        }
        Map<String, List<String>> finalHeaders = headers;
        if (messages.size() > 1) {
            throw new AggregateException("Multiple errors returned from 51Degrees cloud service. See inner exceptions for details.", (Collection)messages.stream().map(m -> new CloudRequestException((String)m, code, finalHeaders)).collect(Collectors.toList()));
        }
        if (messages.size() == 1) {
            String message2 = String.format("Error returned from 51Degrees cloud service: %s", messages.get(0));
            throw new CloudRequestException(message2, code, finalHeaders);
        }
    }
}

