/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.cloudrequestengine.flowelements;

import fiftyone.pipeline.cloudrequestengine.flowelements.CloudAspectEngineBase;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.MultiProfileData;
import fiftyone.pipeline.util.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;

public abstract class PropertyKeyedCloudEngineBase<TData extends MultiProfileData<TProfile>, TProfile extends AspectData>
extends CloudAspectEngineBase<TData> {
    private final EvidenceKeyFilter evidenceKeyFilter = new EvidenceKeyFilterWhitelist(new ArrayList());

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return this.evidenceKeyFilter;
    }

    public PropertyKeyedCloudEngineBase(Logger logger, ElementDataFactory<TData> aspectDataFactory) {
        super(logger, aspectDataFactory);
    }

    @Override
    protected void processCloudEngine(FlowData data, TData aspectData, String json) {
        JSONObject map = new JSONObject(json);
        JSONObject propertyKeyed = map.getJSONObject(this.getElementDataKey());
        for (Object entry : propertyKeyed.getJSONArray("profiles")) {
            JSONObject propertyValues = new JSONObject(entry.toString());
            TProfile profile = this.createProfileData(data);
            List propertyMetaData = null;
            for (AspectPropertyMetaData p : this.getProperties()) {
                if (!p.getName().equalsIgnoreCase("profiles")) continue;
                propertyMetaData = p.getItemProperties();
            }
            Map<String, Object> profileData = this.createAPVMap(propertyValues.toMap(), propertyMetaData);
            profile.populateFromMap(profileData);
            aspectData.addProfile(profile);
        }
    }

    @Override
    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault(this.getElementDataKey(), Types.findSubClassParameterType((Object)((Object)this), PropertyKeyedCloudEngineBase.class, (int)0));
        }
        return this.typedKey;
    }

    protected abstract TProfile createProfileData(FlowData var1);
}

