/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.configuration;

import fiftyone.pipeline.core.configuration.ElementOptions;
import fiftyone.pipeline.core.configuration.MapAdapter;
import fiftyone.pipeline.util.FiftyOneLookup;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XmlRootElement(name="PipelineOptions")
public class PipelineOptions {
    @XmlElementWrapper(name="Elements")
    @XmlElement(name="Element")
    public List<ElementOptions> elements = new ArrayList<ElementOptions>();
    @XmlElement(name="BuildParameters")
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    public Map<String, Object> pipelineBuilderParameters = new HashMap<String, Object>();

    public String find(String builderName, String buildParameter) {
        for (ElementOptions opts : this.elements) {
            if (!opts.builderName.equals(builderName)) continue;
            return (String)opts.buildParameters.get(buildParameter);
        }
        return null;
    }

    public String findAndSubstitute(String builderName, String buildParameter) {
        for (ElementOptions opts : this.elements) {
            if (!opts.builderName.equals(builderName)) continue;
            return FiftyOneLookup.getSubstitutor().replace(opts.buildParameters.get(buildParameter));
        }
        return null;
    }

    public boolean replace(String builderName, String buildParameter, String value) {
        for (ElementOptions opts : this.elements) {
            if (!opts.builderName.equals(builderName)) continue;
            opts.buildParameters.put(buildParameter, value);
            return true;
        }
        return false;
    }
}

