/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.configuration;

import fiftyone.pipeline.core.configuration.PipelineOptions;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class PipelineOptionsFactory {
    public static final String PIPELINE_OPTIONS_SCHEMA = "pipelineOptions.xsd";

    public static PipelineOptions getOptionsFromFile(String configFile) throws Exception {
        return PipelineOptionsFactory.getOptionsFromFile(new File(configFile));
    }

    public static PipelineOptions getOptionsFromFile(File configFile) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PipelineOptions.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema optionsSchema = sf.newSchema(PipelineOptionsFactory.class.getClassLoader().getResource(PIPELINE_OPTIONS_SCHEMA));
        unmarshaller.setSchema(optionsSchema);
        return (PipelineOptions)unmarshaller.unmarshal(configFile);
    }
}

