/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.data;

import fiftyone.pipeline.core.data.types.JavaScript;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccessiblePropertyMetaData {

    public static class PropertyMetaData {
        public String name;
        public String type;
        public String category;
        public List<PropertyMetaData> itemProperties;
        public Boolean delayExecution;
        public List<String> evidenceProperties;

        public PropertyMetaData(String name, String type, String category, List<PropertyMetaData> itemProperties) {
            this.name = name;
            this.type = type;
            this.category = category;
            this.itemProperties = itemProperties;
            this.delayExecution = false;
            this.evidenceProperties = null;
        }

        public PropertyMetaData(String name, String type, String category, List<PropertyMetaData> itemProperties, Boolean delayExecution, List<String> evidenceProperties) {
            this.name = name;
            this.type = type;
            this.category = category;
            this.itemProperties = itemProperties;
            this.delayExecution = delayExecution;
            this.evidenceProperties = evidenceProperties;
        }

        public PropertyMetaData(JSONObject json) {
            int i;
            JSONArray array;
            this.name = json.getString("Name");
            this.type = json.getString("Type");
            this.category = json.getString("Category");
            if (json.has("ItemProperties")) {
                array = json.getJSONArray("ItemProperties");
                this.itemProperties = new ArrayList<PropertyMetaData>();
                for (i = 0; i < array.length(); ++i) {
                    this.itemProperties.add(new PropertyMetaData(array.getJSONObject(i)));
                }
            }
            if (json.has("DelayExecution")) {
                this.delayExecution = json.getBoolean("DelayExecution");
            }
            if (json.has("EvidenceProperties")) {
                array = json.getJSONArray("EvidenceProperties");
                this.evidenceProperties = new ArrayList<String>();
                for (i = 0; i < array.length(); ++i) {
                    this.evidenceProperties.add(array.getString(i));
                }
            }
        }

        public Class<?> getPropertyType() {
            switch (this.type) {
                case "String": {
                    return String.class;
                }
                case "Int32": {
                    return Integer.TYPE;
                }
                case "Array": {
                    return List.class;
                }
                case "Boolean": {
                    return Boolean.TYPE;
                }
                case "JavaScript": {
                    return JavaScript.class;
                }
                case "Double": {
                    return Double.TYPE;
                }
            }
            throw new TypeNotPresentException(this.type, null);
        }
    }

    public static class ProductMetaData {
        public String dataTier;
        public List<PropertyMetaData> properties;

        public ProductMetaData() {
            this.properties = null;
            this.dataTier = null;
        }

        public ProductMetaData(JSONObject json) {
            this.properties = new ArrayList<PropertyMetaData>();
            this.dataTier = json.getString("DataTier");
            JSONArray jsonProperties = json.getJSONArray("Properties");
            for (int i = 0; i < jsonProperties.length(); ++i) {
                this.properties.add(new PropertyMetaData(jsonProperties.getJSONObject(i)));
            }
        }
    }

    public static class LicencedProducts {
        public final Map<String, ProductMetaData> products = new HashMap<String, ProductMetaData>();

        public LicencedProducts(JSONObject json) {
            for (String key : json.keySet()) {
                this.products.put(key, new ProductMetaData(json.getJSONObject(key)));
            }
        }
    }
}

