/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.data;

import fiftyone.pipeline.core.data.Data;
import fiftyone.pipeline.util.Check;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;

public abstract class DataBase
implements Data {
    protected final Logger logger;
    private final Map<String, Object> data;

    public DataBase(Logger logger) {
        this(logger, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
    }

    public DataBase(Logger logger, Map<String, Object> data) {
        this.logger = logger;
        this.data = Check.getNotNull(data, "Data supplied must not be null");
    }

    @Override
    public Object get(String key) {
        return this.getAs(key, Object.class, new Class[0]);
    }

    @Override
    public void put(String key, Object value) {
        if (this.data.containsKey(key) && this.logger.isDebugEnabled()) {
            this.logger.debug("Data '" + this.getClass().getName() + "'-'" + this.hashCode() + "' overwriting existing value for '" + key + "' (old value '" + this.asTruncatedString(this.data.get(key)) + "', new value '" + this.asTruncatedString(value) + "').");
        }
        this.data.put(key, value);
    }

    @Override
    public Map<String, Object> asKeyMap() {
        return Collections.unmodifiableMap(this.data);
    }

    @Override
    public void populateFromMap(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.data.put(entry.getKey(), entry.getValue());
        }
    }

    protected <T> T getAs(String key, Class<T> type, Class<?> ... parameterisedTypes) throws ClassCastException {
        Check.getNotNull(key, "Supplied key must not be null");
        this.logger.debug("Data '" + this.getClass().getSimpleName() + "'-'" + this.hashCode() + "' property value requested for key '" + key + "'.");
        T result = null;
        if (this.data.containsKey(key)) {
            result = type.cast(this.data.get(key));
        }
        return result;
    }

    private String asTruncatedString(Object value) {
        String str;
        String string = str = value == null ? "NULL" : value.toString();
        if (str.length() > 50) {
            str = str.substring(0, 47) + "...";
        }
        return str;
    }
}

