/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.data;

import fiftyone.pipeline.core.data.DataKey;
import fiftyone.pipeline.core.data.DataKeyBuilder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DataKeyBuilderDefault
implements DataKeyBuilder {
    private final List<Map.Entry<Integer, Map.Entry<String, Object>>> keys = new ArrayList<Map.Entry<Integer, Map.Entry<String, Object>>>();

    @Override
    public DataKeyBuilder add(int order, String keyName, Object keyValue) {
        this.keys.add(new AbstractMap.SimpleEntry<Integer, AbstractMap.SimpleEntry<String, Object>>(order, new AbstractMap.SimpleEntry<String, Object>(keyName, keyValue)));
        return this;
    }

    @Override
    public DataKey build() {
        Map.Entry[] keyArray = new Map.Entry[]{};
        keyArray = this.keys.toArray(keyArray);
        Arrays.sort(keyArray, new KeyComparator());
        ArrayList<Object> keyList = new ArrayList<Object>(keyArray.length);
        for (Map.Entry key : keyArray) {
            keyList.add(((Map.Entry)key.getValue()).getValue());
        }
        return new DataKey(keyList);
    }

    private static class KeyComparator
    implements Comparator<Map.Entry<Integer, Map.Entry<String, Object>>> {
        private KeyComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, Map.Entry<String, Object>> o1, Map.Entry<Integer, Map.Entry<String, Object>> o2) {
            int result = o1.getKey().compareTo(o2.getKey());
            if (result != 0) {
                return result;
            }
            result = o1.getValue().getKey().compareTo(o2.getValue().getKey());
            return result;
        }
    }
}

