/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.data;

import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class EvidenceKeyFilterAggregator
extends EvidenceKeyFilterWhitelist {
    private final List<EvidenceKeyFilter> filters = new ArrayList<EvidenceKeyFilter>();

    public EvidenceKeyFilterAggregator() {
        super(new ArrayList<String>(), (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
    }

    public void addFilter(EvidenceKeyFilter filter) {
        boolean addFilter = true;
        if (filter instanceof EvidenceKeyFilterWhitelist) {
            EvidenceKeyFilterWhitelist whitelistFilter = (EvidenceKeyFilterWhitelist)filter;
            if (whitelistFilter.comparator != null && whitelistFilter.comparator == String.CASE_INSENSITIVE_ORDER) {
                addFilter = false;
                for (Map.Entry<String, Integer> entry : whitelistFilter.whitelist.entrySet()) {
                    if (this.whitelist.containsKey(entry.getKey())) continue;
                    this.whitelist.put(entry.getKey(), entry.getValue());
                }
                if (filter.getClass().getSuperclass() != null && filter.getClass().getSuperclass() == EvidenceKeyFilterWhitelist.class) {
                    addFilter = true;
                }
            }
        }
        if (addFilter) {
            this.filters.add(filter);
        }
    }

    @Override
    public boolean include(String key) {
        boolean include = super.include(key);
        for (int index = 0; !include && index < this.filters.size(); ++index) {
            include = this.filters.get(index).include(key);
        }
        return include;
    }

    @Override
    public Integer order(String key) {
        Integer order = super.order(key);
        for (int index = 0; order == null && index < this.filters.size(); ++index) {
            order = this.filters.get(index).order(key);
        }
        return order;
    }
}

