/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.data;

import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EvidenceKeyFilterWhitelist
implements EvidenceKeyFilter {
    protected final Map<String, Integer> whitelist;
    protected final Comparator<String> comparator;

    public EvidenceKeyFilterWhitelist(List<String> whitelist) {
        this.whitelist = new TreeMap<String, Integer>();
        this.addValues(whitelist);
        this.comparator = null;
    }

    public EvidenceKeyFilterWhitelist(List<String> whitelist, Comparator<String> comparator) {
        this.whitelist = new TreeMap<String, Integer>(comparator);
        this.addValues(whitelist);
        this.comparator = comparator;
    }

    public EvidenceKeyFilterWhitelist(Map<String, Integer> whitelist) {
        this.whitelist = new TreeMap<String, Integer>();
        this.addValues(whitelist);
        this.comparator = null;
    }

    public EvidenceKeyFilterWhitelist(Map<String, Integer> whitelist, Comparator<String> comparator) {
        this.whitelist = new TreeMap<String, Integer>(comparator);
        this.addValues(whitelist);
        this.comparator = comparator;
    }

    private void addValues(Map<String, Integer> values) {
        for (Map.Entry<String, Integer> entry : values.entrySet()) {
            if (this.whitelist.containsKey(entry.getKey())) continue;
            this.whitelist.put(entry.getKey(), entry.getValue());
        }
    }

    private void addValues(List<String> values) {
        for (String value : values) {
            if (this.whitelist.containsKey(value)) continue;
            this.whitelist.put(value, 0);
        }
    }

    public Map<String, Integer> getWhitelist() {
        return Collections.unmodifiableMap(this.whitelist);
    }

    @Override
    public boolean include(String key) {
        return this.whitelist.containsKey(key);
    }

    @Override
    public Integer order(String key) {
        if (this.whitelist.containsKey(key)) {
            return this.whitelist.get(key);
        }
        return null;
    }
}

