/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.core.data.DataKey;
import fiftyone.pipeline.core.data.DataKeyBuilderDefault;
import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.Evidence;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.FlowError;
import fiftyone.pipeline.core.data.PropertyMatcher;
import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.exceptions.PipelineDataException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineInternal;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.core.typed.TypedKeyMap;
import fiftyone.pipeline.core.typed.TypedKeyMapBuilder;
import fiftyone.pipeline.util.Check;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

class FlowDataDefault
implements FlowData {
    private final Logger logger;
    private final Object lock = new Object();
    private final PipelineInternal pipeline;
    private final Collection<FlowError> errors;
    private final TypedKeyMap data;
    private final Evidence evidence;
    private boolean stop = false;
    private final AtomicBoolean processed = new AtomicBoolean(false);

    FlowDataDefault(Logger logger, Pipeline pipeline, Evidence evidence) {
        this.logger = logger;
        this.pipeline = (PipelineInternal)pipeline;
        this.evidence = evidence;
        if (pipeline.isConcurrent()) {
            this.data = new TypedKeyMapBuilder(true).build();
            this.errors = new ConcurrentLinkedQueue<FlowError>();
        } else {
            this.data = new TypedKeyMapBuilder(false).build();
            this.errors = new LinkedList<FlowError>();
        }
        logger.debug("FlowData '" + this.hashCode() + "' created.");
    }

    @Override
    public void process() {
        if (this.processed.getAndSet(true)) {
            throw new IllegalStateException("Flow data has already been processed");
        }
        if (this.pipeline.isClosed()) {
            throw new IllegalStateException("Pipeline has been closed.");
        }
        this.pipeline.process(this);
    }

    @Override
    public boolean isStopped() {
        return this.stop;
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Collection<FlowError> getErrors() {
        return new ArrayList<FlowError>(this.errors);
    }

    @Override
    public void addError(FlowError error) {
        this.errors.add(error);
        if (this.logger.isErrorEnabled()) {
            String message = "Error occurred during processing";
            if (error.getFlowElement() != null) {
                message = message + " of " + error.getFlowElement().getClass().getSimpleName() + "-" + error.getFlowElement().hashCode();
            }
            this.logger.error(message);
        }
    }

    @Override
    public void addError(Throwable e, FlowElement element) {
        this.addError(new FlowError.Default(e, element));
    }

    @Override
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Override
    public <T> TryGetResult<T> tryGetEvidence(String key, Class<T> type) {
        TryGetResult<T> result = new TryGetResult<T>();
        if (this.evidence.asKeyMap().containsKey(key)) {
            try {
                Object obj = this.evidence.get(key);
                T value = type.cast(obj);
                result.setValue(value);
            }
            catch (ClassCastException e) {
                this.logger.debug("Evidence for the key '" + key + "' was found, but was the wrong type (should have been " + type.getSimpleName() + ")", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public List<String> getDataKeys() {
        return this.data.getKeys();
    }

    @Override
    public FlowData addEvidence(String key, Object value) {
        this.evidence.put(key, value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("FlowData '" + this.hashCode() + "' set evidence '" + key + "' to '" + value.toString() + "'.");
        }
        return this;
    }

    @Override
    public FlowData addEvidence(Map<String, ?> values) {
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            this.addEvidence(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public <T extends ElementData> T get(TypedKey<T> key) {
        if (!this.processed.get()) {
            throw new IllegalStateException("This instance has not yet been processed.");
        }
        Check.getNotNull(key, "Element data key cannot be null.");
        return (T)((ElementData)this.data.get(key));
    }

    @Override
    public ElementData get(String key) {
        if (!this.processed.get()) {
            throw new RuntimeException("This instance has not yet been processed");
        }
        return (ElementData)this.data.get(new TypedKeyDefault(key, ElementData.class));
    }

    @Override
    public <T extends ElementData> T get(Class<T> type) {
        return (T)((ElementData)this.data.get(type));
    }

    @Override
    public <T extends ElementData> T getFromElement(FlowElement<T, ?> element) {
        Check.getNotNull(element, "Element cannot be null");
        return this.get(element.getTypedDataKey());
    }

    @Override
    public <T> T getAs(String key, Class<T> type) {
        T result;
        if (!this.processed.get()) {
            String message = "Flow data has not yet been processed";
            this.logger.error(message);
            throw new PipelineDataException(message);
        }
        ElementPropertyMetaData property = this.pipeline.getMetaDataForProperty(key);
        try {
            result = type.cast(this.get(property.getElement().getElementDataKey()).get(property.getName()));
        }
        catch (ClassCastException e) {
            String message = "Failed to cast property '" + key + "' to '" + type.getSimpleName() + "'. Expected property type is '" + property.getType().getSimpleName() + "'.";
            this.logger.error(message);
            throw e;
        }
        return result;
    }

    @Override
    public <T extends ElementData> TryGetResult<T> tryGetValue(TypedKey<T> key) {
        return this.data.tryGet(key);
    }

    @Override
    public String getAsString(String propertyName) {
        return this.getAs(propertyName, String.class);
    }

    @Override
    public Boolean getAsBool(String propertyName) {
        return this.getAs(propertyName, Boolean.class);
    }

    @Override
    public Integer getAsInt(String propertyName) {
        return this.getAs(propertyName, Integer.class);
    }

    @Override
    public Long getAsLong(String propertyName) {
        return this.getAs(propertyName, Long.class);
    }

    @Override
    public Float getAsFloat(String propertyName) {
        return this.getAs(propertyName, Float.class);
    }

    @Override
    public Double getAsDouble(String propertyName) {
        return this.getAs(propertyName, Double.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ElementData> T getOrAdd(String elementDataKey, FlowElement.DataFactory<T> dataFactory) {
        TypedKeyDefault typedKey = new TypedKeyDefault(elementDataKey, ElementData.class);
        if (!this.data.containsKey(elementDataKey)) {
            if (this.pipeline.isConcurrent()) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.data.containsKey(elementDataKey)) {
                        this.data.put(typedKey, dataFactory.create(this));
                    }
                }
            } else {
                this.data.put(typedKey, dataFactory.create(this));
            }
        }
        return (T)((ElementData)this.data.get(typedKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ElementData> T getOrAdd(TypedKey<T> key, FlowElement.DataFactory<T> dataFactory) {
        ElementData result;
        TypedKeyDefault untypedKey = new TypedKeyDefault(key.getName(), Object.class);
        if (!this.data.containsKey(key)) {
            if (this.pipeline.isConcurrent()) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.data.containsKey(key)) {
                        this.data.put(key, dataFactory.create(this));
                    }
                }
            } else {
                this.data.put(key, dataFactory.create(this));
            }
        }
        try {
            result = (ElementData)this.data.get(key);
        }
        catch (ClassCastException e) {
            String message = "Failed to cast data '" + key.getName() + "'. Expected data type is '" + key.getType().getSimpleName() + "'";
            this.logger.error(message);
            throw e;
        }
        return (T)result;
    }

    @Override
    public Map<String, Object> elementDataAsMap() {
        return this.data.asStringKeyMap();
    }

    @Override
    public Iterable<ElementData> elementDataAsIterable() {
        ArrayList<ElementData> result = new ArrayList<ElementData>();
        for (Object elementData : this.data.asStringKeyMap().values()) {
            result.add((ElementData)elementData);
        }
        return result;
    }

    @Override
    public Map<String, String> getWhere(PropertyMatcher matcher) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FlowElement element : this.pipeline.getFlowElements()) {
            for (Object propertyObject : element.getProperties()) {
                ElementPropertyMetaData property = (ElementPropertyMetaData)propertyObject;
                if (!property.isAvailable() || !matcher.isMatch(property)) continue;
                map.put(element.getElementDataKey() + "." + property.getName(), this.get(element.getElementDataKey()).get(property.getName().toLowerCase()).toString());
            }
        }
        return map;
    }

    @Override
    public DataKey generateKey(EvidenceKeyFilter filter) {
        Map<String, Object> evidenceMap = this.evidence.asKeyMap();
        DataKeyBuilderDefault builder = new DataKeyBuilderDefault();
        for (String key : evidenceMap.keySet()) {
            if (!filter.include(key)) continue;
            builder.add(filter.order(key), key, evidenceMap.get(key));
        }
        return builder.build();
    }

    @Override
    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return this.pipeline.getEvidenceKeyFilter();
    }

    @Override
    public void close() throws Exception {
        for (Object elementData : this.data.asStringKeyMap().values()) {
            if (!AutoCloseable.class.isAssignableFrom(elementData.getClass())) continue;
            ((AutoCloseable)elementData).close();
        }
    }
}

