/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.util.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public abstract class FlowElementBase<TData extends ElementData, TProperty extends ElementPropertyMetaData>
implements FlowElement<TData, TProperty> {
    protected final Logger logger;
    protected TypedKey<TData> typedKey = null;
    private boolean closed = false;
    private final List<Pipeline> pipelines = new ArrayList<Pipeline>();
    private final FlowElement.DataFactory<TData> dataFactory;

    public FlowElementBase(Logger logger, ElementDataFactory<TData> elementDataFactory) {
        this.logger = logger;
        logger.debug("FlowElement '" + this.getClass().getSimpleName() + "'-'" + this.hashCode() + "' created.");
        this.dataFactory = new DataFactoryInternal<TData>(elementDataFactory, this);
    }

    protected abstract void processInternal(FlowData var1) throws Exception;

    @Override
    public void addPipeline(Pipeline pipeline) {
        this.pipelines.add(pipeline);
    }

    public List<Pipeline> getPipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    @Override
    public abstract String getElementDataKey();

    @Override
    public abstract EvidenceKeyFilter getEvidenceKeyFilter();

    @Override
    public abstract List<TProperty> getProperties();

    @Override
    public TProperty getProperty(String name) {
        for (ElementPropertyMetaData property : this.getProperties()) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return (TProperty)property;
        }
        return null;
    }

    @Override
    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault<TData>(this.getElementDataKey(), Types.findSubClassParameterType(this, FlowElementBase.class, 0));
        }
        return this.typedKey;
    }

    @Override
    public void process(FlowData data) throws Exception {
        long startTime = 0L;
        if (!data.isStopped()) {
            this.logger.debug("FlowElement '{}-{}' started processing.", (Object)this.getClass().getSimpleName(), (Object)this.hashCode());
            startTime = System.currentTimeMillis();
        }
        this.processInternal(data);
        this.logger.debug("FlowElement '{}}-{}' finished processing. Elapsed time: {}ms", new Object[]{this.getClass().getSimpleName(), this.hashCode(), System.currentTimeMillis() - startTime});
    }

    @Override
    public FlowElement.DataFactory<TData> getDataFactory() {
        if (this.dataFactory == null) {
            this.logger.error("Need to specify an elementDataFactory in constructor for '" + this.getClass().getSimpleName() + "'.");
        }
        return this.dataFactory;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected abstract void managedResourcesCleanup();

    protected abstract void unmanagedResourcesCleanup();

    protected void close(boolean closing) {
        if (this.closed) {
            this.logger.debug("FlowElement '{}'-'{}' already closed.", (Object)this.getClass().getSimpleName(), (Object)this.hashCode());
        }
        if (closing) {
            this.managedResourcesCleanup();
        }
        this.unmanagedResourcesCleanup();
        this.closed = true;
        this.logger.debug("FlowElement '{}-{}' closed.", (Object)this.getClass().getSimpleName(), (Object)this.hashCode());
    }

    @Override
    public void close() throws Exception {
        this.close(true);
    }

    protected static class DataFactoryInternal<T extends ElementData>
    implements FlowElement.DataFactory<T> {
        private final ElementDataFactory<T> elementDataFactory;
        private final FlowElement<T, ?> element;

        DataFactoryInternal(ElementDataFactory<T> elementDataFactory, FlowElement<T, ?> element) {
            this.elementDataFactory = elementDataFactory;
            this.element = element;
        }

        @Override
        public T create(FlowData flowData) {
            return this.elementDataFactory.create(flowData, this.element);
        }
    }

    protected static class DataFactorySimple<T extends ElementData>
    implements FlowElement.DataFactory<T> {
        private final T value;

        public DataFactorySimple(T value) {
            this.value = value;
        }

        @Override
        public T create(FlowData flowData) {
            return this.value;
        }
    }
}

