/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterAggregator;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.FlowError;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;

class ParallelElements
extends FlowElementBase<ElementData, ElementPropertyMetaData> {
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private List<FlowElement> flowElements;
    private EvidenceKeyFilterAggregator evidenceKeyFilter;

    ParallelElements(Logger logger, List<FlowElement> flowElements) {
        super(logger, null);
        this.flowElements = flowElements;
    }

    List<FlowElement> getFlowElements() {
        return Collections.unmodifiableList(this.flowElements);
    }

    @Override
    protected void processInternal(FlowData flowData) throws Exception {
        ArrayList<FlowElementCallable> parallelCallers = new ArrayList<FlowElementCallable>(this.flowElements.size());
        for (FlowElement element : this.flowElements) {
            parallelCallers.add(new FlowElementCallable(element, flowData));
        }
        try {
            List results = this.threadPool.invokeAll(parallelCallers);
            for (Future future : results) {
                FlowError error = (FlowError)future.get();
                if (error == null) continue;
                flowData.addError(error);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            flowData.addError(e, this);
        }
    }

    @Override
    public String getElementDataKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EvidenceKeyFilter getEvidenceKeyFilter() {
        if (this.evidenceKeyFilter == null) {
            this.evidenceKeyFilter = new EvidenceKeyFilterAggregator();
            for (FlowElement element : this.flowElements) {
                this.evidenceKeyFilter.addFilter(element.getEvidenceKeyFilter());
            }
        }
        return this.evidenceKeyFilter;
    }

    @Override
    public List<ElementPropertyMetaData> getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    @Override
    protected void managedResourcesCleanup() {
        for (FlowElement element : this.flowElements) {
            try {
                element.close();
            }
            catch (Exception exception) {}
        }
        this.threadPool.shutdown();
        this.flowElements = null;
    }

    @Override
    protected void unmanagedResourcesCleanup() {
    }

    private static class FlowElementCallable
    implements Callable<FlowError> {
        private final FlowData _flowData;
        private final FlowElement _element;

        private FlowElementCallable(FlowElement element, FlowData flowData) {
            this._element = element;
            this._flowData = flowData;
        }

        @Override
        public FlowError call() {
            try {
                this._element.process(this._flowData);
            }
            catch (Throwable e) {
                return new FlowError.Default(e, this._element);
            }
            return null;
        }
    }
}

