/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.annotations.AlternateName;
import fiftyone.pipeline.annotations.BuildArg;
import fiftyone.pipeline.annotations.ElementBuilder;
import fiftyone.pipeline.core.configuration.ElementOptions;
import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.ParallelElements;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilderBase;
import fiftyone.pipeline.core.flowelements.PipelineBuilderFromConfiguration;
import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.util.Check;
import fiftyone.pipeline.util.FiftyOneLookup;
import fiftyone.pipeline.util.StringManipulation;
import fiftyone.pipeline.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.text.StringSubstitutor;
import org.reflections8.Configuration;
import org.reflections8.Reflections;
import org.reflections8.util.ConfigurationBuilder;
import org.slf4j.ILoggerFactory;

public class PipelineBuilder
extends PipelineBuilderBase<PipelineBuilder>
implements PipelineBuilderFromConfiguration {
    private final Map<Class<?>, Class<?>> primitiveTypes = Types.getPrimitiveTypeMap();
    private final Set<Class<?>> elementBuilders = PipelineBuilder.getAvailableElementBuilders();

    public PipelineBuilder() {
    }

    public PipelineBuilder(ILoggerFactory loggerFactory) {
        super(loggerFactory);
    }

    @Override
    public Pipeline buildFromConfiguration(PipelineOptions options) throws Exception {
        Check.getNotNull(options, "Options cannot be null");
        this.flowElements.clear();
        int counter = 0;
        try {
            for (ElementOptions elementOptions : options.elements) {
                if (elementOptions.subElements != null && elementOptions.subElements.size() > 0) {
                    this.addParallelElementsToList(this.flowElements, elementOptions, counter);
                } else {
                    this.addElementToList(this.flowElements, elementOptions, "element " + counter);
                }
                ++counter;
            }
            List<String> builderParams = this.processBuildParameters(options.pipelineBuilderParameters, this.getClass(), this, "pipeline");
            if (builderParams.size() != 0) {
                throw new PipelineConfigurationException("The following builder parameters could not be processed: " + StringManipulation.stringJoin(builderParams, ","));
            }
        }
        catch (PipelineConfigurationException ex) {
            this.logger.debug("Problem with pipeline configuration, failed to create pipeline.", (Throwable)ex);
            throw ex;
        }
        this.setAutoCloseElements(true);
        return this.build();
    }

    public static Set<Class<?>> getAvailableElementBuilders() {
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[0]);
        config.setInputsFilter((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.toLowerCase().contains("flowelements");
            }
        });
        config.setExpandSuperTypes(false);
        Reflections reflections = new Reflections((Configuration)config);
        return reflections.getTypesAnnotatedWith(ElementBuilder.class);
    }

    private void addElementToList(List<FlowElement> elements, ElementOptions elementOptions, String elementLocation) {
        Object result;
        if (elementOptions.builderName == null || elementOptions.builderName.isEmpty()) {
            throw new PipelineConfigurationException("A BuilderName must be specified for " + elementLocation + ".");
        }
        Class<?> builderType = this.getBuilderType(elementOptions.builderName);
        if (builderType == null) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class<?> builder : this.elementBuilders) {
                names.add(builder.getSimpleName());
            }
            throw new PipelineConfigurationException("Could not find builder matching '" + elementOptions.builderName + "' for " + elementLocation + ". Available builders are: " + StringManipulation.stringJoin(names, ","));
        }
        ArrayList<Method> buildMethods = new ArrayList<Method>();
        for (Method method : builderType.getMethods()) {
            if (!method.getName().equals("build") || method.isBridge()) continue;
            buildMethods.add(method);
        }
        if (buildMethods.size() == 0) {
            throw new PipelineConfigurationException("Builder '" + builderType.getName() + "' for " + elementLocation + " has no 'build' methods.");
        }
        Object builderInstance = this.getBuilder(builderType);
        if (builderInstance == null) {
            throw new PipelineConfigurationException("Builder '" + builderType.getName() + "' for " + elementLocation + " does not have a default constructor. i.e. One that takes no parameters. Or a constructor which takes an ILoggerFactory parameter.");
        }
        List<Object> buildParameterList = new ArrayList();
        if (elementOptions.buildParameters != null) {
            buildParameterList = this.processBuildParameters(elementOptions.buildParameters, builderType, builderInstance, elementLocation);
        }
        ArrayList<Method> possibleBuildMethods = new ArrayList<Method>();
        for (Method method : buildMethods) {
            if (method.getParameterTypes().length != buildParameterList.size()) continue;
            possibleBuildMethods.add(method);
        }
        if (possibleBuildMethods.size() != 1) {
            if (buildParameterList.size() > 0) {
                String exceptionMessage = String.format("Build parameters \"%s\" were not matched for Builder \"%s\".", StringManipulation.stringJoin(buildParameterList, ","), builderType.getName());
                throw new PipelineConfigurationException(exceptionMessage);
            }
            throw new PipelineConfigurationException("Builder '" + builderType.getName() + "' for " + elementLocation + " has " + (possibleBuildMethods.size() == 0 ? "no" : "multiple") + "'Build' methods that take " + buildParameterList.size() + " parameters. The supplied parameters must match one of the following signatures: " + StringManipulation.stringJoin(buildMethods, ", "));
        }
        ArrayList parameters = new ArrayList();
        Method buildMethod = (Method)possibleBuildMethods.get(0);
        Class<?>[] types = buildMethod.getParameterTypes();
        Annotation[][] annotations = buildMethod.getParameterAnnotations();
        for (int i = 0; i < types.length; ++i) {
            Object paramValue;
            TreeMap<String, Object> caseInsensitiveParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveParameters.putAll(elementOptions.buildParameters);
            Class<?> paramType = types[i];
            Annotation[] paramAnnotations = annotations.length > i ? annotations[i] : new Annotation[]{};
            BuildArg paramAnnotation = null;
            for (Annotation annotation : paramAnnotations) {
                if (!(annotation instanceof BuildArg)) continue;
                paramAnnotation = (BuildArg)annotation;
                break;
            }
            if (paramAnnotation == null) {
                throw new PipelineConfigurationException("Method 'build' on builder '" + builderType.getName() + "' for " + elementLocation + " is not annotated with the name of the parameter.");
            }
            if (paramType.equals(String.class)) {
                paramValue = caseInsensitiveParameters.get(paramAnnotation.value());
                if (paramValue instanceof String) {
                    paramValue = PipelineBuilder.evaluate((String)paramValue);
                }
            } else {
                paramValue = this.parseToType(paramType, caseInsensitiveParameters.get(paramAnnotation.value()).toString(), "Method 'build' on builder '" + builderType.getName() + "' for " + elementLocation + " expects a parameter of type '" + paramType.getName() + "'");
            }
            parameters.add(paramValue);
        }
        try {
            result = buildMethod.invoke(builderInstance, parameters.toArray());
        }
        catch (Exception e) {
            throw new PipelineConfigurationException("Failed to build " + elementLocation + " using '" + builderType.getName() + "'.", e);
        }
        if (result == null) {
            throw new PipelineConfigurationException("Failed to build " + elementLocation + " using '" + builderType.getName() + "', reason unknown.");
        }
        try {
            FlowElement element = (FlowElement)FlowElement.class.cast(result);
            elements.add(element);
        }
        catch (ClassCastException e) {
            String message = "Failed to cast '" + result.getClass().getName() + "' to 'FlowElement' for " + elementLocation;
            this.logger.debug(message);
            throw new PipelineConfigurationException(message, e);
        }
    }

    private void addParallelElementsToList(List<FlowElement> elements, ElementOptions elementOptions, int elementIndex) {
        if (elementOptions.builderName != null && !elementOptions.builderName.isEmpty() || elementOptions.buildParameters != null && elementOptions.buildParameters.size() > 0) {
            throw new PipelineConfigurationException("ElementOptions " + elementIndex + " contains both SubElements and other settings values. This is invalid");
        }
        ArrayList<FlowElement> parallelElements = new ArrayList<FlowElement>();
        int subCounter = 0;
        for (ElementOptions subElement : elementOptions.subElements) {
            if (subElement.subElements != null && subElement.subElements.size() > 0) {
                throw new PipelineConfigurationException("ElementOptions " + elementIndex + " contains nested sub elements. This is not supported.");
            }
            this.addElementToList(parallelElements, subElement, "element " + subCounter + " in element " + elementIndex);
            ++subCounter;
        }
        ParallelElements parallelInstance = new ParallelElements(this.loggerFactory.getLogger(ParallelElements.class.getName()), parallelElements);
        this.flowElements.add(parallelInstance);
    }

    private boolean paramsAreServices(Constructor<?> constructor) {
        for (Class<?> type : constructor.getParameterTypes()) {
            if (type.equals(ILoggerFactory.class) || PipelineService.class.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    private <T extends PipelineService> T getService(Class<T> serviceType) {
        for (PipelineService service : this.services) {
            if (!serviceType.isAssignableFrom(service.getClass())) continue;
            return (T)service;
        }
        return null;
    }

    private Constructor<?> getBestConstructor(List<Constructor<?>> constructors) {
        Constructor<?> bestConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (bestConstructor != null && constructor.getParameterTypes().length <= bestConstructor.getParameterTypes().length) continue;
            boolean hasServices = true;
            for (Class<?> type : constructor.getParameterTypes()) {
                if (type.equals(ILoggerFactory.class) || this.getService(type) != null) continue;
                hasServices = false;
                break;
            }
            if (!hasServices) continue;
            bestConstructor = constructor;
        }
        return bestConstructor;
    }

    private Object callConstructorWithServices(Constructor<?> constructor, Class<?> builderType) throws PipelineConfigurationException {
        Class<?>[] types = constructor.getParameterTypes();
        Object[] services = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            services[i] = types[i].equals(ILoggerFactory.class) ? this.loggerFactory : this.getService(types[i]);
        }
        try {
            return constructor.newInstance(services);
        }
        catch (Exception e) {
            throw new PipelineConfigurationException("Failed to create builder '" + builderType.getName() + "'. See inner, 'cause' exception for more details", e);
        }
    }

    private Object getBuilder(Class<?> builderType) throws PipelineConfigurationException {
        ArrayList defaultConstructors = new ArrayList();
        ArrayList loggerConstructors = new ArrayList();
        ArrayList serviceConstructors = new ArrayList();
        for (Constructor<?> constructor : builderType.getConstructors()) {
            if (constructor.getParameterTypes().length == 0) {
                defaultConstructors.add(constructor);
                continue;
            }
            if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(ILoggerFactory.class)) {
                loggerConstructors.add(constructor);
                continue;
            }
            if (constructor.getParameterTypes().length <= 1 || !this.paramsAreServices(constructor)) continue;
            serviceConstructors.add(constructor);
        }
        if (defaultConstructors.size() == 0 && loggerConstructors.size() == 0 && serviceConstructors.size() == 0) {
            return null;
        }
        if (serviceConstructors.size() != 0 && this.getBestConstructor(serviceConstructors) != null) {
            return this.callConstructorWithServices(this.getBestConstructor(serviceConstructors), builderType);
        }
        try {
            if (loggerConstructors.size() != 0) {
                return ((Constructor)loggerConstructors.get(0)).newInstance(this.loggerFactory);
            }
            return builderType.newInstance();
        }
        catch (Exception e) {
            throw new PipelineConfigurationException("Failed to create builder '" + builderType.getName() + "'. See inner, 'cause' exception for more details", e);
        }
    }

    private List<String> processBuildParameters(Map<String, Object> buildParameters, Class<?> builderType, Object builderInstance, String elementConfigLocation) {
        ArrayList<String> buildParameterList = new ArrayList<String>();
        for (Map.Entry<String, Object> parameter : buildParameters.entrySet()) {
            List<Method> methods = this.getMethods(parameter.getKey(), builderType.getMethods());
            if (methods.size() == 0) {
                buildParameterList.add(parameter.getKey().toLowerCase());
                continue;
            }
            boolean methodCalled = false;
            int counter = 0;
            while (!methodCalled && counter < methods.size()) {
                Method method = methods.get(counter);
                ++counter;
                Class<?>[] methodParams = method.getParameterTypes();
                if (methodParams.length != 1) {
                    throw new PipelineConfigurationException("Method '" + method.getName() + "' on builder '" + builderType.getName() + "' for " + elementConfigLocation + " takes " + (methodParams.length == 0 ? "no parameters " : "more than one parameter. ") + "This is not supported.");
                }
                try {
                    if (parameter.getValue().getClass().isArray()) {
                        for (Object value : (Object[])parameter.getValue()) {
                            this.tryParseAndCallMethod(value, method, builderType, builderInstance, elementConfigLocation);
                        }
                    } else {
                        Object paramValue = parameter.getValue();
                        if (paramValue instanceof String) {
                            paramValue = PipelineBuilder.evaluate((String)paramValue);
                        }
                        this.tryParseAndCallMethod(paramValue, method, builderType, builderInstance, elementConfigLocation);
                    }
                    methodCalled = true;
                }
                catch (PipelineConfigurationException e) {
                    if (counter != methods.size()) continue;
                    throw e;
                }
            }
        }
        return buildParameterList;
    }

    private void tryParseAndCallMethod(Object paramValue, Method method, Class<?> builderType, Object builderInstance, String elementConfigLocation) {
        Class<?> paramType = method.getParameterTypes()[0];
        if (!paramType.equals(String.class)) {
            paramValue = this.parseToType(paramType, paramValue.toString(), "Method '" + method.getName() + "' on builder '" + builderType.getName() + "' for " + elementConfigLocation + " expects a parameter of type '" + paramType.getName() + "'");
        }
        try {
            method.invoke(builderInstance, paramValue);
        }
        catch (Exception e) {
            throw new PipelineConfigurationException("Exception while calling the method '" + method.getName() + "' on builder '" + builderType.getName() + "'.", e);
        }
    }

    private List<Method> getMethods(String methodName, Method[] methods) {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        String lowerMethodName = methodName.toLowerCase();
        for (int tries = 0; tries < 3 && matchingMethods.size() == 0; ++tries) {
            ArrayList<Method> potentialMethods = null;
            switch (tries) {
                case 0: {
                    for (Method method : methods) {
                        if (!method.getName().toLowerCase().equals(lowerMethodName)) continue;
                        matchingMethods.add(method);
                    }
                    break;
                }
                case 1: {
                    String tempName = "set" + lowerMethodName;
                    for (Method method : methods) {
                        if (!method.getName().toLowerCase().equals(tempName)) continue;
                        matchingMethods.add(method);
                    }
                    break;
                }
                case 2: {
                    ArrayList<Method> tempMethods = new ArrayList<Method>();
                    for (Method method : methods) {
                        try {
                            AlternateName alternateName = method.getAnnotation(AlternateName.class);
                            if (alternateName.value().toLowerCase().equals(lowerMethodName)) {
                                tempMethods.add(method);
                                continue;
                            }
                            if (!alternateName.value().toLowerCase().equals("set" + lowerMethodName)) continue;
                            tempMethods.add(method);
                        }
                        catch (Exception e) {
                            this.logger.debug("Exception while attempting to geta set method with an alternate name annotation.Name was '" + lowerMethodName + "'", (Throwable)e);
                        }
                    }
                    potentialMethods = tempMethods;
                    break;
                }
            }
            if (potentialMethods == null || potentialMethods.size() <= 0) continue;
            matchingMethods = potentialMethods;
        }
        return matchingMethods;
    }

    private Class<?> getBuilderType(String builderName) {
        Class builderType = null;
        String lowerBuilderName = builderName.toLowerCase();
        for (int tries = 0; tries < 3 && builderType == null; ++tries) {
            ArrayList<Object> potentialBuilders = new ArrayList<Object>();
            switch (tries) {
                case 0: {
                    for (Class<?> builder : this.elementBuilders) {
                        if (!builder.getSimpleName().toLowerCase().equals(lowerBuilderName)) continue;
                        potentialBuilders.add(builder);
                    }
                    break;
                }
                case 1: {
                    Class<?> builder;
                    String tempName = lowerBuilderName + "builder";
                    builder = this.elementBuilders.iterator();
                    while (builder.hasNext()) {
                        Object builder2 = (Class)builder.next();
                        if (!((Class)builder2).getSimpleName().toLowerCase().equals(tempName)) continue;
                        potentialBuilders.add(builder2);
                    }
                    break;
                }
                case 2: {
                    ArrayList builders = new ArrayList();
                    for (Class<?> builder : this.elementBuilders) {
                        for (Annotation annotation : builder.getAnnotations()) {
                            if (!(annotation instanceof ElementBuilder) || !((ElementBuilder)annotation).alternateName().toLowerCase().equals(lowerBuilderName)) continue;
                            builders.add(builder);
                        }
                    }
                    potentialBuilders = builders;
                    break;
                }
            }
            if (potentialBuilders.size() <= 0) continue;
            if (potentialBuilders.size() > 1) {
                ArrayList<String> names = new ArrayList<String>();
                for (Object builder2 : potentialBuilders) {
                    names.add(((Class)builder2).getName());
                }
                throw new PipelineConfigurationException("The flow element builder name '" + builderName + "'matches multiple builders: [" + StringManipulation.stringJoin(names, ",") + "].");
            }
            try {
                builderType = (Class)potentialBuilders.get(0);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                builderType = null;
            }
        }
        return builderType;
    }

    private Object parseToType(Class<?> targetType, String value, String errorTextPrefix) {
        Object parsedValue;
        Method parse = null;
        Class<?> nonPrimitiveType = targetType.isPrimitive() ? this.primitiveTypes.get(targetType) : targetType;
        for (Method method : nonPrimitiveType.getMethods()) {
            if (!method.getName().startsWith("parse") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            parse = method;
            break;
        }
        if (parse == null) {
            throw new PipelineConfigurationException(errorTextPrefix + " but this type does not have the expected 'parse' method (or has multiples that cannot be resolved).");
        }
        try {
            parsedValue = parse.invoke(new Object(), value);
        }
        catch (Exception e) {
            throw new PipelineConfigurationException(errorTextPrefix + ". Failed to parse value '" + value + "' using the static 'parse' method.");
        }
        return parsedValue;
    }

    public static String evaluate(String value) {
        StringSubstitutor substitutor = FiftyOneLookup.getSubstitutor();
        return substitutor.replace(value);
    }
}

